/*
 * ATmega128A_USART.asm
 */ 

;*****************************************************************************
;C:\Program Files (x86)\Atmel\Atmel Toolchain\AVR Assembler\Native\2.1.39.1005\avrassembler\include
.include "m128Adef.inc" 

;*****************************************************************************
; SRAM
;*****************************************************************************
.DSEG ; SRAM
.ORG SRAM_START ; dbut de la mmoire disponible pour luser (0x100)

;------------------------------------------------------------------------
;Declaration des Vecteurs d'interruptions
;------------------------------------------------------------------------
.CSEG ;Segment de Code ;memoire FLASH
.org $0000 ;Set address of next statement
	jmp RESET ; Reset Handler
	jmp EXT_INT0 ; IRQ0 Handler
	jmp EXT_INT1 ; IRQ1 Handler
	jmp EXT_INT2 ; IRQ2 Handler
	jmp EXT_INT3 ; IRQ3 Handler
	jmp EXT_INT4 ; IRQ4 Handler
	jmp EXT_INT5 ; IRQ5 Handler
	jmp EXT_INT6 ; IRQ6 Handler
	jmp EXT_INT7 ; IRQ7 Handler
	jmp TIM2_COMP ; Timer2 Compare Handler
	jmp TIM2_OVF ; Timer2 Overflow Handler
	jmp TIM1_CAPT ; Timer1 Capture Handler
	jmp TIM1_COMPA ; Timer1 CompareA Handler
	jmp TIM1_COMPB ; Timer1 CompareB Handler
	jmp TIM1_OVF ; Timer1 Overflow Handler
	jmp TIM0_COMP ; Timer0 Compare Handler
	jmp TIM0_OVF ; Timer0 Overflow Handler
	jmp SPI_STC ; SPI Transfer Complete Handler
	jmp USART0_RXC ; USART0 RX Complete Handler
	jmp USART0_DRE ; USART0,UDR Empty Handler
	jmp USART0_TXC ; USART0 TX Complete Handler
	jmp INT_ADC ; ADC Conversion Complete Handler
	jmp EE_RDY ; EEPROM Ready Handler
	jmp ANA_COMP ; Analog Comparator Handler
	jmp TIM1_COMPC ; Timer1 CompareC Handler
	jmp TIM3_CAPT ; Timer3 Capture Handler
	jmp TIM3_COMPA ; Timer3 CompareA Handler
	jmp TIM3_COMPB ; Timer3 CompareB Handler
	jmp TIM3_COMPC ; Timer3 CompareC Handler
	jmp TIM3_OVF ; Timer3 Overflow Handler
	jmp USART1_RXC ; USART1 RX Complete Handler
	jmp USART1_DRE ; USART1,UDR Empty Handler
	jmp USART1_TXC ; USART1 TX Complete Handler
	jmp TWI ; Two-wire Serial Interface Interrupt Handler
	jmp SPM_RDY ; SPM Ready Handler

;***************************************************
;				Partie Programme
;***************************************************
RESET:
	ldi r16, high(RAMEND); Main program start
	out SPH,r16 ; Set stack pointer to top of RAM
	ldi r16, low(RAMEND)
	out SPL,r16

;---Initialisation Port A
	ldi r16,$01 ;Port en sortie (le bit 0 du port A est mis  1, soit en sortie)
	out DDRA, r16 ;Ecriture de la valeur r16 dans DDRB

;---Initialisation USART1
	ldi r16, (1 << UCSZ11) | (1 << UCSZ10) | (1 << UPM11) ; // data sur 8bits et parit EVEN
	sts UCSR1C, r16
	ldi r16, (1 << U2X1); //double la vitesse de transfer
	sts UCSR1A, r16;  //double la vitesse de transfer
	ldi r16, (1 << RXEN1) | (1 << TXEN1);	// activation de RX et TX
	sts UCSR1B,r16 ; // activation de RX et TX

	ldi r16, $33; 51 //  BAUD_RATE_19200 (voir page 189 pour le calcul)
	sts UBRR1L, r16;

Start:
	USART_Transmit:
	; Wait for empty transmit buffer
	lds r16, UCSR1A
	sbrs r16, UDRE1
	rjmp USART_Transmit
	; Put data (r16) into buffer, sends the data
	ldi r16, $55
	sts UDR1,r16
	sts UDR1,r16

	;ldi r16,$00 ;Port en bas (les bits du port sont mis  0, Led teinte)
	;out PORTA, r16 ;Port B mis  zro
	;ldi r16,$01 ;Port en bas (les bits du port sont mis  0, Led teinte)
	;out PORTA, r16 ;Port B mis  zro
	
rjmp Start
;***************************************************
;          Interruptions non utilises
;***************************************************
EXT_INT0: ; IRQ0 Handler
EXT_INT1: ; IRQ1 Handler
EXT_INT2: ; IRQ2 Handler
EXT_INT3: ; IRQ3 Handler
EXT_INT4: ; IRQ4 Handler
EXT_INT5: ; IRQ5 Handler
EXT_INT6: ; IRQ6 Handler
EXT_INT7: ; IRQ7 Handler
TIM2_COMP: ; Timer2 Compare Handler
TIM2_OVF: ; Timer2 Overflow Handler
TIM1_CAPT: ; Timer1 Capture Handler
TIM1_COMPA:; Timer1 CompareA Handler
TIM1_COMPB: ; Timer1 CompareB Handler
TIM1_OVF: ; Timer1 Overflow Handler
TIM0_COMP: ; Timer0 Compare Handler
TIM0_OVF: ; Timer0 Overflow Handler
SPI_STC: ; SPI Transfer Complete Handler
USART0_RXC: ; USART0 RX Complete Handler
USART0_DRE: ; USART0,UDR Empty Handler
USART0_TXC: ; USART0 TX Complete Handler
INT_ADC: ; ADC Conversion Complete Handler
EE_RDY: ; EEPROM Ready Handler
ANA_COMP: ; Analog Comparator Handler
TIM1_COMPC: ; Timer1 CompareC Handler
TIM3_CAPT: ; Timer3 Capture Handler
TIM3_COMPA: ; Timer3 CompareA Handler
TIM3_COMPB: ; Timer3 CompareB Handler
TIM3_COMPC: ; Timer3 CompareC Handler
TIM3_OVF: ; Timer3 Overflow Handler
USART1_RXC: ; USART1 RX Complete Handler
USART1_DRE: ; USART1,UDR Empty Handler
USART1_TXC: ; USART1 TX Complete Handler
TWI: ; Two-wire Serial Interface Interrupt Handler
SPM_RDY: ; SPM Ready Handler
	nop ;Ne rien faire dans cette interruption
	reti ;Fin de linterruption
