#ifndef _CORE_H
#define _CORE_H

#include "Define.h"

class Core
{
	private:
	static const float _DEGREE_TO_RADIAN;
	static const float _RADIAN_TO_DEGREE;
	static unsigned char _countSpiDevice [20];
	
	public:
	static unsigned long us();
	static void startGlobalInterrupt();
	static volatile unsigned char *pinToRegisterPort (const unsigned char PIN);
	static volatile unsigned char *pinToRegisterDdr (const unsigned char PIN);
	static volatile unsigned char *pinToRegisterPin (const unsigned char PIN);
	static unsigned char pinToBytePort (const unsigned char PIN);
	static unsigned char pinToTimer (const unsigned char PIN);
	static unsigned char pinToChannel (const unsigned char PIN);
	static unsigned int frequencyToPrescaler (const unsigned int FREQUENCY, const unsigned char TIMER);
	static void modeTimer (const unsigned char TIMER, const unsigned char MODE);
	static void prescalerTimer (const unsigned char TIMER, const unsigned int PRESCALER);
	static void topTimer (const unsigned char TIMER, const unsigned char CHANNEL, const unsigned int VALUE);
	static void startInterruptTimer (const unsigned char TIMER, const unsigned char CHANNEL);
	static void stopInterruptTimer (const unsigned char TIMER, const unsigned char CHANNEL);
	static unsigned char pinToInterrupt (const unsigned char PIN);
	static void startInterrupt (const unsigned char INTERRUPT, const bool FALLING);
	static void stopInterrupt (const unsigned char INTERRUPT);
	static volatile unsigned char *pinToRegisterPcmsk (const unsigned char PIN);
	static unsigned char pinToBytePcie (const unsigned char PIN);
	static void startPinChangeInterrupt (const unsigned char BYTE_PCIE);
	static void stopPinChangeInterrupt();
	static unsigned char digitToByte (const unsigned char DIGIT, const bool COMMA);
	static unsigned char characterToByte (const char CHARACTER);
	static void startUsart (const bool RECEIVER, const bool TRANSMITTER);
	static signed long readUsart (const signed char LENGTH);
	static void writeUsart (const signed long DATA, const signed char LENGTH);
	static void startSpi (const unsigned char PIN_SS);
	static signed long readSpi (const unsigned char ADDRESS, const signed char LENGTH);
	static signed long readSpiPush (const signed char LENGTH);
	static void writeSpi (const unsigned char ADDRESS, const signed long DATA, const signed char LENGTH);
	static void writeSpiPush (const signed long DATA, const signed char LENGTH);
	static void writeSpiCascaded (const unsigned char PIN_SS, const unsigned char DEVICE, const unsigned char ADDRESS, const signed long DATA, const signed char LENGTH);
	static void startAnalog();
	static unsigned int readAnalog (const unsigned char PIN);
	static void startTwi();
	static bool scanTwi (const unsigned char DEVICE);
	static signed long readTwi (const unsigned char DEVICE, const unsigned char ADDRESS, const signed char LENGTH);
	static void writeTwi (const unsigned char DEVICE, const unsigned char ADDRESS, const signed long DATA, const signed char LENGTH);
	static unsigned char readEeprom (const unsigned char ADDRESS);
	static void writeEeprom (const unsigned char ADDRESS, const unsigned char DATA);
	static signed long floor (const float VALUE);
	static signed long round (const float VALUE);
	static signed long ceil (const float VALUE);
	static float curve (const float POSITION_START, const float POSITION_CURRENT, const float POSITION_END, const float INTERPOLATION_START, const float INTERPOLATION_END, const unsigned char CURVE);
	static float sqrt (const float SQUARED);
	static float pow (const float NUMBER, const signed long EXPONENT);
	static float sin (const float ANGLE);
	static float cos (const float ANGLE);
	static float tan (const float ANGLE);
	static float arcsin (const float SINUS);
	static float arccos (const float COSINUS);
	static float arctan (const float TANGENT);
	static void power (const bool POWER);
};

const float Core::_DEGREE_TO_RADIAN = 0.0174532925199432;
const float Core::_RADIAN_TO_DEGREE = 57.2957795130823208;
unsigned char Core::_countSpiDevice [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

#include "Core.cpp"

#endif
