Delay::Delay (const unsigned long DURATION, const bool NO_START_DELAY)
{
	_duration = DURATION * 1000l;
	_noStartDelay = NO_START_DELAY;
	
	Core::prescalerTimer (0, 64);
	Core::startInterruptTimer (0, 2);
	Core::startGlobalInterrupt();
}

void Delay::state()
{
	if (started == false)
	{
		if (_noStartDelay == false)
		{
			_timePrevious = Core::us() + _duration;
		}
		else
		{
			_timePrevious = Core::us();
		}
		
		started = true;
	}
	
	if (Core::us() >= _timePrevious)
	{
		_timePrevious += _duration;
		update = true;
	}
	else
	{
		update = false;
	}
}

void Delay::set (const unsigned long DURATION)
{
	_duration = DURATION * 1000l;
}

void Delay::reset()
{
	started = false;
	update = false;
}
