Hmc5883L::Hmc5883L (const unsigned char DEVICE)
{
	unsigned char n = 0;
	bool foundDevice = false;
	
	Core::startTwi();
	
	if (DEVICE == 0)
	{
		for (n = 0; n < 128 && foundDevice == false; n++)
		{
			if (Core::scanTwi (n) == true)
			{
				_device = n;
				foundDevice = true;
			}
		}
	}
	else
	{
		_device = DEVICE;
	}
	
	while (Core::readTwi (_device, 0x09, 8) == 0b00000010)
	{
	}
	
	Core::writeTwi (_device, 0x00, 0b00011000, 8);
	Core::writeTwi (_device, 0x02, 0b00000000, 8);
}

void Hmc5883L::read()
{
	mx = float (Core::readTwi (_device, 0x04, 16)) / 1090.0;
	my = float (Core::readTwi (_device, 0x08, 16)) / 1090.0;
	mz = float (Core::readTwi (_device, 0x06, 16)) / 1090.0;
}
