typedef void (*__interruptReadFunction)();

volatile __interruptReadFunction __interruptReadFunctionJump [2] = {0, 0};

_INTERRUPT_JUMP (_INT0)
{
	__interruptReadFunctionJump [0]();
}

_INTERRUPT_JUMP (_INT1)
{
	__interruptReadFunctionJump [1]();
}

InterruptRead::InterruptRead (const unsigned char PIN)
{
	_interrupt = Core::pinToInterrupt (PIN);
}

void InterruptRead::start (void functionJump(), const bool FALLING)
{
	__interruptReadFunctionJump [_interrupt] = functionJump;
	
	Core::startInterrupt (_interrupt, FALLING);
	Core::startGlobalInterrupt();
}

void InterruptRead::stop()
{
	Core::stopInterrupt (_interrupt);
	__interruptReadFunctionJump [_interrupt] = 0;
}
