signed long Math::floor (const float VALUE)
{
	return Core::floor (VALUE);
}

signed long Math::round (const float VALUE)
{
	return Core::round (VALUE);
}

signed long Math::ceil (const float VALUE)
{
	return Core::ceil (VALUE);
}

float Math::curve (const float POSITION_START, const float POSITION_CURRENT, const float POSITION_END, const float INTERPOLATION_START, const float INTERPOLATION_END, const unsigned char CURVE)
{
	return Core::curve (POSITION_START, POSITION_CURRENT, POSITION_END, INTERPOLATION_START, INTERPOLATION_END, CURVE);
}

float Math::wurve (const float POSITION_START, const float POSITION_CURRENT, const float POSITION_END, const float INTERPOLATION_START, const float INTERPOLATION_CENTER, const float INTERPOLATION_END, const unsigned char CURVE_START, const unsigned char CURVE_END)
{
	const float POSITION_CENTER = POSITION_START + ((POSITION_END - POSITION_START) / 2.0);
	float value = 0;
	
	if (POSITION_CURRENT < POSITION_CENTER)
	{
		value = Core::curve (POSITION_START, POSITION_CURRENT, POSITION_CENTER, INTERPOLATION_START, INTERPOLATION_CENTER, CURVE_START);
	}
	else if (POSITION_CURRENT > POSITION_CENTER)
	{
		value = Core::curve (POSITION_CENTER, POSITION_CURRENT, POSITION_END, INTERPOLATION_CENTER, INTERPOLATION_END, CURVE_END);
	}
	else
	{
		value = INTERPOLATION_CENTER;
	}
	
	return value;
}

float Math::range (const float RANGE_START, const float VALUE_CURRENT, const float RANGE_END, const bool INVERT)
{
	float value = 0;
	
	if ((RANGE_START < RANGE_END && VALUE_CURRENT <= RANGE_START) || (RANGE_START > RANGE_END && VALUE_CURRENT >= RANGE_START))
	{
		value = RANGE_START;
	}
	else if ((RANGE_START < RANGE_END && VALUE_CURRENT >= RANGE_END) || (RANGE_START > RANGE_END && VALUE_CURRENT <= RANGE_END))
	{
		value = RANGE_END;
	}
	else
	{
		value = VALUE_CURRENT;
	}
	
	if (INVERT == true)
	{
		value *= -1;
	}
	
	return value;
}

float Math::center (const float VALUE_START, const float VALUE_END)
{
	float value = 0;
	
	if (VALUE_START < VALUE_END)
	{
		value = VALUE_END - ((VALUE_END - VALUE_START) / 2.0);
	}
	else if (VALUE_START > VALUE_END)
	{
		value = VALUE_START - ((VALUE_START - VALUE_END) / 2.0);
	}
	else
	{
		value = VALUE_START;
	}
	
	return value;
}

float Math::sqrt (const float SQUARED)
{
	return Core::sqrt (SQUARED);
}

float Math::pow (const float NUMBER, const unsigned long EXPONENT)
{
	return Core::pow (NUMBER, EXPONENT);
}

float Math::sin (const float ANGLE)
{
	return Core::sin (ANGLE);
}

float Math::cos (const float ANGLE)
{
	return Core::cos (ANGLE);
}

float Math::tan (const float ANGLE)
{
	return Core::tan (ANGLE);
}

float Math::arcsin (const float SINUS)
{
	return Core::arcsin (SINUS);
}

float Math::arccos (const float COSINUS)
{
	return Core::arccos (COSINUS);
}

float Math::arctan (const float TANGENT)
{
	return Core::arctan (TANGENT);
}
