Nrf24L01P::Nrf24L01P (const unsigned char ADDRESS)
{
	_address = ADDRESS - 1;
}

void Nrf24L01P::start (const unsigned char PIN_SS, const unsigned long ID, const bool POWER)
{
	_registerPin = Core::pinToRegisterPin (PIN_SS);
	_bytePort = Core::pinToBytePort (PIN_SS);
	
	*Core::pinToRegisterDdr (PIN_SS) |= _bytePort;
	*Core::pinToRegisterPort (PIN_SS) |= _bytePort;
	
	Core::startSpi (0);
	
	*_registerPin = _bytePort;
	
	if (POWER == false)
	{
		Core::writeSpi (0x06 | 0x20, 0b00100000, 8);
	}
	else
	{
		Core::writeSpi (0x06 | 0x20, 0b00100110, 8);
	}
	
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x03 | 0x20, 0b00000010, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x11 | 0x20, 0b00000101, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x0a | 0x20, ID, 32);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x10 | 0x20, ID, 32);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x02 | 0x20, 0b00000001, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x00 | 0x20, 0b01111011, 8);
	*_registerPin = _bytePort;
	
	Core::prescalerTimer (0, 64);
	Core::startInterruptTimer (0, 2);
	Core::startGlobalInterrupt();
}

void Nrf24L01P::receive()
{
	unsigned char status = 0;
	unsigned char address = 0;
	
	*_registerPin = _bytePort;
	status = Core::readSpi (0x07, 8);
	*_registerPin = _bytePort;
	
	if ((status & 0b01000000) == 0b01000000)
	{
		*_registerPin = _bytePort;
		address = Core::readSpi (0x61, 8);
		_data [address] = Core::readSpiPush (32);
		*_registerPin = _bytePort;
		
		*_registerPin = _bytePort;
		Core::writeSpi (0xe2, 0b00000000, 8);
		*_registerPin = _bytePort;
		
		*_registerPin = _bytePort;
		Core::writeSpi (0x07 | 0x20, 0b01000000, 8);
		*_registerPin = _bytePort;
	}
	
	value = _data [_address];
}

void Nrf24L01P::transmit (const signed long DATA)
{
	unsigned long timePrevious = 0;
	unsigned char status = 0;
	
	*_registerPin = _bytePort;
	status = Core::readSpi (0x07, 8);
	*_registerPin = _bytePort;
	
	if ((status & 0b01000000) == 0b00000000)
	{
		timePrevious = Core::us();
		
		while (Core::us() < timePrevious + 1000l)
		{
		}
	}
	
	status = 0b00000000;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x00 | 0x20, 0b01111000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x00 | 0x20, 0b01111010, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0xa0, _address, 8);
	Core::writeSpiPush (DATA, 32);
	*_registerPin = _bytePort;
	
	while ((status & 0b00110000) == 0b00000000)
	{
		*_registerPin = _bytePort;
		status = Core::readSpi (0x07, 8);
		*_registerPin = _bytePort;
	}
	
	if ((status & 0b00100000) == 0b00100000)
	{
		_data [_address] = value;
		value = DATA;
	}
	
	*_registerPin = _bytePort;
	Core::writeSpi (0xe1, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x07 | 0x20, 0b00110000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x00 | 0x20, 0b01111001, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x00 | 0x20, 0b01111011, 8);
	*_registerPin = _bytePort;
}
