volatile unsigned char __pwmReadCount = 0;
volatile unsigned char __pwmReadN = 0;
volatile bool __pwmReadCheck [20] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
volatile unsigned char *__pwmReadRegisterPin [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char __pwmReadBytePort [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char *__pwmReadRegisterPcmsk [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char __pwmReadBytePcie [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile bool __pwmReadFalling [20] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
volatile bool __pwmReadFirstFalling = false;
volatile unsigned long __pwmReadTimePrevious = 0;
volatile unsigned long __pwmReadDuration [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile bool __pwmReadValuePin = false;

_INTERRUPT_JUMP (_PCINT0)
{
	__pwmReadValuePin = *__pwmReadRegisterPin [__pwmReadN] & __pwmReadBytePort [__pwmReadN];
	
	if (((__pwmReadFalling [__pwmReadN] == false && __pwmReadValuePin == true) || (__pwmReadFalling [__pwmReadN] == true && __pwmReadValuePin == false)) && __pwmReadFirstFalling == false)
	{
		__pwmReadTimePrevious = Core::us();
		__pwmReadFirstFalling = true;
	}
	else if (((__pwmReadFalling [__pwmReadN] == false && __pwmReadValuePin == false) || (__pwmReadFalling [__pwmReadN] == true && __pwmReadValuePin == true)) && __pwmReadFirstFalling == true)
	{
		Core::stopPinChangeInterrupt();
		*__pwmReadRegisterPcmsk [__pwmReadN] = 0b00000000;
		
		__pwmReadDuration [__pwmReadN] = Core::us() - __pwmReadTimePrevious;
		__pwmReadFirstFalling = false;
		__pwmReadCheck [__pwmReadN] = true;
		
		if (__pwmReadN < __pwmReadCount - 1)
		{
			__pwmReadN++;
		}
		else
		{
			__pwmReadN = 0;
		}
		
		*__pwmReadRegisterPcmsk [__pwmReadN] = __pwmReadBytePort [__pwmReadN];
		Core::startPinChangeInterrupt (__pwmReadBytePcie [__pwmReadN]);
	}
}

_INTERRUPT_JUMP (_PCINT1)
{
	__pwmReadValuePin = *__pwmReadRegisterPin [__pwmReadN] & __pwmReadBytePort [__pwmReadN];
	
	if (((__pwmReadFalling [__pwmReadN] == false && __pwmReadValuePin == true) || (__pwmReadFalling [__pwmReadN] == true && __pwmReadValuePin == false)) && __pwmReadFirstFalling == false)
	{
		__pwmReadTimePrevious = Core::us();
		__pwmReadFirstFalling = true;
	}
	else if (((__pwmReadFalling [__pwmReadN] == false && __pwmReadValuePin == false) || (__pwmReadFalling [__pwmReadN] == true && __pwmReadValuePin == true)) && __pwmReadFirstFalling == true)
	{
		Core::stopPinChangeInterrupt();
		*__pwmReadRegisterPcmsk [__pwmReadN] = 0b00000000;
		
		__pwmReadDuration [__pwmReadN] = Core::us() - __pwmReadTimePrevious;
		__pwmReadFirstFalling = false;
		__pwmReadCheck [__pwmReadN] = true;
		
		if (__pwmReadN < __pwmReadCount - 1)
		{
			__pwmReadN++;
		}
		else
		{
			__pwmReadN = 0;
		}
		
		*__pwmReadRegisterPcmsk [__pwmReadN] = __pwmReadBytePort [__pwmReadN];
		Core::startPinChangeInterrupt (__pwmReadBytePcie [__pwmReadN]);
	}
}

_INTERRUPT_JUMP (_PCINT2)
{
	__pwmReadValuePin = *__pwmReadRegisterPin [__pwmReadN] & __pwmReadBytePort [__pwmReadN];
	
	if (((__pwmReadFalling [__pwmReadN] == false && __pwmReadValuePin == true) || (__pwmReadFalling [__pwmReadN] == true && __pwmReadValuePin == false)) && __pwmReadFirstFalling == false)
	{
		__pwmReadTimePrevious = Core::us();
		__pwmReadFirstFalling = true;
	}
	else if (((__pwmReadFalling [__pwmReadN] == false && __pwmReadValuePin == false) || (__pwmReadFalling [__pwmReadN] == true && __pwmReadValuePin == true)) && __pwmReadFirstFalling == true)
	{
		Core::stopPinChangeInterrupt();
		*__pwmReadRegisterPcmsk [__pwmReadN] = 0b00000000;
		
		__pwmReadDuration [__pwmReadN] = Core::us() - __pwmReadTimePrevious;
		__pwmReadFirstFalling = false;
		__pwmReadCheck [__pwmReadN] = true;
		
		if (__pwmReadN < __pwmReadCount - 1)
		{
			__pwmReadN++;
		}
		else
		{
			__pwmReadN = 0;
		}
		
		*__pwmReadRegisterPcmsk [__pwmReadN] = __pwmReadBytePort [__pwmReadN];
		Core::startPinChangeInterrupt (__pwmReadBytePcie [__pwmReadN]);
	}
}

PwmRead::PwmRead (const unsigned char PIN, const bool FALLING)
{
	__pwmReadRegisterPin [__pwmReadCount] = Core::pinToRegisterPin (PIN);
	__pwmReadBytePort [__pwmReadCount] = Core::pinToBytePort (PIN);
	__pwmReadRegisterPcmsk [__pwmReadCount] = Core::pinToRegisterPcmsk (PIN);
	__pwmReadBytePcie [__pwmReadCount] = Core::pinToBytePcie (PIN);
	__pwmReadFalling [__pwmReadCount] = FALLING;
	
	_nChannel = __pwmReadCount;
	
	__pwmReadCount++;
}

void PwmRead::start (const unsigned int TIME_OUT)
{
	Core::prescalerTimer (0, 64);
	Core::startInterruptTimer (0, 2);
	
	*__pwmReadRegisterPcmsk [0] = __pwmReadBytePort [0];
	Core::startPinChangeInterrupt (__pwmReadBytePcie [0]);
	
	if (TIME_OUT != 0)
	{
		_timeOut = long (TIME_OUT) * 1000l;
		
		Core::prescalerTimer (0, 64);
		Core::startInterruptTimer (0, 2);
	}
	
	Core::startGlobalInterrupt();
}

void PwmRead::read()
{
	if (__pwmReadN == _nChannel && _timeOut != 0)
	{
		if (__pwmReadCheck [_nChannel] == false)
		{
			if (_firstRead == true && Core::us() >= _timePrevious)
			{
				Core::stopPinChangeInterrupt();
				*__pwmReadRegisterPcmsk [__pwmReadN] = 0b00000000;
				
				if (__pwmReadN < __pwmReadCount - 1)
				{
					__pwmReadN++;
				}
				else
				{
					__pwmReadN = 0;
				}
				
				__pwmReadFirstFalling = false;
				
				*__pwmReadRegisterPcmsk [__pwmReadN] = __pwmReadBytePort [__pwmReadN];
				Core::startPinChangeInterrupt (__pwmReadBytePcie [__pwmReadN]);
				
				_firstRead = false;
			}
			else if (_firstRead == false)
			{
				_timePrevious = Core::us() + _timeOut;
				_firstRead = true;
			}
		}
		else
		{
			__pwmReadCheck [_nChannel] = false;
			_firstRead = false;
		}
	}
	
	us = __pwmReadDuration [_nChannel];
}
