volatile unsigned char __pwmWriteCount = 0;
volatile unsigned char __pwmWriteN = 0;
volatile unsigned char *__pwmWriteRegisterPin [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char __pwmWriteBytePort [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned int __pwmWriteTop [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

_INTERRUPT_JUMP (_TIMER1_COMPA)
{
	if (__pwmWriteN < __pwmWriteCount && __pwmWriteTop [__pwmWriteN] != 0)
	{
		*__pwmWriteRegisterPin [__pwmWriteN] = __pwmWriteBytePort [__pwmWriteN];
	}
	
	if (__pwmWriteN < __pwmWriteCount - 1)
	{
		__pwmWriteN++;
	}
	else
	{
		__pwmWriteN = 0;
	}
	
	if (__pwmWriteN < __pwmWriteCount && __pwmWriteTop [__pwmWriteN] != 0)
	{
		Core::topTimer (1, 0, __pwmWriteTop [__pwmWriteN]);
	}
}

_INTERRUPT_JUMP (_TIMER1_OVF)
{
	if (__pwmWriteN < __pwmWriteCount && __pwmWriteTop [__pwmWriteN] != 0)
	{
		*__pwmWriteRegisterPin [__pwmWriteN] = __pwmWriteBytePort [__pwmWriteN];
	}
}

PwmWrite::PwmWrite (const unsigned char PIN, const unsigned int US_HOLD, const unsigned int US_MIN, const unsigned int US_MAX)
{
	__pwmWriteRegisterPin [__pwmWriteCount] = Core::pinToRegisterPin (PIN);
	__pwmWriteBytePort [__pwmWriteCount] = Core::pinToBytePort (PIN);
	
	*Core::pinToRegisterDdr (PIN) |= __pwmWriteBytePort [__pwmWriteCount];
	
	_usHold = US_HOLD;
	_usMin = US_MIN;
	_usCenter = Core::round (float (US_MAX) - ((float (US_MAX) - float (US_MIN)) / 2.0));
	_usMax = US_MAX;
	_nDevice = __pwmWriteCount;
	
	__pwmWriteCount++;
}

void PwmWrite::start (const unsigned int FREQUENCY)
{
	const unsigned int PRESCALER = Core::frequencyToPrescaler (long (FREQUENCY) * long (__pwmWriteCount), 1);
	
	Core::modeTimer (1, 14);
	Core::prescalerTimer (1, PRESCALER);
	
	_frequency = long (FREQUENCY) * long (__pwmWriteCount);
	_top = Core::round (((16000000.0 / float (PRESCALER)) / (float (FREQUENCY) * float (__pwmWriteCount))) - 1.0);
	
	Core::topTimer (1, 2, _top);
	Core::startInterruptTimer (1, 0);
	Core::startInterruptTimer (1, 2);
	Core::startGlobalInterrupt();
}

void PwmWrite::hold (const unsigned int US_HOLD)
{
	_usHold = US_HOLD;
}

void PwmWrite::min (const unsigned int US_MIN)
{
	_usMin = US_MIN;
	_usCenter = Core::round (float (_usMax) - ((float (_usMax) - float (US_MIN)) / 2.0));
}

void PwmWrite::center (const unsigned int US_CENTER)
{
	_usCenter = US_CENTER;
	_usMin = Core::round (float (US_CENTER) - ((float (_usMax) - float (_usMin)) / 2.0));
	_usMax = Core::round (float (US_CENTER) + ((float (_usMax) - float (_usMin)) / 2.0));
}

void PwmWrite::max (const unsigned int US_MAX)
{
	_usMax = US_MAX;
	_usCenter = Core::round (float (US_MAX) - ((float (US_MAX) - float (_usMin)) / 2.0));
}

void PwmWrite::us (const unsigned int US)
{
	unsigned int us = US;
	
	if (US < _usMin)
	{
		us = _usMin;
	}
	else if (US > _usMax)
	{
		us = _usMax;
	}
	
	__pwmWriteTop [_nDevice] = Core::round (float (_top) - (float (_top) - (float (_top) / ((1000000.0 / float (us)) / float (_frequency)))));
}

void PwmWrite::moveHold()
{
	__pwmWriteTop [_nDevice] = Core::round (float (_top) - (float (_top) - (float (_top) / ((1000000.0 / float (_usHold)) / float (_frequency)))));
}

void PwmWrite::moveMin()
{
	__pwmWriteTop [_nDevice] = Core::round (float (_top) - (float (_top) - (float (_top) / ((1000000.0 / float (_usMin)) / float (_frequency)))));
}

void PwmWrite::moveCenter()
{
	__pwmWriteTop [_nDevice] = Core::round (float (_top) - (float (_top) - (float (_top) / ((1000000.0 / float (_usCenter)) / float (_frequency)))));
}

void PwmWrite::moveMax()
{
	__pwmWriteTop [_nDevice] = Core::round (float (_top) - (float (_top) - (float (_top) / ((1000000.0 / float (_usMax)) / float (_frequency)))));
}
