void Random::seed (const unsigned char PIN)
{
	_pin = PIN;
	Core::startAnalog();
}

bool Random::boolean()
{
	return Core::readAnalog (_pin) & 0b0000000000000001;
}

signed long Random::integer (const signed long MIN, const signed long MAX)
{
	unsigned long range = 0;
	unsigned char shift = 0;
	unsigned char search = 0;
	bool foundPrecision = false;
	unsigned long randomValue = 0;
	unsigned long precision = 0;
	unsigned int analogReadPrevious = 0;
	unsigned int analogReadNext = 0;
	float artificialNoise = 1;
	
	if (MIN <= MAX)
	{
		range = MAX - MIN;
	}
	else
	{
		range = MIN - MAX;
	}
	
	for (shift = 0; foundPrecision == false; shift++)
	{
		for (search = 0; analogReadPrevious == analogReadNext && search < 8; search++)
		{
			analogReadPrevious = Core::readAnalog (_pin);
			analogReadNext = Core::readAnalog (_pin);
		}
		
		if (analogReadPrevious == analogReadNext)
		{
			artificialNoise = (artificialNoise + float (_seed)) * 2.5;
			analogReadPrevious = (unsigned int)(artificialNoise);
		}
		
		if (_seed < 254)
		{
			_seed++;
		}
		else
		{
			_seed = 0;
		}
		
		randomValue |= (unsigned long)(analogReadPrevious & 0b0000000000000001) << shift;
		precision |= (unsigned long)(0b00000000000000000000000000000001) << shift;
		
		analogReadPrevious = 0;
		analogReadNext = 0;
		
		if (precision >= range)
		{
			foundPrecision = true;
		}
	}
	
	return Core::round (Core::curve (0, randomValue, precision, MIN, MAX, 0));
}
