volatile unsigned char *__soundWriteRegisterPort = 0;
volatile unsigned char *__soundWriteRegisterPin = 0;
volatile unsigned char __soundWriteBytePort = 0;
volatile unsigned int __soundWriteDuration = 0;
volatile bool __soundWritePlaying = false;
volatile bool __soundWritePlayingInfinite = false;
volatile bool __soundWritePlayingKey = false;
volatile unsigned char __soundWriteFrequencyKey [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned int __soundWriteDurationKey [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile bool __soundWriteBlankKey [32] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
volatile unsigned char __soundWriteCountWhileKey = 0;
volatile unsigned char __soundWriteNWhileKey = 0;

_INTERRUPT_JUMP (_TIMER2_COMPA)
{
	if (__soundWritePlaying == true || __soundWritePlayingInfinite == true || __soundWritePlayingKey == true)
	{
		if (__soundWritePlaying == true || __soundWritePlayingInfinite == true || (__soundWritePlayingKey == true && __soundWriteBlankKey [__soundWriteNWhileKey] == false))
		{
			*__soundWriteRegisterPin = __soundWriteBytePort;
		}
		
		if (__soundWritePlayingInfinite == false)
		{
			if (__soundWritePlaying == true)
			{
				if (__soundWriteDuration == 0)
				{
					__soundWritePlaying = false;
				}
				else
				{
					__soundWriteDuration--;
				}
			}
			else if (__soundWritePlayingKey == true)
			{
				if (__soundWriteDuration == 0)
				{
					__soundWriteNWhileKey++;
					
					if (__soundWriteNWhileKey == __soundWriteCountWhileKey)
					{
						__soundWritePlayingKey = false;
					}
					else
					{
						Core::topTimer (2, 0, __soundWriteFrequencyKey [__soundWriteNWhileKey]);
						__soundWriteDuration = __soundWriteDurationKey [__soundWriteNWhileKey];
					}
				}
				else
				{
					__soundWriteDuration--;
				}
			}
		}
	}
	else if (__soundWritePlaying == false || __soundWritePlayingInfinite == false || __soundWritePlayingKey == false)
	{
		Core::stopInterruptTimer (2, 0);
		
		*__soundWriteRegisterPort &= ~__soundWriteBytePort;
		
		__soundWritePlaying = false;
		__soundWritePlayingInfinite = false;
		__soundWritePlayingKey = false;
	}
}

void SoundWrite::pin (const unsigned char PIN)
{
	__soundWriteRegisterPort = Core::pinToRegisterPort (PIN);
	__soundWriteRegisterPin = Core::pinToRegisterPin (PIN);
	__soundWriteBytePort = Core::pinToBytePort (PIN);
	
	*Core::pinToRegisterDdr (PIN) |= __soundWriteBytePort;
	
	Core::modeTimer (2, 2);
	Core::prescalerTimer (2, 1024);
	Core::startGlobalInterrupt();
}

void SoundWrite::play (const unsigned int FREQUENCY, const unsigned int DURATION)
{
	if (DURATION == 0)
	{
		__soundWritePlaying = false;
		__soundWritePlayingKey = false;
		
		if (Core::round (((16000000.0 / float (FREQUENCY)) / 1024.0) - 1.0) >= 255)
		{
			Core::topTimer (2, 0, 255);
		}
		else if (Core::round (((16000000.0 / float (FREQUENCY)) / 1024.0) - 1.0) <= 0)
		{
			Core::topTimer (2, 0, 0);
		}
		else
		{
			Core::topTimer (2, 0, Core::round (((16000000.0 / float (FREQUENCY)) / 1024.0) - 1.0));
		}
		
		__soundWritePlayingInfinite = true;
		
		Core::startInterruptTimer (2, 0);
	}
	else if (__soundWritePlayingInfinite == false)
	{
		__soundWritePlayingKey = false;
		
		if (Core::round (((16000000.0 / float (FREQUENCY)) / 1024.0) - 1.0) >= 255)
		{
			Core::topTimer (2, 0, 255);
			__soundWriteDuration = Core::round (((16000000.0 / 1024.0) / 255.0) * (float (DURATION) / 1000.0));
		}
		else if (Core::round (((16000000.0 / float (FREQUENCY)) / 1024.0) - 1.0) <= 0)
		{
			Core::topTimer (2, 0, 0);
			__soundWriteDuration = Core::round ((16000000.0 / 1024.0) * (float (DURATION) / 1000.0));
		}
		else
		{
			Core::topTimer (2, 0, Core::round (((16000000.0 / float (FREQUENCY)) / 1024.0) - 1.0));
			__soundWriteDuration = Core::round (float (FREQUENCY) * (float (DURATION) / 1000.0));
		}
		
		__soundWritePlaying = true;
		
		Core::startInterruptTimer (2, 0);
	}
}

void SoundWrite::modulate (const unsigned int FREQUENCY)
{
	if (Core::round (((16000000.0 / float (FREQUENCY)) / 1024.0) - 1.0) >= 255)
	{
		Core::topTimer (2, 0, 255);
	}
	else if (Core::round (((16000000.0 / float (FREQUENCY)) / 1024.0) - 1.0) <= 0)
	{
		Core::topTimer (2, 0, 0);
	}
	else
	{
		Core::topTimer (2, 0, Core::round (((16000000.0 / float (FREQUENCY)) / 1024.0) - 1.0));
	}
}

void SoundWrite::key (const unsigned int FREQUENCY, const unsigned int DURATION)
{
	if (Core::round (((16000000.0 / float (FREQUENCY)) / 1024.0) - 1.0) >= 255)
	{
		__soundWriteFrequencyKey [_countAddKey] = 255;
		__soundWriteDurationKey [_countAddKey] = Core::round (((16000000.0 / 1024.0) / 255.0) * (float (DURATION) / 1000.0));
	}
	else if (Core::round (((16000000.0 / float (FREQUENCY)) / 1024.0) - 1.0) <= 0)
	{
		__soundWriteFrequencyKey [_countAddKey] = 0;
		__soundWriteDurationKey [_countAddKey] = Core::round ((16000000.0 / 1024.0) * (float (DURATION) / 1000.0));
	}
	else
	{
		__soundWriteFrequencyKey [_countAddKey] = Core::round (((16000000.0 / float (FREQUENCY)) / 1024.0) - 1.0);
		__soundWriteDurationKey [_countAddKey] = Core::round (float (FREQUENCY) * (float (DURATION) / 1000.0));
	}
	
	if (FREQUENCY == 0)
	{
		__soundWriteBlankKey [_countAddKey] = true;
	}
	else if (FREQUENCY > 0)
	{
		__soundWriteBlankKey [_countAddKey] = false;
	}
	
	_countAddKey++;
}

void SoundWrite::playKey()
{
	if (__soundWritePlayingInfinite == false && _countAddKey > 0)
	{
		__soundWritePlaying = false;
		
		__soundWriteCountWhileKey = _countAddKey;
		_countAddKey = 0;
		__soundWriteNWhileKey = 0;
		
		Core::topTimer (2, 0, __soundWriteFrequencyKey [0]);
		__soundWriteDuration = __soundWriteDurationKey [0];
		
		__soundWritePlayingKey = true;
		
		Core::startInterruptTimer (2, 0);
	}
}

void SoundWrite::stop()
{
	__soundWritePlaying = false;
	__soundWritePlayingInfinite = false;
	__soundWritePlayingKey = false;
}
