Timer::Timer (const bool CLOCKWISE)
{
	_clockwise = CLOCKWISE;
	
	Core::prescalerTimer (0, 64);
	Core::startInterruptTimer (0, 2);
	Core::startGlobalInterrupt();
}

void Timer::start (const signed long START)
{
	if (_clockwise == false)
	{
		_timeStart = Core::us() + (START * 1000l);
	}
	else
	{
		_timeStart = Core::us() - (START * 1000l);
	}
	
	_stop = false;
}

void Timer::state()
{
	if (_stop == false)
	{
		if (_clockwise == false)
		{
			ms = Core::floor ((float (_timeStart) - float (Core::us())) / 1000.0);
		}
		else
		{
			ms = Core::floor ((float (Core::us()) - float (_timeStart)) / 1000.0);
		}
	}
}

void Timer::stop()
{
	_stop = true;
}

void Timer::pause (const unsigned long DURATION)
{
	unsigned long timePrevious = 0;
	
	Core::prescalerTimer (0, 64);
	Core::startInterruptTimer (0, 2);
	Core::startGlobalInterrupt();
	
	timePrevious = Core::us();
	
	while (Core::us() < timePrevious + (DURATION * 1000l))
	{
	}
}
