#include "../module/Delay.h"
#include "../module/Random.h"
#include "../module/Math.h"
#include "../module/Filter.h"
#include "../module/SoundWrite.h"
#include "../module/PwmWrite.h"
#include "../module/PwmRead.h"
#include "../module/Mpu6050.h"

int main()
{
	unsigned char n = 0;
	Delay delaySoundStartCondition = Delay (1000, false);
	Mpu6050 gyroscope = Mpu6050 (0x68);
	PwmRead channelThrottle = PwmRead (1, false);
	float slowChannelThrottle = 0;
	PwmRead channelPitch = PwmRead (2, false);
	PwmRead channelRoll = PwmRead (3, false);
	PwmRead channelYaw = PwmRead (4, false);
	PwmRead channelHold = PwmRead (5, false);
	float centerChannelHold = 0;
	PwmWrite motor1 = PwmWrite (8, 0, 0, 0);
	PwmWrite motor2 = PwmWrite (9, 0, 0, 0);
	PwmWrite motor3 = PwmWrite (10, 0, 0, 0);
	PwmWrite motor4 = PwmWrite (11, 0, 0, 0);
	float mixThrottle = 0;
	float mixThrustPitchGainSpeed = 0;
	Filter mixLockPitchGainSpeed = Filter (20);
	float mixThrustRollGainSpeed = 0;
	Filter mixLockRollGainSpeed = Filter (20);
	float mixInertiaYawGainSpeed = 0;
	Filter mixLockYawGainSpeed = Filter (100);
	float mixMinClearancePitch = 0;
	float mixMaxClearancePitch = 0;
	float mixMinClearanceRoll = 0;
	float mixMaxClearanceRoll = 0;
	float mixMinClearanceYaw = 0;
	float mixMaxClearanceYaw = 0;
	float mixPitchOffsetSpeed = 0;
	float mixRollOffsetSpeed = 0;
	float mixYawOffsetSpeed = 0;
	float thrustGainSpeedPitch = 0;
	float thrustGainSpeedRoll = 0;
	float inertiaGainSpeedYaw = 0;
	float gainMinRxSpeed = 0;
	float gainMaxRxSpeed = 0;
	float gainLockRxSpeed = 0;
	float gainMinRySpeed = 0;
	float gainMaxRySpeed = 0;
	float gainLockRySpeed = 0;
	float gainMinRzSpeed = 0;
	float gainMaxRzSpeed = 0;
	float gainLockRzSpeed = 0;
	float mixMinRxMotor = 0;
	float mixMaxRxMotor = 0;
	float mixMinRyMotor = 0;
	float mixMaxRyMotor = 0;
	float mixMinRzMotor = 0;
	float mixMaxRzMotor = 0;
	float mixMotor1 = 0;
	float mixMotor2 = 0;
	float mixMotor3 = 0;
	float mixMotor4 = 0;
	const unsigned int SETUP_MIN_CHANNEL_THROTTLE = 1000;
	const unsigned int SETUP_MAX_CHANNEL_THROTTLE = 2000;
	const unsigned int SETUP_MIN_CHANNEL_PITCH = 1000;
	const unsigned int SETUP_MAX_CHANNEL_PITCH = 2000;
	const unsigned int SETUP_MIN_CHANNEL_ROLL = 1000;
	const unsigned int SETUP_MAX_CHANNEL_ROLL = 2000;
	const unsigned int SETUP_MIN_CHANNEL_YAW = 1000;
	const unsigned int SETUP_MAX_CHANNEL_YAW = 2000;
	const unsigned int SETUP_MIN_CHANNEL_HOLD = 1000;
	const unsigned int SETUP_MAX_CHANNEL_HOLD = 2000;
	const unsigned int SETUP_FREQUENCY_ESC = 125;
	const unsigned int SETUP_HOLD_ESC = 950;
	const unsigned int SETUP_MIN_ESC = 1050;
	const unsigned int SETUP_MAX_ESC = 1950;
	const unsigned int SETUP_TRAVEL_PITCH = 250;
	const unsigned int SETUP_TRAVEL_ROLL = 250;
	const unsigned int SETUP_TRAVEL_YAW = 400;
	const signed int SETUP_SPEED_PITCH = 320;
	const signed int SETUP_SPEED_ROLL = 320;
	const signed int SETUP_SPEED_YAW = 320;
	const unsigned char SETUP_GAIN_SPEED_PITCH = 95;
	const unsigned char SETUP_GAIN_SPEED_ROLL = 93;
	const unsigned char SETUP_GAIN_SPEED_YAW = 96;
	const unsigned char SETUP_THRUST_PROPELLER = 80;
	const unsigned char SETUP_INERTIA_PROPELLER = 100;
	const unsigned char SETUP_LOCK = 60;
	
	SoundWrite::pin (13);
	
	PwmRead::start (100);
	
	while (channelThrottle.us == 0 || channelPitch.us == 0 || channelRoll.us == 0 || channelYaw.us == 0 || channelHold.us == 0)
	{
		channelThrottle.read();
		channelPitch.read();
		channelRoll.read();
		channelYaw.read();
		channelHold.read();
		
		delaySoundStartCondition.state();
		
		if (delaySoundStartCondition.update == true)
		{
			SoundWrite::key (200, 100);
			SoundWrite::key (0, 100);
			SoundWrite::key (200, 100);
			SoundWrite::playKey();
		}
	}
	
	slowChannelThrottle = float (SETUP_MIN_CHANNEL_THROTTLE) + ((float (SETUP_MAX_CHANNEL_THROTTLE) - float (SETUP_MIN_CHANNEL_THROTTLE)) / 10.0);
	centerChannelHold = Math::center (SETUP_MIN_CHANNEL_HOLD, SETUP_MAX_CHANNEL_HOLD);
	
	delaySoundStartCondition.reset();
	
	while (channelThrottle.us > slowChannelThrottle || channelHold.us < centerChannelHold)
	{
		channelThrottle.read();
		channelHold.read();
		
		delaySoundStartCondition.state();
		
		if (delaySoundStartCondition.update == true)
		{
			SoundWrite::key (200, 100);
			SoundWrite::key (0, 100);
			SoundWrite::key (200, 100);
			SoundWrite::key (0, 100);
			SoundWrite::key (200, 100);
			SoundWrite::playKey();
		}
	}
	
	thrustGainSpeedPitch = Math::curve (0, SETUP_THRUST_PROPELLER, 100, 0, SETUP_GAIN_SPEED_PITCH, 0);
	gainMinRxSpeed = Math::curve (0, thrustGainSpeedPitch, 100, 2000, 0, 0);
	gainMaxRxSpeed = Math::curve (0, SETUP_GAIN_SPEED_PITCH, 100, 2000, 0, 0);
	gainLockRxSpeed = Math::curve (0, SETUP_LOCK, 100, 1, 0, 0);
	
	thrustGainSpeedRoll = Math::curve (0, SETUP_THRUST_PROPELLER, 100, 0, SETUP_GAIN_SPEED_ROLL, 0);
	gainMinRySpeed = Math::curve (0, thrustGainSpeedRoll, 100, 2000, 0, 0);
	gainMaxRySpeed = Math::curve (0, SETUP_GAIN_SPEED_ROLL, 100, 2000, 0, 0);
	gainLockRySpeed = Math::curve (0, SETUP_LOCK, 100, 1, 0, 0);
	
	inertiaGainSpeedYaw = Math::curve (0, SETUP_INERTIA_PROPELLER, 100, 0, SETUP_GAIN_SPEED_YAW, 0);
	gainMinRzSpeed = Math::curve (0, inertiaGainSpeedYaw, 100, 2000, 0, 0);
	gainMaxRzSpeed = Math::curve (0, SETUP_GAIN_SPEED_YAW, 100, 2000, 0, 0);
	gainLockRzSpeed = Math::curve (0, SETUP_LOCK, 100, 1, 0, 0);
	
	motor1.hold (SETUP_HOLD_ESC);
	motor1.min (SETUP_MIN_ESC);
	motor1.max (SETUP_MAX_ESC);
	motor2.hold (SETUP_HOLD_ESC);
	motor2.min (SETUP_MIN_ESC);
	motor2.max (SETUP_MAX_ESC);
	motor3.hold (SETUP_HOLD_ESC);
	motor3.min (SETUP_MIN_ESC);
	motor3.max (SETUP_MAX_ESC);
	motor4.hold (SETUP_HOLD_ESC);
	motor4.min (SETUP_MIN_ESC);
	motor4.max (SETUP_MAX_ESC);
	
	PwmWrite::start (SETUP_FREQUENCY_ESC);
	
	motor1.moveHold();
	motor2.moveHold();
	motor3.moveHold();
	motor4.moveHold();
	
	Random::seed (15);
	
	for (n = 0; n < 16; n++)
	{
		if (n != 0)
		{
			SoundWrite::key (0, Random::integer (25, 75));
		}
		
		SoundWrite::key (Random::integer (70, 3000), Random::integer (25, 75));
	}
	
	SoundWrite::playKey();
	
	while (true)
	{
		channelThrottle.read();
		channelPitch.read();
		channelRoll.read();
		channelYaw.read();
		channelHold.read();
		
		if (channelHold.us > centerChannelHold)
		{
			motor1.moveHold();
			motor2.moveHold();
			motor3.moveHold();
			motor4.moveHold();
		}
		else
		{
			gyroscope.readRotation();
			
			mixThrottle = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, SETUP_MIN_ESC, SETUP_MAX_ESC, 0);
			
			mixMotor1 = mixThrottle;
			mixMotor2 = mixThrottle;
			mixMotor3 = mixThrottle;
			mixMotor4 = mixThrottle;
			
			mixMinClearancePitch = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, 0, SETUP_TRAVEL_PITCH, 0);
			mixMaxClearancePitch = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, SETUP_TRAVEL_PITCH, 0, 0);
			mixPitchOffsetSpeed = Math::curve (SETUP_MIN_CHANNEL_PITCH, channelPitch.us, SETUP_MAX_CHANNEL_PITCH, -SETUP_SPEED_PITCH, SETUP_SPEED_PITCH, 0);
			mixThrustPitchGainSpeed = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, gainMaxRxSpeed, gainMinRxSpeed, 0);
			mixLockPitchGainSpeed.set (Math::wurve (SETUP_MIN_CHANNEL_PITCH, channelPitch.us, SETUP_MAX_CHANNEL_PITCH, gainLockRxSpeed, 1, gainLockRxSpeed, 0, 0));
			mixThrustPitchGainSpeed *= mixLockPitchGainSpeed.value;
			mixMinRxMotor = Math::wurve (-mixThrustPitchGainSpeed, gyroscope.rx + mixPitchOffsetSpeed, mixThrustPitchGainSpeed, -mixMaxClearancePitch, 0, mixMinClearancePitch, 0, 0);
			mixMaxRxMotor = Math::wurve (-mixThrustPitchGainSpeed, gyroscope.rx + mixPitchOffsetSpeed, mixThrustPitchGainSpeed, -mixMinClearancePitch, 0, mixMaxClearancePitch, 0, 0);
			
			mixMotor1 -= mixMinRxMotor;
			mixMotor2 -= mixMinRxMotor;
			mixMotor3 += mixMaxRxMotor;
			mixMotor4 += mixMaxRxMotor;
			
			mixMinClearanceRoll = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, 0, SETUP_TRAVEL_ROLL, 0);
			mixMaxClearanceRoll = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, SETUP_TRAVEL_ROLL, 0, 0);
			mixRollOffsetSpeed = Math::curve (SETUP_MIN_CHANNEL_ROLL, channelRoll.us, SETUP_MAX_CHANNEL_ROLL, -SETUP_SPEED_ROLL, SETUP_SPEED_ROLL, 0);
			mixThrustRollGainSpeed = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, gainMaxRySpeed, gainMinRySpeed, 0);
			mixLockRollGainSpeed.set (Math::wurve (SETUP_MIN_CHANNEL_ROLL, channelRoll.us, SETUP_MAX_CHANNEL_ROLL, gainLockRySpeed, 1, gainLockRySpeed, 0, 0));
			mixThrustRollGainSpeed *= mixLockRollGainSpeed.value;
			mixMinRyMotor = Math::wurve (-mixThrustRollGainSpeed, gyroscope.ry - mixRollOffsetSpeed, mixThrustRollGainSpeed, -mixMaxClearanceRoll, 0, mixMinClearanceRoll, 0, 0);
			mixMaxRyMotor = Math::wurve (-mixThrustRollGainSpeed, gyroscope.ry - mixRollOffsetSpeed, mixThrustRollGainSpeed, -mixMinClearanceRoll, 0, mixMaxClearanceRoll, 0, 0);
			
			mixMotor1 -= mixMinRyMotor;
			mixMotor2 += mixMaxRyMotor;
			mixMotor3 -= mixMinRyMotor;
			mixMotor4 += mixMaxRyMotor;
			
			mixMinClearanceYaw = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, 0, SETUP_TRAVEL_YAW, 0);
			mixMaxClearanceYaw = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, SETUP_TRAVEL_YAW, 0, 0);
			mixYawOffsetSpeed = Math::curve (SETUP_MIN_CHANNEL_YAW, channelYaw.us, SETUP_MAX_CHANNEL_YAW, -SETUP_SPEED_YAW, SETUP_SPEED_YAW, 0);
			mixInertiaYawGainSpeed = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, gainMaxRzSpeed, gainMinRzSpeed, 0);
			mixLockYawGainSpeed.set (Math::wurve (SETUP_MIN_CHANNEL_YAW, channelYaw.us, SETUP_MAX_CHANNEL_YAW, gainLockRzSpeed, 1, gainLockRzSpeed, 0, 0));
			mixInertiaYawGainSpeed *= mixLockYawGainSpeed.value;
			mixMinRzMotor = Math::wurve (-mixInertiaYawGainSpeed, gyroscope.rz + mixYawOffsetSpeed, mixInertiaYawGainSpeed, -mixMaxClearanceYaw, 0, mixMinClearanceYaw, 0, 0);
			mixMaxRzMotor = Math::wurve (-mixInertiaYawGainSpeed, gyroscope.rz + mixYawOffsetSpeed, mixInertiaYawGainSpeed, -mixMinClearanceYaw, 0, mixMaxClearanceYaw, 0, 0);
			
			mixMotor1 -= mixMinRzMotor;
			mixMotor2 += mixMaxRzMotor;
			mixMotor3 += mixMaxRzMotor;
			mixMotor4 -= mixMinRzMotor;
			
			motor1.us (Math::round (mixMotor1));
			motor2.us (Math::round (mixMotor2));
			motor3.us (Math::round (mixMotor3));
			motor4.us (Math::round (mixMotor4));
		}
	}
	
	return 0;
}
