// SST26VF064B modified for pic32         14/10/2016

// defines
#define SST_CE_TRIS   _TRISB0         // outputs sst
#define SST_CE_LAT    _LATB0
#define SST_SCK_TRIS  _TRISB1
#define SST_SCK_LAT   _LATB1
#define SST_SI_TRIS   _TRISB2
#define SST_SI_LAT    _LATB2
#define SST_SO_TRIS   _TRISB3
#define SST_SO_PORT   _RB3            // input so sst

// include files
#include <xc.h>

// configuration bits 8MHz
#pragma config FNOSC    = FRC       // osc interne 8MHz
#pragma config FPBDIV   = DIV_1     // clock pripherals Fpb 8MHz (Fcpu/1)

/* configuration bits 80MHz
#pragma config FNOSC    = FRCPLL    // osc interne 8MHz + pll
#pragma config FPLLIDIV = DIV_2
#pragma config FPLLMUL  = MUL_20
#pragma config FPLLODIV = DIV_1     // clock system/cpu Fcpu 80MHz (pll 8 /2 *20 /1)
#pragma config FPBDIV   = DIV_1     // clock pripherals Fpb 80MHz (Fcpu/1)
*/

#define CE_High() SST_CE_LAT = 1
#define CE_Low()  SST_CE_LAT = 0

// jdec datas
unsigned char Manufacturer_Id, Device_Type, Device_Id;

/************************************************************************/
/* PROCEDURE: Port Assign						                                    */
/*									                                                    */
/* This procedure sets the Ports for SPI communicaiton and LED Display.	*/
/* LATA is for LED display.  LATF is for SPI communication.		          */
/************************************************************************/
void Portassign()
{
  SST_CE_TRIS  = 0;         // outputs sst
  SST_SCK_TRIS = 0;	
  SST_SI_TRIS  = 0;	
  SST_SO_TRIS  = 1;         // input sst
}

/************************************************************************/
/* PROCEDURE: init							                                        */
/*									                                                    */
/* This procedure initializes the SCK to low. Must be called prior to 	*/
/* setting up mode 0.							                                      */
/************************************************************************/
void init()
{
	CE_High();
	SST_SCK_LAT = 0;
}

/************************************************************************/
/* PROCEDURE: Send_Byte							                                    */
/*									                                                    */
/* This procedure outputs a byte shifting out 1-bit per clock rising	  */
/* edge on the the SI pin (SIO0 pin) LSB 1st.				                    */
/************************************************************************/
void Send_Byte(unsigned char out)
{
	unsigned char i = 0;

	for (i = 0; i < 8; i++) {
		if ((out & 0x80) == 0x80)	/* check if MSB is high */
			SST_SI_LAT = 1;
		else
			SST_SI_LAT = 0;         /* if not, set to low */
		SST_SCK_LAT = 1;          /* toggle clock high */
		out = (out << 1);	        /* shift 1 place for next bit */
		SST_SCK_LAT = 0;          /* toggle clock low */
	}
}

/************************************************************************/
/* PROCEDURE: Get_Byte							                                    */
/*					                                                    				*/
/* This procedure inputs a byte shifting in 1-bit per clock falling	    */
/* edge on the SIO1 pin(LSB 1st).					                              */
/************************************************************************/
unsigned char Get_Byte()
{
	unsigned char i = 0, in = 0, temp = 0;

	for (i = 0; i < 8; i++)	{
		in = (in << 1);		        /* shift 1 place to the left or shift in 0 */
		temp = SST_SO_PORT;		    /* save input */
		SST_SCK_LAT = 1;          /* toggle clock high */
	  if (temp == 1)			      /* check to see if bit is high */
		  in = in | 0x01;		      /* if high, make bit high */
		SST_SCK_LAT = 0;          /* toggle clock low */
	}
	return in;
}

/************************************************************************/
/* PROCEDURE: Read_Status_Register					                            */
/*									                                                    */
/* This procedure reads the status register and returns the byte.	      */
/************************************************************************/
unsigned char SPI_Read_Status_Register()
{
	unsigned char byte = 0;

	CE_Low();			              /* enable device */
	Send_Byte(0x05);		        /* send RDSR command */
	byte = Get_Byte();		      /* receive byte */
	CE_High();			            /* disable device */
	return byte;
}

/************************************************************************/
/* PROCEDURE: Write_Status_Register					                            */
/*									                                                    */
/* This procedure resumes Program/Erase operation.			                */
/************************************************************************/
void SPI_Write_Status_Register(unsigned int data1, unsigned char datalen)
{	  
  // For data1 - top 8 bits are status reg bits , lower 8 bits are configuration reg bits
	CE_Low();			      	  /* enable device */
	Send_Byte(0x01);
	Send_Byte((data1>>8)&0xff);
	if (datalen==2) {
		Send_Byte((data1)&0xff);
	}
	CE_High();				      /* disable device */
}

/************************************************************************/
/* PROCEDURE: WREN							                                        */
/*									                                                    */
/* This procedure enables the Write Enable Latch.               	      */
/************************************************************************/
void SPI_WREN()
{
	CE_Low();			              /* enable device */
	Send_Byte(0x06);		        /* send WREN command */
	CE_High();			            /* disable device */
}

/************************************************************************/
/* PROCEDURE: Jedec_ID_Read    			                                    */
/*									                                                    */
/* This procedure Reads the manufacturer's ID, device Type and device ID*/
/* It will use AFh as the command to read the ID.                       */
/* Returns:								                                              */
/*	ID1(Manufacture's ID = BFh, Device Type =26h , Device ID = 02h)	    */
/*									                                                    */
/************************************************************************/
void Jedec_ID_Read()
{
	CE_Low();                     /* enable device */
	Send_Byte(0x9F);              /* send JEDEC ID command (9Fh) */
 	Manufacturer_Id = Get_Byte(); /* receive byte */
 	Device_Type = Get_Byte();     /* receive byte */
 	Device_Id = Get_Byte();       /* receive byte */
	CE_High();                    /* disable device */
}

/*****************************************************/
/* Main Function*/
/*****************************************************/

int main()
{
  int check; unsigned int tempdatalong; 
  
  Portassign();
  init();
    
  SPI_WREN();

  tempdatalong = SPI_Read_Status_Register();
  tempdatalong = tempdatalong<<8;
  tempdatalong = tempdatalong | 0x82;
  SPI_Write_Status_Register(tempdatalong, 2);
  
  // Test Jedec ID
  Jedec_ID_Read();
  if (Manufacturer_Id == 0xbf && Device_Type == 0x26 && Device_Id == 0x43) { 
    check = 1;
  } 
  else { 
    check=0; 
  } 

  while (1) ;  return 0;
}
