/* 
 * File:   MIP.h
 * Author: Mohamed Ali ATTAOUI
 *
 * Created on October 25, 2016, 9:30 PM
 */

#ifndef MIP_H
#define	MIP_H

//[1] Modem Reset message
const rom unsigned char SysResetTable[7] = {0x16,0x02,0x1a,0x00,0x00,0x00,0x1a};

const rom unsigned char ModemStatus[7] = {0x16,0x02,0x46,0x00,0x00,0x00,0x46};

const rom unsigned char GetSysInfo[7] = {0x16,0x02,0x14,0x00,0x00,0x00,0x14};

const rom unsigned char GetExtendedSysInfo[7] = {0x16,0x02,0x1f,0x00,0x00,0x00,0x1f};

//[5] => [4] Set Information Base Message
const rom unsigned char SetInfoBaseTable[17] =
{0x16,0x02,0x21,0x00,0x09,0x00,0x28,0x24,0xff,
 0x00,0x01,0x03,0x00,0x01,0x00,0x00,0xd8};


//[6] => [5] Set Network configuration (basic stuff)
const rom unsigned char SetNetCfgTable[29] = 
{0x16,0x02,0x15,0x01,0x15,0x00,0x01,0x18,0x21,0xff,0xff,0xff,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x0c,0xce};


//[7] => [6] Set Mac adress With fixed mac : 01:02:03:04:05:06:07:09
const rom unsigned char SetMacAddrTable[24]=
{0x16,0x02,0x21,0x01,0x10,0x00,0x30,0xf1,0xff,0x00,0x01,0x00,0x00,0x08,0x00,
 0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x0f };


//[9] => [7]System initialisation
const rom unsigned char SysInitTable[7]={0x16,0x02,0x16,0x02,0x00,0x00,0x14};


// ============= Script Start
//[10] => [8] set Maximal message Hops across the network
const rom unsigned char SetMaxHopsTable[16]=
{0x16,0x02,0x23,0x02,0x08,0x00,0x29,0x10,
 0x00,0x00,0x00,0x02,0x00,0x05,0x00,0x17};


//[11] => [9] Set maximal network travel time
const rom unsigned char SetMaxNetTravellTimeTable[16] = 
{0x16,0x02,0x23,0x00,0x08,0x00,0x2b,0x12,
 0x00,0x00,0x00,0x02,0x00,0x14,0x00,0x04};


//[12] => [10] Set Network Route response window time period
const rom unsigned char SetRouteResponseWaitTable[16] =
{0x16,0x02,0x23,0x00,0x08,0x00,0x2b,0x06,
 0x00,0x00,0x00,0x02,0x00,0x14,0x00,0x10};


//[13] => [11] Set maximal time for nodes to join the network
const rom unsigned char SetMaxJoinTimeTable[16] = 
{0x16,0x02,0x23,0x8e,0x08,0x00,0xa5,0x20,
 0x00,0x00,0x00,0x02,0x00,0x32,0x00,0x10};


//[14] => [12] Set timout for path discovery
const rom unsigned char SetPathDiscoveryTimeTable[16] =
{0x16,0x02,0x23,0x8e,0x08,0x00,0xa5,0x21,
 0x00,0x00,0x00,0x02,0x00,0x32,0x00,0x11};


//[15] => [13]
const rom unsigned char SetBroadcastEtcTable[16] = 
{0x16,0x02,0x23,0xf2,0x08,0x00,0xd9,0x02,
 0x00,0x00,0x00,0x02,0x00,0x32,0x00,0x32};


//[16] => [14]
const rom unsigned char SetRoutingTableTable[18] =
{0x16,0x02,0x23,0xf2,0x0a,0x00,0xdb,0x13,0x00,
 0x00,0x00,0x04,0x00,0x40,0x38,0x00,0x00,0x6f};


//[17] => [15]
const rom unsigned char SetMacTableTimeTable[20] =
{0x16,0x02,0x21,0x00,0x0c,0x00,0x2d,0x0e,0x01,0x00,
 0x00,0x00,0x00,0x04,0x00,0x80,0x70,0x00,0x00,0xfb};

// ================ Script End

const rom unsigned char PanGetIbHandler1[12] =
{0x16,0x02,0x22,0x01,0x04,0x00,0x27,0x12,0x00,0x00,
 0x00,0x12};

const rom unsigned char PanGetIbHandler2[12] =
{0x16,0x02,0x22,0x02,0x04,0x00,0x24,0x19,0x00,0x00,
 0x00,0x19};

const rom unsigned char PanGetIbHandler3[12] =
{0x16,0x02,0x22,0x03,0x04,0x00,0x25,0x10,0x00,0x00,
 0x00,0x10};

const rom unsigned char PanGetIbHandler4[14] =
{0x16,0x02,0x20,0x04,0x06,0x00,0x22,0x53,0x00,0x00,
 0x00,0x00,0x00,0x53};

//[22] => Auto Join Network 
const rom unsigned char AutoJoinNetworkTable[19] =
{0x16,0x02,0x44,0x00,0x0b,0x00,0x4f,0x00,0xc0,0x00,
 0x44,0xff,0xff,0x00,0x00,0x32,0x01,0x01,0xb6};


//[23] Send Payload
const rom unsigned char SendPayLodTable[64] = 
{0x16,0x02,0x08,0x01,0x38,0x00,0x31,0x09,0x60,0x00,0x00,0x00,0x00,0x0f,0x11,
 0x05,0xfe,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x00,0x00,0xff,0xfe,0x00,
 0x00,0x01,0xfe,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x00,0x00,0xff,0xfe,
 0x00,0x00,0x00,0xf0,0xb0,0xf0,0xb2,0x00,0x0f,0xaa,0x46,0x31,0x32,0x33,0x34,
 0x35,0xaa,0x00,0x09};


const rom unsigned char SendFunnyPayLodTable[69] =
{0x16,0x02,0x08,0x08,0x3d,0x00,0x3d,0x09,0x60,0x00,0x00,0x00,0x00,0x14,0x11,
 0x05,0xfe,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x00,0x00,0xff,0xfe,0x00,
 0x00,0x02,0xfe,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x00,0x00,0xff,0xfe,
 0x00,0x00,0x00,0xf0,0xb0,0xf0,0xb2,0x00,0x14,0x4b,0x72,0x2e,0x2e,0x2e,0x57,
 0x6f,0x72,0x6c,0x64,0x21,0x21,0x21,0x00,0x09};


void send(char* command);
char receive();
#endif	/* MIP_H */

