#include "initialisation.h"
#include "MIP.h"
#include "p18f67j60.h"
#include "usart.h"
#define USE_OR_MASKS
#define EAUSART_V10

void initialiseTX()
{
    TXSTA1bits.TX9=0;
    TXSTA1bits.SYNC=0;
    TXSTA1bits.SENDB=1;
    TXSTA1bits.BRGH=1;
    TXSTA1bits.TX9D=0;
}

void initialiseRX()
{
    RCSTA1bits.SPEN=1;
    RCSTA1bits.RX9=0;
    RCSTA1bits.CREN=1;
    RCSTA1bits.ADDEN=0;
}

void initialiseIO()
{
    TRISBbits.TRISB4=0;
}

void initialiseUART(unsigned char* config,unsigned char* baudconfig)
{
    TRISCbits.TRISC7=1; 
    TRISCbits.TRISC6=0;
    
    BAUDCON1bits.RCIDL=1;
    BAUDCON1bits.BRG16=1;
    
    *config = USART_TX_INT_ON |         // Transmit interrupt on
              USART_RX_INT_ON |         // Receive interrupt on
              USART_ASYNCH_MODE |       // Asynchronous mode
              USART_EIGHT_BIT |         // 8-bit data
              USART_CONT_RX |           // Continuous reception
              USART_BRGH_HIGH;          // High baud rate
    
    SPBRG1 = 53;                        //configuration du baud rate  115200
    *baudconfig =  BAUD_16_BIT_RATE     // 16-bit baud generation rate
                   | BAUD_AUTO_OFF;     // auto baud rate measurement disabled
}

void initialiseInterruptions()
{
    RCONbits.IPEN = 1;       // Enable priority interrupts levels
    
    // INTCON register config
    INTCONbits.PEIE = 1;     // Enable periferal interrupts
    INTCONbits.INT0IE = 1;   // Enable External Interrupts on pin RB0

    INTCON2bits.INTEDG0 = 0; // INterupts on falling Edge of INT0
    INTCON2bits.RBPU = 1;    // Disable all PORTB pull up
    INTCONbits.RBIF = 0;
    
    // Reset interrupts before enabling those
    INTCONbits.INT0IF = 0;
    INTCONbits.RBIF = 0;
    
    // Enable Interrupts
    INTCONbits.GIE = 1;
}

void initialiseModem()
{
    send((char*)SysResetTable);
    send((char*)ModemStatus);
    send((char*)GetSysInfo);
    send((char*)GetExtendedSysInfo); 
    send((char*)SetInfoBaseTable);
    send((char*)SetNetCfgTable);
    send((char*)SetMacAddrTable);
    send((char*)SysInitTable);
    send((char*)SetMaxHopsTable);
    send((char*)SetMaxNetTravellTimeTable);
    send((char*)SetRouteResponseWaitTable);
    send((char*)SetMaxJoinTimeTable);
    send((char*)SetPathDiscoveryTimeTable);
    send((char*)SetBroadcastEtcTable);
    send((char*)SetRoutingTableTable);
    send((char*)SetMacTableTimeTable);
    send((char*)PanGetIbHandler1);
    send((char*)PanGetIbHandler2);
    send((char*)PanGetIbHandler3);
    send((char*)PanGetIbHandler4);
    send((char*)AutoJoinNetworkTable);
    send((char*)SendPayLodTable);
}
