
#include "usart.h" 
#include "initialisation.h"
#include "MIP.h"
#include "p18f67j60.h"

#define USE_OR_MASKS
#define EAUSART_V10

#pragma config FOSC = HS
#pragma config WDT = OFF    
#pragma config XINST = OFF  

unsigned char Rxdata[25]; 
unsigned char Txdata[] = "HELLO";
int i=0;

#pragma interrupt ISRroutine_low
void ISRroutine_low(void)
{
    Nop();
}


#pragma interrupt ISRroutine_high 
void ISRroutine_high(void)
{
    
    if(INTCONbits.INT0IF)
    {
        Rxdata[i]=Read1USART();
        i++;
        if(i==24)
            i=0;
        INTCONbits.INT0IF = 0; 
        
    }
    if(PIR1bits.RC1IF)
    {
        Nop();
    }
    
    if((PIR1bits.TX1IF) &&(PIE1bits.TX1IE))
    {
        PIE1bits.TX1IE = 0;
    }
    
}
// MCP  C18 nonsense to make an interrupt routine...
#pragma code ISR_vector_low = 0x0018
void ISR_call_low(void)
{
    _asm GOTO ISRroutine_low _endasm
    // Where ISRroutine is the actual ISR function
}
#pragma code

#pragma code ISR_vector_high = 0x0008
void ISR_call_high(void)
{
    _asm GOTO ISRroutine_high _endasm
}
#pragma code


void main(void) 
{	
    unsigned char config=0,baudconfig=0;
   
    initialiseTX();
    initialiseRX();
    initialiseIO();
    initialiseUART(&config,&baudconfig);
    initialiseInterruptions();
    
    Close1USART();                  
    initialiseModem();
    baud1USART (baudconfig);
    Open1USART(config,SPBRG1);
    LATBbits.LATB4=0;
    Close1USART(); 
}
