/******************************************************************************/
/*          affichage numrique dfilant en mode points 8x8                   */
/*          en vue du projet horloge sur 2 digits d'affichage                 */
/*           dfilement avec synchronisation par module DCF-77               */
/*  Cration: le 25/11/2016                                                   */
/*  Auteur: JYL (pseudo HULK28)                                               */
/*  Compilateur: MikroC v6.5.0 (ou tout compilateur ANSI-C) PIC18LF26K80      */
/*  Code version 1.0                                                          */
/*  -> mise en place du principe de base de l'affichage rotatif index        */
/******************************************************************************/

# include <dot8x8_display.h>

void init_PIC(void);
void count_rot(unsigned char t);

void main()
{
static unsigned char t=0;
init_PIC();
while(1)
     {
     if(t > 9) t = 0;
     else  count_rot(t);
     t++;
     }
}

void init_PIC(void)
{

OSCCON = 0b01010111;
ANCON0 = 0; // tout en digital
ANCON1 = 0; // tout en digital

LATB  = 0; // initialisation => tout OFF
TRISB = 0; // commande des cathodes (colonnes) => port en sortie
LATC  = 0; // initialisation => tout OFF
TRISC = 0; // commande des anodes (lignes) => port en sortie
}

void count_rot(unsigned char t)
{
char x = 0, y = 0, loop = 0;
unsigned char tick = 0;

tick = t;


    for(y=0; y<8; y++)  // index de droulement
    {
    if(y==0) loop = 100; // stabilisation momentanne du chiffre
    else loop = 2;       // sinon droulement
    while(loop > 0)
     {

     for(x=0; x<8; x++)  // index de droulement ligne
        {

        switch (tick)
                  {
                  case 0:LATC = chiffre_ZERO[y][x];break;
                  case 1:LATC = chiffre_UN[y][x];break;
                  case 2:LATC = chiffre_DEUX[y][x];break;
                  case 3:LATC = chiffre_TROIS[y][x];break;
                  case 4:LATC = chiffre_QUATRE[y][x];break;
                  case 5:LATC = chiffre_CINQ[y][x];break;
                  case 6:LATC = chiffre_SIX[y][x];break;
                  case 7:LATC = chiffre_SEPT[y][x];break;
                  case 8:LATC = chiffre_HUIT[y][x];break;
                  case 9:LATC = chiffre_NEUF[y][x];break;
                  default: break;
                  }
        LATB = 1 << x;  // droulement colonne
        Delay_ms(2);

        }

     if(loop > 0) loop--;
     }
    loop=8;  // persistence optique (flicker free)
    }

}