/*******************************************************************************
*  2014 Microchip Technology Inc.
*
* FileName:        ConfigBits.c  
* Dependencies:
* Processor:       dsPIC33EP512MU810
* Tested on:       EXPLORER16 development board (Microchip) ref DM240001
*                  dsPIC33EP512MU810 : processor module (PIM) ref  MA330025-1
* IDE :            MPLAB X v2.10 or above
* Compiler:        XC16 v1.21 or above
*
* Date :           18 Apr. 2014
*******************************************************************************/

/*** Header files *************************************************************/
#include <xc.h>             // XC compiler syntax : will work with ANY PIC ;=)

/*** Configuration bits********************************************************/
// dsPIC33EP512MU810 Configuration Bit Settings

// FOSCSEL
#pragma config FNOSC = FRC              // Oscillator Mode (Internal Fast RC (FRC))
#pragma config IESO = OFF               // Two-speed Oscillator Start-Up Enable (Start up with user-selected oscillator)

// FOSC
#pragma config POSCMD = XT              // Primary Oscillator Source (XT Oscillator Mode)
#pragma config OSCIOFNC = OFF           // OSC2 Pin Function (OSC2 pin has clock out function)
#pragma config FCKSM = CSECMD           // Clock Switching and Monitor (Clock switching is enabled, Fail-Safe Clock Monitor is disabled)

// FWDT
#pragma config WDTPOST = PS32768        // Watchdog Timer Postscaler (1:32,768)
#pragma config WDTPRE = PR128           // WDT Prescaler (1:128)
#pragma config PLLKEN = ON              // PLL Lock Enable bit (Clock switch to PLL source will wait until the PLL lock signal is valid.)
#pragma config WINDIS = OFF             // Watchdog Timer Window (Watchdog Timer in Non-Window mode)
#pragma config FWDTEN = OFF             // Watchdog Timer Enable (Watchdog timer enabled/disabled by user software)

// FPOR
#pragma config FPWRT = PWR8             // POR Timer Value (8ms)

// FICD
#pragma config ICS = PGD1               // Comm Channel Select (Communicate on PGC1/EMUC1 and PGD1/EMUD1) EXPLORER16
#pragma config JTAGEN = OFF             // JTAG Port Enable (JTAG is Disabled)
