/*******************************************************************************
*  2014 Microchip Technology Inc.
*
* FileName:        main.c
* Dependencies:    Header (.h) files if applicable, see below
* Processor:       dsPIC33EP512MU810
* Tested on:       EXPLORER16 development board (Microchip) ref DM240001
*                  dsPIC33EP512MU810 : processor module (PIM) ref  MA330025-1
* IDE :            MPLAB X v2.10 or above
* Compiler:        XC16 v1.21 or above
*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

*******************************************************************************/
#include "xc.h"
#include "main.h"
#include "uartDriver.h"

/*** Variables declaration ****************************************************/
volatile unsigned long IterationCounter=0;    // for performance measurements (if needed)
/******************************************************************************/

/*** Function prototypes ******************************************************/
void IOInit();
/******************************************************************************/

int main(void)
{
    unsigned long int c;

// Configure Oscillator to operate the device at Fcy = 40MIPS
// Fosc= Fin*M/(N1*N2), Fcy=Fosc/2
// Fosc= 8M*40(2*2)=80Mhz for 8M input clock
    PLLFBD = 38;                      // M=40
    CLKDIVbits.PLLPOST = 0;           // N1=2
    CLKDIVbits.PLLPRE = 0;            // N2=2
    OSCTUN=0;                       // Tune FRC oscillator, if FRC is used

    RCONbits.SWDTEN = 0;              // Disable Watch Dog Timer

    // Clock switch to incorporate PLL
    __builtin_write_OSCCONH(0x03);	// Initiate Clock Switch to Primary
                                        // Oscillator with PLL (NOSC=0b011)
    __builtin_write_OSCCONL(0x01);	// Start clock switching

    while (OSCCONbits.COSC != 0b011);       // Wait for Clock switch to occur
    while (OSCCONbits.LOCK != 1);             // Wait for PLL to lock

    IOInit();   // Initialize All PORTA as outputs for EXPLORER16 LEDs

    //This routine Configures DMAchannel 0 for transmission.
    cfgDma0UartTx();

    //This routine Configures DMAchannel 1 for reception.
    cfgDma1UartRx();

    // UART Configurations
    cfgUart2();

    while (1)                               // Background Loop
    {
        MainWhileLoopLed = MainWhileLoopLed ^1;  // main() infinite loop
        for ( c=0 ; c < 0x50000 ; c++ )    // delay for LED blinking
        {
            IterationCounter++;             // usable for performance measurements
        }
    }
}

void IOInit()
{
    LATA = 0x00;		// all LEDs OFF on EXPLORER16
    TRISA = 0x0000;	        // PORTA<7:0> as outputs for LED.
}
/******************************************************************************/

