/* Microchip Technology Inc. and its subsidiaries.  You may use this software 
 * and any derivatives exclusively with Microchip products. 
 * 
 * THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS".  NO WARRANTIES, WHETHER 
 * EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED 
 * WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A 
 * PARTICULAR PURPOSE, OR ITS INTERACTION WITH MICROCHIP PRODUCTS, COMBINATION 
 * WITH ANY OTHER PRODUCTS, OR USE IN ANY APPLICATION. 
 *
 * IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
 * INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
 * WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS 
 * BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE.  TO THE 
 * FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS 
 * IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF 
 * ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
 *
 * MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF THESE 
 * TERMS.
 */

/*
 * File:  lcd.h
 * Author: Corentin
 * Comments:
 * Revision history: Modified for PIC16F1718  2017_05_22  Arne Bergseth
 */

#ifndef _LCD_XC_H
#define	_LCD_XC_H

/**
  Section: Included Files
*/
#include "mcc_generated_files/mcc.h"

#ifdef	__cplusplus
extern "C" {
#endif

/**
 Section: Macro Definitions
*/
// set up the timing for the LCD delays
#define LCD_delay           50    // ~50 us
#define LCD_Startup         15    // ~15 ms

// Command set for MIDAS MC21605B6W-SPR LCD display controller
#define LCD_CLEAR           0x01
#define LCD_HOME            0x02
#define LCD_CURSOR_BACK     0x10
#define LCD_CURSOR_FWD      0x14
#define LCD_PAN_LEFT        0x18
#define LCD_PAN_RIGHT       0x1C
#define LCD_CURSOR_OFF      0x0C
#define LCD_CURSOR_ON       0x0E
#define LCD_CURSOR_BLINK    0x0F
#define LCD_CURSOR_LINE1    0x80
#define LCD_CURSOR_LINE2    0xC0

// display controller setup commands
#define FUNCTION_SET        0x28                         // 4 bit interface, 2 lines, 5x8 font
#define ENTRY_MODE          0x06                         // increment mode
#define DISPLAY_SETUP       0x0C                         // display on, cursor off, blink off

#define LCDLine1()			LCDPutCmd(LCD_CURSOR_LINE1)
#define LCDLine2()          LCDPutCmd(LCD_CURSOR_LINE2)  // legacy support
#define shift_cursor()      LCDPutCmd(LCD_CURSOR_FWD)    // legacy support
#define cursor_on()         LCDPutCmd(LCD_CURSOR_ON)     // legacy support
#define DisplayClr()        LCDPutCmd(LCD_CLEAR);	__delay_ms(2)
#define ReturnHome()		LCDPutCmd(LCD_HOME);	__delay_ms(2)


//----------------------------------------------------------------------
// Definitions specific to the PICDEM 2 Plus
// These apply to the Black (2011) version.
//----------------------------------------------------------------------

// single bit for selecting command register or data register
#define instr        0
#define data         1

//if defined _16F1619
  //These #defines create the pin connections to the LCD in case they are changed on a future demo board 

#define LCD_PORT     LATC
#define LCD_PORT_DIR(t) TRISCbits.TRISC0=(t);	TRISCbits.TRISC1=(t);	TRISCbits.TRISC2=(t);	TRISCbits.TRISC3=(t);    TRISCbits.TRISC4=(t);    TRISCbits.TRISC5=(t);    TRISCbits.TRISC6=(t);    TRISCbits.TRISC7=(t)
#define LCD_RS       LATBbits.LATB5                   // LCD register select line
#define LCD_RS_DIR   ANSELBbits.ANSB5=0;  TRISBbits.TRISB5                   
#define LCD_EN       LATBbits.LATB7                    // LCD  Enable
#define LCD_EN_DIR   ANSELBbits.ANSB7=0;  TRISBbits.TRISB7
#define LCD_D0       LATCbits.LATC0                    // LCD Data 0
#define LCD_D1       LATCbits.LATC1                    // LCD Data 1
#define LCD_D2       LATCbits.LATC2                    // LCD Data 2
#define LCD_D3       LATCbits.LATC3                    // LCD Data 3
#define LCD_D4       LATCbits.LATC4
#define LCD_D5       LATCbits.LATC5
#define LCD_D6       LATCbits.LATC6
#define LCD_D7       LATCbits.LATC7
#define LCD_PWR

#define NB_LINES    2                                   // Number of display lines
#define NB_COL      16                                  // Number of characters per line

//#elif defined  _16F1718
  /*#define LCD_PORT     LATB
  #define LCD_PORT_DIR(t) TRISBbits.TRISB0=(t);	TRISBbits.TRISB1=(t);	TRISBbits.TRISB2=(t);	TRISBbits.TRISB3=(t)
  #define LCD_RS       LATCbits.LATC5                    // LCD register select line
  #define LCD_RS_DIR   ANSELCbits.ANSC5=0;  TRISCbits.TRISC5
  #define LCD_RW       LATCbits.LATC6                    // LCD  R/w line
  #define LCD_RW_DIR   ANSELCbits.ANSC6=0;  TRISCbits.TRISC6
  #define LCD_EN       LATCbits.LATC7                    // LCD  Enable
  #define LCD_EN_DIR   ANSELCbits.ANSC7=0;  TRISCbits.TRISC7
  #define LCD_D0       LATBbits.LATB0                    // LCD Data 0
  #define LCD_D1       LATBbits.LATB1                    // LCD Data 1
  #define LCD_D2       LATBbits.LATB2                    // LCD Data 2
  #define LCD_D3       LATBbits.LATB3                    // LCD Data 3
  #define LCD_PWR

  #define NB_LINES    2                                   // Number of display lines
  #define NB_COL      16                                  // Number of characters per line
#endif*/

// Function prototypes
/**
  @Summary
    initialize the LCD module

  @Description
    This routine initializes the LCD driver.
    This routine must be called before any other LCD routine is called.

  @Preconditions
    None

  @Param
    None

  @Returns
    None
*/
void LCD_Initialize(void);
 
 /**
  @Summary
    Writes character to LCD at current cursor position

  @Description
    This function displays the specified ASCII character at current position on the LCD

  @Preconditions
    None

  @Param
    ASCII character to be displayed

  @Returns
    None
*/
void LCDPutChar(uint8_t ch);

/**
  @Summary
    send an ASCII command to the LCD in instruction mode

  @Description
    This routine writes character to LCD command register

  @Preconditions
    None

  @Param
    ASCII command

  @Returns
    None
*/
void LCDPutCmd(uint8_t ch);

/**
  @Summary
    display a string

  @Description
    This routine writes string to LCD at current cursor position

  @Preconditions
    None

  @Param
    Pointer to string

  @Returns
    None
*/
void LCDPutStr(const char *);                         

/**
  @Summary
    Fuction to write a nibble

  @Description
    This function writes the specified nibble to the LCD.

  @Preconditions
    None

  @Param
    data byte to be written to display

  @Returns
    None
*/
void LCDWriteNibble(uint8_t ch,uint8_t rs);

/**
  @Summary
    Initialization routine that takes inputs from the EUSART GUI.

  @Description
    This function positions the cursor at the specified Line and column.

  @Preconditions
    None

  @Param
    Column and line at which the cursor should be positioned at

  @Returns
    None

  @Comment
      0 <= pos <= 15
      0 <= ln <= 1
*/
void LCDGoto(uint8_t pos, uint8_t ln);
    
#ifdef	__cplusplus
}
#endif

#endif	/* _LCD_XC_H */