typedef void (*__interruptReadFunction)();

volatile __interruptReadFunction __interruptReadFunctionJump [3] = {0, 0, 0};

_INTERRUPT_JUMP (_INT0)
{
	__interruptReadFunctionJump [0]();
}

_INTERRUPT_JUMP (_INT1)
{
	__interruptReadFunctionJump [1]();
}

_INTERRUPT_JUMP (_INT2)
{
	__interruptReadFunctionJump [2]();
}

InterruptRead::InterruptRead (const unsigned char PIN)
{
	_interrupt = Core::pinToInterrupt (PIN);
}

void InterruptRead::start (void functionJump(), const bool RISING, const bool FALLING)
{
	__interruptReadFunctionJump [_interrupt] = functionJump;
	
	Core::startGlobalInterrupt();
	Core::startInterrupt (_interrupt, RISING, FALLING);
}

void InterruptRead::stop()
{
	Core::stopInterrupt (_interrupt);
	__interruptReadFunctionJump [_interrupt] = 0;
}
