unsigned char Tool::digitToByte (const unsigned char DIGIT, const bool COMMA)
{
	return Core::digitToByte (DIGIT, COMMA);
}

unsigned char Tool::characterToByte (const char *CHARACTER)
{
	unsigned char byte = 0;
	
	if (CHARACTER [0] != 0b00101110 && CHARACTER [1] == 0b00101110)
	{
		byte = Core::characterToByte (CHARACTER [0]) | 0b10000000;
	}
	else
	{
		byte = Core::characterToByte (CHARACTER [0]);
	}
	
	return byte;
}

unsigned char Tool::scanTwi()
{
	unsigned char n = 0;
	unsigned char device = 0;
	bool foundDevice = false;
	
	Core::startTwi();
	
	for (n = 0; n < 128 && foundDevice == false; n++)
	{
		if (Core::scanTwi (n) == true)
		{
			device = n;
			foundDevice = true;
		}
	}
	
	return device;
}

signed int Tool::sram()
{
	extern signed int __heap_start;
	extern signed int *__brkval;
	signed int *value = 0;
	
	return (signed int)(&value) - (__brkval == 0 ? (signed int)(&__heap_start) : (signed int)(__brkval));
}
