signed long Memory::read (const unsigned int ADDRESS, const signed char LENGTH)
{
	unsigned long data = 0;
	
	if (LENGTH < 0)
	{
		if (LENGTH == -8)
		{
			data = (signed char)(Core::readEeprom (ADDRESS - 1));
		}
		else if (LENGTH == -16)
		{
			data = (signed int)(Core::readEeprom (ADDRESS - 1)) << 8 | (signed int)(Core::readEeprom (ADDRESS));
		}
		else
		{
			data = (signed long)(Core::readEeprom (ADDRESS - 1)) << 24 | (signed long)(Core::readEeprom (ADDRESS)) << 16 | (signed long)(Core::readEeprom (ADDRESS + 1)) << 8 | (signed long)(Core::readEeprom (ADDRESS + 2));
		}
	}
	else
	{
		if (LENGTH == 8)
		{
			data = (unsigned char)(Core::readEeprom (ADDRESS - 1));
		}
		else if (LENGTH == 16)
		{
			data = (unsigned int)(Core::readEeprom (ADDRESS - 1)) << 8 | (unsigned int)(Core::readEeprom (ADDRESS));
		}
		else
		{
			data = (unsigned long)(Core::readEeprom (ADDRESS - 1)) << 24 | (unsigned long)(Core::readEeprom (ADDRESS)) << 16 | (unsigned long)(Core::readEeprom (ADDRESS + 1)) << 8 | (unsigned long)(Core::readEeprom (ADDRESS + 2));
		}
	}
	
	return data;
}

void Memory::write (const unsigned int ADDRESS, const signed long DATA, const signed char LENGTH)
{
	if (LENGTH == 8 || LENGTH == -8)
	{
		if (Core::readEeprom (ADDRESS - 1) != DATA)
		{
			Core::writeEeprom (ADDRESS - 1, DATA);
		}
	}
	else if (LENGTH == 16 || LENGTH == -16)
	{
		if (Core::readEeprom (ADDRESS - 1) != DATA >> 8)
		{
			Core::writeEeprom (ADDRESS - 1, DATA >> 8);
		}
		
		if (Core::readEeprom (ADDRESS) != DATA)
		{
			Core::writeEeprom (ADDRESS, DATA);
		}
	}
	else
	{
		if (Core::readEeprom (ADDRESS - 1) != DATA >> 24)
		{
			Core::writeEeprom (ADDRESS - 1, DATA >> 24);
		}
		
		if (Core::readEeprom (ADDRESS) != DATA >> 16)
		{
			Core::writeEeprom (ADDRESS, DATA >> 16);
		}
		
		if (Core::readEeprom (ADDRESS + 1) != DATA >> 8)
		{
			Core::writeEeprom (ADDRESS + 1, DATA >> 8);
		}
		
		if (Core::readEeprom (ADDRESS + 2) != DATA)
		{
			Core::writeEeprom (ADDRESS + 2, DATA);
		}
	}
}

void Memory::erase()
{
	unsigned int n = 0;
	
	for (n = 0; n < 512; n++)
	{
		if (Core::readEeprom (n) != 0)
		{
			Core::writeEeprom (n, 0);
		}
	}
}
