volatile unsigned char __pwmWriteCount = 0;
volatile unsigned char __pwmWriteCurrent = 0;
volatile unsigned char __pwmWritePrevious = 0;
volatile unsigned char *__pwmWriteRegisterPort [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char __pwmWriteBytePort [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned int __pwmWriteValueOcr1 [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

_INTERRUPT_JUMP (_TIMER1_OVF)
{
	*__pwmWriteRegisterPort [__pwmWritePrevious] &= ~__pwmWriteBytePort [__pwmWritePrevious];
	
	if (__pwmWriteValueOcr1 [__pwmWriteCurrent] != 0)
	{
		*__pwmWriteRegisterPort [__pwmWriteCurrent] |= __pwmWriteBytePort [__pwmWriteCurrent];
	}
	
	__pwmWritePrevious = __pwmWriteCurrent;
	
	if (__pwmWriteCurrent < __pwmWriteCount - 1)
	{
		__pwmWriteCurrent++;
	}
	else
	{
		__pwmWriteCurrent = 0;
	}
	
	if (__pwmWriteValueOcr1 [__pwmWriteCurrent] != 0)
	{
		Core::outputCompareTimer1 (__pwmWriteValueOcr1 [__pwmWriteCurrent]);
	}
}

_INTERRUPT_JUMP (_TIMER1_COMPA)
{
	*__pwmWriteRegisterPort [__pwmWritePrevious] &= ~__pwmWriteBytePort [__pwmWritePrevious];
}

PwmWrite::PwmWrite (const unsigned char PIN)
{
	if (Core::pinIsChannelTimer1 (PIN) == false)
	{
		_hardware = false;
	}
	else if (_hardware == true)
	{
		_pin [_nDevice] = PIN;
		_registerOcr1 = Core::pinToRegisterOcr1 (PIN);
		_byteCom1 = Core::pinToByteCom1 (PIN);
	}
	
	__pwmWriteRegisterPort [__pwmWriteCount] = Core::pinToRegisterPort (PIN);
	__pwmWriteBytePort [__pwmWriteCount] = Core::pinToBytePort (PIN);
	
	*Core::pinToRegisterDdr (PIN) |= __pwmWriteBytePort [__pwmWriteCount];
	
	_nDevice = __pwmWriteCount;
	
	__pwmWriteCount++;
}

void PwmWrite::start (const unsigned long FREQUENCY)
{
	unsigned char n = 0;
	unsigned int prescaler = 0;
	unsigned int valueOcr1 = 0;
	
	Core::startGlobalInterrupt();
	Core::modeTimer1();
	
	if (_hardware == false)
	{
		prescaler = Core::frequencyToPrescalerTimer1 (FREQUENCY * long (__pwmWriteCount));
		
		Core::prescalerTimer1 (prescaler);
		
		_frequency = FREQUENCY * long (__pwmWriteCount);
		_valueIcr1 = Core::round (((16000000.0 / float (prescaler)) / (float (FREQUENCY) * float (__pwmWriteCount))) - 1.0);
		
		for (n = 0; n < __pwmWriteCount; n++)
		{
			__pwmWriteValueOcr1 [n] = Core::round (float (_valueIcr1) - (float (_valueIcr1) - (float (_valueIcr1) / ((1000000.0 / _us [n]) / float (_frequency)))));
		}
		
		Core::inputCaptureTimer1 (_valueIcr1);
		Core::startInterruptTimer1();
	}
	else
	{
		prescaler = Core::frequencyToPrescalerTimer1 (FREQUENCY);
		
		Core::prescalerTimer1 (prescaler);
		
		_frequency = FREQUENCY;
		_valueIcr1 = Core::round (((16000000.0 / float (prescaler)) / float (FREQUENCY)) - 1.0);
		
		Core::inputCaptureTimer1 (_valueIcr1);
		
		for (n = 0; n < __pwmWriteCount; n++)
		{
			valueOcr1 = Core::round (float (_valueIcr1) - (float (_valueIcr1) - (float (_valueIcr1) / ((1000000.0 / _us [n]) / float (_frequency)))));
			
			if (valueOcr1 != 0)
			{
				*Core::pinToRegisterOcr1 (_pin [n]) = valueOcr1;
				Core::startOutputCompareMatchTimer1 (Core::pinToByteCom1 (_pin [n]));
			}
		}
	}
}

void PwmWrite::us (const float US)
{
	const unsigned int VALUE_OCR1 = Core::round (float (_valueIcr1) - (float (_valueIcr1) - (float (_valueIcr1) / ((1000000.0 / US) / float (_frequency)))));
	
	if (_frequency == 0)
	{
		_us [_nDevice] = US;
	}
	else
	{
		if (_hardware == false)
		{
			__pwmWriteValueOcr1 [_nDevice] = VALUE_OCR1;
		}
		else
		{
			if (VALUE_OCR1 != 0)
			{
				*_registerOcr1 = VALUE_OCR1;
				Core::startOutputCompareMatchTimer1 (_byteCom1);
			}
			else
			{
				Core::stopOutputCompareMatchTimer1 (_byteCom1);
			}
		}
	}
}
