GpioRead::GpioRead (const unsigned char PIN, const bool PULL_UP_INTERNAL, const unsigned char DEBOUNCING)
{
	_registerPin = Core::pinToRegisterPin (PIN);
	_bytePort = Core::pinToBytePort (PIN);
	
	if (PULL_UP_INTERNAL == true)
	{
		*_registerPin = _bytePort;
		_pullUpInternal = true;
	}
	
	if (DEBOUNCING != 0)
	{
		_debouncing = DEBOUNCING;
		
		Core::startGlobalInterrupt();
		Core::startInterruptTimer0();
	}
}

void GpioRead::read()
{
	const bool VALUE_PIN = *_registerPin & _bytePort;
	
	if (((VALUE_PIN == true && _pullUpInternal == false) || (VALUE_PIN == false && _pullUpInternal == true)) && continuous == false)
	{
		if (_debouncing == 0)
		{
			continuous = true;
		}
		else if (Core::ms() >= _timePreviousContinuous)
		{
			_timePreviousContinuous = Core::ms() + (long long)(_debouncing);
			continuous = true;
		}
	}
	else if (((VALUE_PIN == false && _pullUpInternal == false) || (VALUE_PIN == true && _pullUpInternal == true)) && continuous == true)
	{
		if (_debouncing == 0)
		{
			continuous = false;
		}
		else if (Core::ms() >= _timePreviousContinuous)
		{
			_timePreviousContinuous = Core::ms() + (long long)(_debouncing);
			continuous = false;
		}
	}
	
	if (((VALUE_PIN == true && _pullUpInternal == false) || (VALUE_PIN == false && _pullUpInternal == true)) && _lockMomentary == false)
	{
		momentary = true;
		_lockMomentary = true;
	}
	else if (momentary == true && _lockMomentary == true)
	{
		_timePreviousMomentary = Core::ms() + (long long)(_debouncing);
		momentary = false;
	}
	else if (((VALUE_PIN == false && _pullUpInternal == false) || (VALUE_PIN == true && _pullUpInternal == true)) && _lockMomentary == true)
	{
		if (_debouncing == 0)
		{
			_lockMomentary = false;
		}
		else if (Core::ms() >= _timePreviousMomentary)
		{
			_lockMomentary = false;
		}
	}
}
