volatile unsigned char __networkId = 0;
volatile unsigned char __networkAddress = 0;
volatile signed long __networkTemporaryData = 0;
volatile signed long __networkCheck = 0;
volatile signed long __networkData [16][16] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};

_INTERRUPT_JUMP (_USART_RX)
{
	if (Core::readUsart (8) == 0b01010101)
	{
		__networkId = Core::readUsart (8);
		__networkAddress = Core::readUsart (8);
		__networkTemporaryData = Core::readUsart (32);
		
		if (__networkId >= __networkAddress)
		{
			__networkCheck = __networkId - __networkAddress;
		}
		else
		{
			__networkCheck = __networkAddress - __networkId;
		}
		
		if (__networkCheck >= __networkTemporaryData)
		{
			__networkCheck -= __networkTemporaryData;
		}
		else
		{
			__networkCheck = __networkTemporaryData - __networkCheck;
		}
		
		if (__networkCheck == Core::readUsart (32))
		{
			__networkData [__networkId][__networkAddress] = __networkTemporaryData;
		}
	}
}

Network::Network (const unsigned char ID, const unsigned char ADDRESS)
{
	_id = ID - 1;
	_address = ADDRESS - 1;
}

void Network::start (const bool RECEIVER, const bool TRANSMITTER)
{
	Core::startUsart (RECEIVER, TRANSMITTER);
	Core::startGlobalInterrupt();
}

void Network::receive()
{
	data = __networkData [_id][_address];
}

void Network::transmit (const signed long DATA)
{
	signed long check = 0;
	
	Core::writeUsart (0b01010101, 8);
	Core::writeUsart (_id, 8);
	Core::writeUsart (_address, 8);
	Core::writeUsart (DATA, 32);
	
	if (_id >= _address)
	{
		check = _id - _address;
	}
	else
	{
		check = _address - _id;
	}
	
	if (check >= DATA)
	{
		check -= DATA;
	}
	else
	{
		check = DATA - check;
	}
	
	Core::writeUsart (check, 32);
}
