#!/bin/bash

device="error"

while true
do
	if [ $device != "error" ]
	then
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m$device -U signature:r:signature$device:i
		
		if [ -f signature$device ]
		then
			rm signature$device -f
		else
			device="error"
		fi
	fi
	
	if [ $device == "error" ]
	then
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m48p -U signature:r:signature48p:i
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m88p -U signature:r:signature88p:i
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m168p -U signature:r:signature168p:i
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m328p -U signature:r:signature328p:i
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m164p -U signature:r:signature164p:i
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m324p -U signature:r:signature324p:i
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m644p -U signature:r:signature644p:i
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m1284p -U signature:r:signature1284p:i
		
		if [ -f signature48p ]
		then
			device="48p"
		elif [ -f signature88p ]
		then
			device="88p"
		elif [ -f signature168p ]
		then
			device="168p"
		elif [ -f signature328p ]
		then
			device="328p"
		elif [ -f signature164p ]
		then
			device="164p"
		elif [ -f signature324p ]
		then
			device="324p"
		elif [ -f signature644p ]
		then
			device="644p"
		elif [ -f signature1284p ]
		then
			device="1284p"
		else
			device="error"
		fi
		
		if [ $device != "error" ]
		then
			rm signature$device -f
		fi
	fi
	
	if [ $device != "error" ]
	then
		clear
		
		echo "avr-gcc main.cpp -> atmega"$device
		
		avr-gcc main.cpp -mmcu=atmega$device -Wall -Wno-sign-compare -Os -ffunction-sections -fdata-sections -Wl,--gc-sections -std=c++11 -o main.elf
		
		if [ -f main.elf ]
		then
			avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m$device -e
			
			if [ $device == "48p" ] || [ $device == "88p" ] || [ $device == "168p" ] || [ $device == "328p" ]
			then
				avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m$device -U lfuse:w:0xff:m -U hfuse:w:0xdf:m -U efuse:w:0x04:m
			else
				avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m$device -U lfuse:w:0xff:m -U hfuse:w:0xdf:m -U efuse:w:0xfc:m
			fi
			
			objcopy main.elf -O ihex main.hex
			avrdude -P /dev/ttyACM0 -c usbasp -p m$device -U flash:w:main.hex:i
			avr-size main.elf -dC --mcu atmega$device
			
			rm main.elf -f
			rm main.hex -f
		fi
	fi
	
	read
	clear
done

exit 0
