Mpu6050::Mpu6050 (const unsigned char DEVICE)
{
	unsigned char n = 0;
	bool foundDevice = false;
	
	Core::startTwi();
	
	if (DEVICE == 0)
	{
		for (n = 0; n < 128 && foundDevice == false; n++)
		{
			if (Core::scanTwi (n) == true)
			{
				_device = n;
				foundDevice = true;
			}
		}
	}
	else
	{
		_device = DEVICE;
	}
	
	while (Core::readTwi (_device, 0x75, 8) == 0b00000000)
	{
	}
	
	Core::writeTwi (_device, 0x6b, 0b00000001, 8);
	Core::writeTwi (_device, 0x1c, 0b00001000, 8);
	Core::writeTwi (_device, 0x1b, 0b00011000, 8);
}

void Mpu6050::read()
{
	tx = float (Core::readTwi (_device, 0x3b, 16)) / 8192.0;
	ty = float (Core::readTwi (_device, 0x3d, 16)) / 8192.0;
	tz = float (Core::readTwi (_device, 0x3f, 16)) / 8192.0;
	rx = float (Core::readTwi (_device, 0x43, 16)) / 16.0;
	ry = float (Core::readTwi (_device, 0x45, 16)) / 16.0;
	rz = float (Core::readTwi (_device, 0x47, 16)) / 16.0;
	temperature = (float (Core::readTwi (_device, 0x41, 16)) / 340.0) + 36.53;
}

void Mpu6050::readTranslation()
{
	tx = float (Core::readTwi (_device, 0x3b, 16)) / 8192.0;
	ty = float (Core::readTwi (_device, 0x3d, 16)) / 8192.0;
	tz = float (Core::readTwi (_device, 0x3f, 16)) / 8192.0;
}

void Mpu6050::readRotation()
{
	rx = float (Core::readTwi (_device, 0x43, 16)) / 16.0;
	ry = float (Core::readTwi (_device, 0x45, 16)) / 16.0;
	rz = float (Core::readTwi (_device, 0x47, 16)) / 16.0;
}

void Mpu6050::readTemperature()
{
	temperature = (float (Core::readTwi (_device, 0x41, 16)) / 340.0) + 36.53;
}
