Bno055::Bno055 (const unsigned char DEVICE)
{
	unsigned char n = 0;
	bool foundDevice = false;
	
	Core::startTwi();
	
	if (DEVICE == 0)
	{
		for (n = 0; n < 128 && foundDevice == false; n++)
		{
			if (Core::scanTwi (n) == true)
			{
				_device = n;
				foundDevice = true;
			}
		}
	}
	else
	{
		_device = DEVICE;
	}
	
	while (Core::readTwi (_device, 0x36, 8) != 0b00001111)
	{
	}
	
	while (Core::readTwi (_device, 0x39, 8) != 0b00000000)
	{
	}
	
	Core::writeTwi (_device, 0x3d, 0b00001100, 8);
	
	while (Core::readTwi (_device, 0x39, 8) != 0b00000101)
	{
	}
}

void Bno055::read()
{
	signed int gzRaw = 0;
	signed int rollRaw = 0;
	signed int yawRaw = 0;
	
	gx = float (Core::readTwi (_device, 0x2e, -16)) / 100.0;
	gy = float (Core::readTwi (_device, 0x30, -16)) / 100.0;
	gzRaw = Core::readTwi (_device, 0x32, -16);
	
	gz = float (gzRaw) / 100.0;
	
	tx = float (Core::readTwi (_device, 0x28, -16)) / 100.0;
	ty = float (Core::readTwi (_device, 0x2a, -16)) / 100.0;
	tz = float (Core::readTwi (_device, 0x2c, -16)) / 100.0;
	
	rx = float (Core::readTwi (_device, 0x14, -16)) / 16.0;
	ry = float (Core::readTwi (_device, 0x16, -16)) / 16.0;
	rz = float (Core::readTwi (_device, 0x18, -16)) / 16.0;
	
	qw = Core::readTwi (_device, 0x20, -16);
	qx = Core::readTwi (_device, 0x22, -16);
	qy = Core::readTwi (_device, 0x24, -16);
	qz = Core::readTwi (_device, 0x26, -16);
	
	mx = float (Core::readTwi (_device, 0x0e, -16)) / 16.0;
	my = float (Core::readTwi (_device, 0x10, -16)) / 16.0;
	mz = float (Core::readTwi (_device, 0x12, -16)) / 16.0;
	
	pitch = float (Core::readTwi (_device, 0x1e, -16)) / 16.0;
	rollRaw = Core::readTwi (_device, 0x1c, -16);
	yawRaw = Core::readTwi (_device, 0x1a, -16);
	
	if (gzRaw < 0)
	{
		if (rollRaw < 0)
		{
			roll = -180.0 - (float (rollRaw) / 16.0);
		}
		else
		{
			roll = 180.0 - (float (rollRaw) / 16.0);
		}
	}
	else
	{
		roll = float (rollRaw) / 16.0;
	}
	
	rollAero = float (rollRaw) / 16.0;
	
	if (yawRaw < 2880)
	{
		yaw = float (yawRaw) / 16.0;
	}
	else
	{
		yaw = (float (yawRaw) / 16.0) - 360.0;
	}
	
	temperature = Core::readTwi (_device, 0x34, 8);
}

void Bno055::readGravity()
{
	gx = float (Core::readTwi (_device, 0x2e, -16)) / 100.0;
	gy = float (Core::readTwi (_device, 0x30, -16)) / 100.0;
	gz = float (Core::readTwi (_device, 0x32, -16)) / 100.0;
}

void Bno055::readTranslation()
{
	tx = float (Core::readTwi (_device, 0x28, -16)) / 100.0;
	ty = float (Core::readTwi (_device, 0x2a, -16)) / 100.0;
	tz = float (Core::readTwi (_device, 0x2c, -16)) / 100.0;
}

void Bno055::readRotation()
{
	rx = float (Core::readTwi (_device, 0x14, -16)) / 16.0;
	ry = float (Core::readTwi (_device, 0x16, -16)) / 16.0;
	rz = float (Core::readTwi (_device, 0x18, -16)) / 16.0;
}

void Bno055::readQuaternion()
{
	qw = Core::readTwi (_device, 0x20, -16);
	qx = Core::readTwi (_device, 0x22, -16);
	qy = Core::readTwi (_device, 0x24, -16);
	qz = Core::readTwi (_device, 0x26, -16);
}

void Bno055::readMagnetism()
{
	mx = float (Core::readTwi (_device, 0x0e, -16)) / 16.0;
	my = float (Core::readTwi (_device, 0x10, -16)) / 16.0;
	mz = float (Core::readTwi (_device, 0x12, -16)) / 16.0;
}

void Bno055::readHorizon()
{
	signed int gzRaw = 0;
	signed int rollRaw = 0;
	signed int yawRaw = 0;
	
	gzRaw = Core::readTwi (_device, 0x32, -16);
	
	pitch = float (Core::readTwi (_device, 0x1e, -16)) / 16.0;
	rollRaw = Core::readTwi (_device, 0x1c, -16);
	yawRaw = Core::readTwi (_device, 0x1a, -16);
	
	if (gzRaw < 0)
	{
		if (rollRaw < 0)
		{
			roll = -180.0 - (float (rollRaw) / 16.0);
		}
		else
		{
			roll = 180.0 - (float (rollRaw) / 16.0);
		}
	}
	else
	{
		roll = float (rollRaw) / 16.0;
	}
	
	rollAero = float (rollRaw) / 16.0;
	
	if (yawRaw < 2880)
	{
		yaw = float (yawRaw) / 16.0;
	}
	else
	{
		yaw = (float (yawRaw) / 16.0) - 360.0;
	}
}

void Bno055::readTemperature()
{
	temperature = Core::readTwi (_device, 0x34, 8);
}
