Nrf24l01p::Nrf24l01p (const unsigned char ADDRESS)
{
	_address = ADDRESS - 1;
}

void Nrf24l01p::start (const unsigned char PIN_SS, const unsigned char PIN_ANTI_COLLISION, const unsigned long ID, const bool POWER)
{
	_registerPin = Core::pinToRegisterPin (PIN_SS);
	_bytePort = Core::pinToBytePort (PIN_SS);
	
	if (PIN_ANTI_COLLISION != 0)
	{
		_byteAdmux = Core::pinToByteAdmux (PIN_ANTI_COLLISION);
	}
	else
	{
		_antiCollision = false;
	}
	
	*Core::pinToRegisterDdr (PIN_SS) |= _bytePort;
	*Core::pinToRegisterPort (PIN_SS) |= _bytePort;
	
	Core::startSpi (0);
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x01 | 0x20, 0b00111111, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x05 | 0x20, 0b00000010, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x07 | 0x20, 0b00001110, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x0b | 0x20, 0b00000000, 8);
	Core::writeSpiPush (0b00000000000000000000000000000000, 32);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x0c | 0x20, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x0d | 0x20, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x0e | 0x20, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x0f | 0x20, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x12 | 0x20, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x13 | 0x20, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x14 | 0x20, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x15 | 0x20, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x16 | 0x20, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x17 | 0x20, 0b00010001, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x1c | 0x20, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x1d | 0x20, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	
	if (POWER == false)
	{
		Core::writeSpi (0x06 | 0x20, 0b00001000, 8);
	}
	else
	{
		Core::writeSpi (0x06 | 0x20, 0b00001110, 8);
	}
	
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x03 | 0x20, 0b00000010, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x11 | 0x20, 0b00000101, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x0a | 0x20, 0b00000000, 8);
	Core::writeSpiPush (ID, 32);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x10 | 0x20, 0b00000000, 8);
	Core::writeSpiPush (ID, 32);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x02 | 0x20, 0b00000001, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x04 | 0x20, 0b00010000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpi (0x00 | 0x20, 0b01111011, 8);
	*_registerPin = _bytePort;
	
	Core::startAnalog();
	Core::startGlobalInterrupt();
	Core::startInterruptTimer0();
	
	_started = true;
}

void Nrf24l01p::receive()
{
	unsigned char status = 0;
	unsigned char address = 0;
	
	if (_started == true)
	{
		*_registerPin = _bytePort;
		status = Core::readSpi (0x07, 8);
		*_registerPin = _bytePort;
		
		if ((status & 0b01000000) == 0b01000000)
		{
			*_registerPin = _bytePort;
			address = Core::readSpi (0x61, 8);
			_data [address] = Core::readSpiPush (32);
			*_registerPin = _bytePort;
			
			*_registerPin = _bytePort;
			Core::writeSpi (0xe2, 0b00000000, 8);
			*_registerPin = _bytePort;
			
			*_registerPin = _bytePort;
			Core::writeSpi (0x07 | 0x20, 0b01000000, 8);
			*_registerPin = _bytePort;
			
			_received [address] = true;
		}
		
		data = _data [_address];
		received = _received [_address];
	}
}

void Nrf24l01p::transmit (const signed long DATA)
{
	unsigned char status = 0;
	unsigned char shift = 0;
	unsigned char search = 0;
	unsigned char randomValue = 0;
	unsigned int analogReadPrevious = 0;
	unsigned int analogReadNext = 0;
	float artificialNoise = 1;
	unsigned long long timePrevious = 0;
	
	if (_started == true)
	{
		if (_antiCollision == true)
		{
			*_registerPin = _bytePort;
			status = Core::readSpi (0x07, 8);
			*_registerPin = _bytePort;
			
			if ((status & 0b01000000) == 0b00000000)
			{
				for (shift = 0; shift < 7; shift++)
				{
					for (search = 0; analogReadPrevious == analogReadNext && search < 8; search++)
					{
						analogReadPrevious = Core::readAnalog (_byteAdmux);
						analogReadNext = Core::readAnalog (_byteAdmux);
					}
					
					if (analogReadPrevious == analogReadNext)
					{
						artificialNoise = (artificialNoise + float (_seed)) * 2.5;
						analogReadPrevious = (unsigned int)(artificialNoise);
					}
					
					if (_seed < 254)
					{
						_seed++;
					}
					else
					{
						_seed = 0;
					}
					
					randomValue |= (unsigned char)(analogReadPrevious & 0b0000000000000001) << shift;
					
					analogReadPrevious = 0;
					analogReadNext = 0;
				}
				
				timePrevious = Core::us();
				
				while (Core::us() < timePrevious + (long long)(randomValue))
				{
				}
			}
			
			status = 0b00000000;
		}
		
		*_registerPin = _bytePort;
		Core::writeSpi (0x00 | 0x20, 0b01111000, 8);
		*_registerPin = _bytePort;
		
		*_registerPin = _bytePort;
		Core::writeSpi (0x00 | 0x20, 0b01111010, 8);
		*_registerPin = _bytePort;
		
		*_registerPin = _bytePort;
		Core::writeSpi (0xa0, _address, 8);
		Core::writeSpiPush (DATA, 32);
		*_registerPin = _bytePort;
		
		while ((status & 0b00110000) == 0b00000000)
		{
			*_registerPin = _bytePort;
			status = Core::readSpi (0x07, 8);
			*_registerPin = _bytePort;
		}
		
		if ((status & 0b00100000) == 0b00100000)
		{
			_data [_address] = DATA;
			data = DATA;
			
			transmitted = true;
		}
		
		*_registerPin = _bytePort;
		Core::writeSpi (0xe1, 0b00000000, 8);
		*_registerPin = _bytePort;
		
		*_registerPin = _bytePort;
		Core::writeSpi (0x07 | 0x20, 0b00110000, 8);
		*_registerPin = _bytePort;
		
		*_registerPin = _bytePort;
		Core::writeSpi (0x00 | 0x20, 0b01111001, 8);
		*_registerPin = _bytePort;
		
		*_registerPin = _bytePort;
		Core::writeSpi (0x00 | 0x20, 0b01111011, 8);
		*_registerPin = _bytePort;
	}
}

void Nrf24l01p::reset()
{
	data = 0;
	received = false;
	transmitted = false;
	
	_data [_address] = 0;
	_received [_address] = false;
}

void Nrf24l01p::stop()
{
	if (_started == true)
	{
		*_registerPin = _bytePort;
		Core::writeSpi (0x00 | 0x20, 0b01111001, 8);
		*_registerPin = _bytePort;
		
		_started = false;
	}
}
