Bmp180::Bmp180 (const unsigned char DEVICE)
{
	unsigned char n = 0;
	bool foundDevice = false;
	
	Core::startTwi();
	
	if (DEVICE == 0)
	{
		for (n = 0; n < 128 && foundDevice == false; n++)
		{
			if (Core::scanTwi (n) == true)
			{
				_device = n;
				foundDevice = true;
			}
		}
	}
	else
	{
		_device = DEVICE;
	}
	
	while (Core::readTwi (_device, 0xd0, 8) == 0b00000000)
	{
	}
	
	Core::startGlobalInterrupt();
	Core::startInterruptTimer0();
}

void Bmp180::read()
{
	signed int ac1 = 0;
	signed int ac2 = 0;
	signed int ac3 = 0;
	unsigned int ac4 = 0;
	unsigned int ac5 = 0;
	unsigned int ac6 = 0;
	signed int b1 = 0;
	signed int b2 = 0;
	signed int mc = 0;
	signed int md = 0;
	unsigned int pressureRaw = 0;
	signed int temperatureRaw = 0;
	float x1 = 0;
	float x3 = 0;
	float b3 = 0;
	float b4 = 0;
	float b5 = 0;
	float b6 = 0;
	float b7 = 0;
	float bp = 0;
	float x11 = 0;
	float rp = 0;
	
	if (_stateRead == 0)
	{
		Core::writeTwi (_device, 0xf4, 0b00110100, 8);
		
		_timePrevious = Core::us();
		_stateRead = 1;
	}
	else if (_stateRead == 1 && Core::us() >= _timePrevious + 4500ll)
	{
		_pressureRaw = Core::readTwi (_device, 0xf6, 16);
		
		Core::writeTwi (_device, 0xf4, 0b00101110, 8);
		
		_timePrevious = Core::us();
		_stateRead = 2;
	}
	else if (_stateRead == 2 && Core::us() >= _timePrevious + 4500ll)
	{
		pressureRaw = _pressureRaw;
		temperatureRaw = Core::readTwi (_device, 0xf6, 16);
		
		ac1 = Core::readTwi (_device, 0xaa, 16);
		ac2 = Core::readTwi (_device, 0xac, 16);
		ac3 = Core::readTwi (_device, 0xae, 16);
		ac4 = Core::readTwi (_device, 0xb0, 16);
		ac5 = Core::readTwi (_device, 0xb2, 16);
		ac6 = Core::readTwi (_device, 0xb4, 16);
		b1 = Core::readTwi (_device, 0xb6, 16);
		b2 = Core::readTwi (_device, 0xb8, 16);
		mc = Core::readTwi (_device, 0xbc, 16);
		md = Core::readTwi (_device, 0xbe, 16);
		
		x1 = (float (temperatureRaw) - float (ac6)) * (float (ac5) / 32768.0);
		b5 = x1 + ((float (mc) * 2048.0) / (x1 + float (md)));
		b6 = b5 - 4000.0;
		b3 = (((float (ac1) * 4.0) + (((float (b2) * ((b6 * b6) / 4096.0)) / 2048.0) + ((float (ac2) * b6) / 2048.0))) + 2.0) / 4.0;
		x3 = ((((float (ac3) * b6) / 8192.0) + ((float (b1) * ((b6 * b6) / 4096.0)) / 65536.0)) + 2.0) / 4.0;
		b4 = (float (ac4) * (x3 + 32768.0)) / 32768.0;
		b7 = (float (pressureRaw) - b3) * 50000.0;
		bp = (b7 * 2.0) / b4;
		x1 = bp / 256.0;
		x11 = ((x1 * x1) * 3038.0) / 65536.0;
		rp = bp + (((x11 + ((-7357.0 * bp) / 65536.0)) + 3791.0) / 16.0);
		
		pressure = rp;
		altitude = Core::curve (110000, rp, 30000, -500, 9000, 0);
		temperature = (b5 + 8.0) / 160.0;
		
		Core::writeTwi (_device, 0xf4, 0b00110100, 8);
		
		_timePrevious = Core::us();
		_stateRead = 1;
	}
}
