#ifndef _CORE_H
#define _CORE_H

#include "Define.h"

class Core
{
	private:
	static const float _DEGREE_TO_RADIAN;
	static const float _RADIAN_TO_DEGREE;
	static unsigned char _countSpiDevice [20];
	
	public:
	static unsigned long long s();
	static unsigned long long ms();
	static unsigned long long us();
	static volatile unsigned char *pinToRegisterPort (const unsigned char PIN);
	static volatile unsigned char *pinToRegisterDdr (const unsigned char PIN);
	static volatile unsigned char *pinToRegisterPin (const unsigned char PIN);
	static unsigned char pinToBytePort (const unsigned char PIN);
	static unsigned char pinToInterrupt (const unsigned char PIN);
	static volatile unsigned char *pinToRegisterPcmsk (const unsigned char PIN);
	static unsigned char pinToBytePcie (const unsigned char PIN);
	static bool pinIsChannelTimer1 (const unsigned char PIN);
	static unsigned char pinToByteCom1 (const unsigned char PIN);
	static volatile unsigned int *pinToRegisterOcr1 (const unsigned char PIN);
	static unsigned char pinToByteAdmux (const unsigned char PIN);
	static void startGlobalInterrupt();
	static void startInterruptTimer0();
	static void modeTimer1();
	static unsigned int frequencyToPrescalerTimer1 (const unsigned int FREQUENCY);
	static void prescalerTimer1 (const unsigned int PRESCALER);
	static void inputCaptureTimer1 (const unsigned int VALUE);
	static void outputCompareTimer1 (const unsigned int VALUE);
	static void startInterruptTimer1();
	static void startOutputCompareMatchTimer1 (const unsigned char BYTE_COM1);
	static void stopOutputCompareMatchTimer1 (const unsigned char BYTE_COM1);
	static void modeTimer2();
	static unsigned int frequencyToPrescalerTimer2 (const unsigned int FREQUENCY);
	static void prescalerTimer2 (const unsigned int PRESCALER);
	static void outputCompareTimer2 (const unsigned char VALUE);
	static void startInterruptTimer2();
	static void stopInterruptTimer2();
	static void startInterrupt (const unsigned char INTERRUPT, const bool RISING, const bool FALLING);
	static void stopInterrupt (const unsigned char INTERRUPT);
	static void startPinChangeInterrupt (const unsigned char BYTE_PCIE);
	static void stopPinChangeInterrupt();
	static unsigned char digitToByte (const unsigned char DIGIT, const bool COMMA);
	static unsigned char characterToByte (const char CHARACTER);
	static void startUsart (const bool RECEIVER, const bool TRANSMITTER);
	static signed long readUsart (const signed char LENGTH);
	static void writeUsart (const signed long DATA, const signed char LENGTH);
	static void startSpi (const unsigned char PIN_SS);
	static signed long readSpi (const unsigned char ADDRESS, const signed char LENGTH);
	static signed long readSpiPush (const signed char LENGTH);
	static void writeSpi (const unsigned char ADDRESS, const signed long DATA, const signed char LENGTH);
	static void writeSpiPush (const signed long DATA, const signed char LENGTH);
	static void writeSpiCascaded (const unsigned char PIN_SS, const unsigned char DEVICE, const unsigned char ADDRESS, const signed long DATA, const signed char LENGTH);
	static void startAnalog();
	static unsigned int readAnalog (const unsigned char BYTE_ADMUX);
	static void startTwi();
	static bool scanTwi (const unsigned char DEVICE);
	static signed long readTwi (const unsigned char DEVICE, const unsigned char ADDRESS, const signed char LENGTH);
	static void writeTwi (const unsigned char DEVICE, const unsigned char ADDRESS, const signed long DATA, const signed char LENGTH);
	static unsigned char readEeprom (const unsigned int ADDRESS);
	static void writeEeprom (const unsigned int ADDRESS, const unsigned char DATA);
	static signed long floor (const float VALUE);
	static signed long round (const float VALUE);
	static signed long ceil (const float VALUE);
	static float curve (const float POSITION_START, const float POSITION_CURRENT, const float POSITION_END, const float INTERPOLATION_START, const float INTERPOLATION_END, const unsigned char CURVE);
	static float sqrt (const float SQUARED);
	static float pow (const float NUMBER, const signed long EXPONENT);
	static float sin (const float ANGLE);
	static float cos (const float ANGLE);
	static float tan (const float ANGLE);
	static float arcsin (const float SINUS);
	static float arccos (const float COSINUS);
	static float arctan (const float TANGENT);
	static void power (const bool POWER);
};

const float Core::_DEGREE_TO_RADIAN = 0.0174532925199432;
const float Core::_RADIAN_TO_DEGREE = 57.2957795130823208;
unsigned char Core::_countSpiDevice [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

#include "Core.cpp"
#endif
