#include "../module/328p/Delay.h"
#include "../module/328p/Random.h"
#include "../module/328p/Math.h"
#include "../module/328p/Filter.h"
#include "../module/328p/SoundWrite.h"
#include "../module/328p/PwmWrite.h"
#include "../module/328p/PwmRead.h"
#include "../module/328p/Mpu6050.h"

int main()
{
	unsigned char n = 0;
	Delay delaySoundStartCondition = Delay (1000, false);
	Mpu6050 gyroscope = Mpu6050 (0x68);
	PwmRead channelThrottle = PwmRead (1, true);
	float slowThrottle = 0;
	PwmRead channelPitch = PwmRead (2, true);
	PwmRead channelRoll = PwmRead (3, true);
	PwmRead channelYaw = PwmRead (4, true);
	PwmRead channelCut = PwmRead (5, true);
	float centerCut = 0;
	PwmWrite motor1 = PwmWrite (7);
	PwmWrite motor2 = PwmWrite (8);
	PwmWrite motor3 = PwmWrite (9);
	PwmWrite motor4 = PwmWrite (10);
	float maxEscLimit = 0;
	float mixThrottle = 0;
	float travelPitchRoll = 0;
	float travelPitchRollMinLimit = 0;
	float travelPitchRollMaxLimit = 0;
	float travelYaw = 0;
	float travelYawMinLimit = 0;
	float travelYawMaxLimit = 0;
	float mixThrustPitchGainSpeed = 0;
	Filter mixLockPitchGainSpeed = Filter (20);
	float mixThrustRollGainSpeed = 0;
	Filter mixLockRollGainSpeed = Filter (20);
	float mixInertiaYawGainSpeed = 0;
	Filter mixLockYawGainSpeed = Filter (100);
	float mixMinClearancePitch = 0;
	float mixMaxClearancePitch = 0;
	float mixMinClearanceRoll = 0;
	float mixMaxClearanceRoll = 0;
	float mixMinClearanceYaw = 0;
	float mixMaxClearanceYaw = 0;
	float mixPitchOffsetSpeed = 0;
	float mixRollOffsetSpeed = 0;
	float mixYawOffsetSpeed = 0;
	float thrustGainSpeedPitch = 0;
	float thrustGainSpeedRoll = 0;
	float gainMinRxSpeed = 0;
	float gainMaxRxSpeed = 0;
	float gainLockRxSpeed = 0;
	float gainMinRySpeed = 0;
	float gainMaxRySpeed = 0;
	float gainLockRySpeed = 0;
	float gainRzSpeed = 0;
	float gainLockRzSpeed = 0;
	float mixMinRxMotor = 0;
	float mixMaxRxMotor = 0;
	float mixMinRyMotor = 0;
	float mixMaxRyMotor = 0;
	float mixMinRzMotor = 0;
	float mixMaxRzMotor = 0;
	float mixMotor1 = 0;
	float mixMotor2 = 0;
	float mixMotor3 = 0;
	float mixMotor4 = 0;
	const float SETUP_MIN_CHANNEL_THROTTLE = 1000;
	const float SETUP_MAX_CHANNEL_THROTTLE = 2000;
	const float SETUP_MIN_CHANNEL_PITCH = 1000;
	const float SETUP_MAX_CHANNEL_PITCH = 2000;
	const float SETUP_MIN_CHANNEL_ROLL = 1000;
	const float SETUP_MAX_CHANNEL_ROLL = 2000;
	const float SETUP_MIN_CHANNEL_YAW = 1000;
	const float SETUP_MAX_CHANNEL_YAW = 2000;
	const float SETUP_MIN_CHANNEL_CUT = 1000;
	const float SETUP_MAX_CHANNEL_CUT = 2000;
	const float SETUP_FREQUENCY_ESC = 1000;
	const float SETUP_CUT_ESC = 100;
	const float SETUP_MIN_ESC = 129;
	const float SETUP_MAX_ESC = 248;
	const float SETUP_SPEED_PITCH = 340;
	const float SETUP_SPEED_ROLL = 340;
	const float SETUP_SPEED_YAW = 340;
	const float SETUP_GAIN_PITCH = 97;
	const float SETUP_GAIN_ROLL = 94;
	const float SETUP_GAIN_YAW = 97;
	const float SETUP_TRAVEL_PITCH_ROLL_VS_YAW = 40;
	const float SETUP_THRUST_PROPELLER = 90;
	const float SETUP_LOCK = 60;
	const float SETUP_LIMIT_THROTTLE = 90;
	
	SoundWrite::pin (12);
	
	PwmRead::start (100);
	
	while (channelThrottle.us == 0 || channelPitch.us == 0 || channelRoll.us == 0 || channelYaw.us == 0 || channelCut.us == 0)
	{
		channelThrottle.read();
		channelPitch.read();
		channelRoll.read();
		channelYaw.read();
		channelCut.read();
		
		delaySoundStartCondition.state();
		
		if (delaySoundStartCondition.update == true)
		{
			SoundWrite::key (128, 100);
			SoundWrite::key (0, 100);
			SoundWrite::key (128, 100);
			SoundWrite::playKey();
		}
	}
	
	slowThrottle = Math::curve (0, 10, 100, SETUP_MIN_CHANNEL_THROTTLE, SETUP_MAX_CHANNEL_THROTTLE, 0);
	centerCut = Math::center (SETUP_MIN_CHANNEL_CUT, SETUP_MAX_CHANNEL_CUT);
	
	delaySoundStartCondition.reset();
	
	while (channelThrottle.us > slowThrottle || channelCut.us < centerCut)
	{
		channelThrottle.read();
		channelCut.read();
		
		delaySoundStartCondition.state();
		
		if (delaySoundStartCondition.update == true)
		{
			SoundWrite::key (128, 100);
			SoundWrite::key (0, 100);
			SoundWrite::key (128, 100);
			SoundWrite::key (0, 100);
			SoundWrite::key (128, 100);
			SoundWrite::playKey();
		}
	}
	
	maxEscLimit = Math::curve (0, SETUP_LIMIT_THROTTLE, 100, SETUP_MIN_ESC, SETUP_MAX_ESC, 0);
	
	travelPitchRoll = (SETUP_MAX_ESC - SETUP_MIN_ESC) / (100.0 / (SETUP_TRAVEL_PITCH_ROLL_VS_YAW * (100.0 / ((SETUP_TRAVEL_PITCH_ROLL_VS_YAW * 2.0) + (100.0 - SETUP_TRAVEL_PITCH_ROLL_VS_YAW)))));
	travelPitchRollMinLimit = Math::curve (0, SETUP_LIMIT_THROTTLE, 100, travelPitchRoll, 0, 0);
	travelPitchRollMaxLimit = Math::curve (0, SETUP_LIMIT_THROTTLE, 100, 0, travelPitchRoll, 0);
	
	travelYaw = (SETUP_MAX_ESC - SETUP_MIN_ESC) / (100.0 / ((100.0 - SETUP_TRAVEL_PITCH_ROLL_VS_YAW) * (100.0 / ((SETUP_TRAVEL_PITCH_ROLL_VS_YAW * 2.0) + (100.0 - SETUP_TRAVEL_PITCH_ROLL_VS_YAW)))));
	travelYawMinLimit = Math::curve (0, SETUP_LIMIT_THROTTLE, 100, travelYaw, 0, 0);
	travelYawMaxLimit = Math::curve (0, SETUP_LIMIT_THROTTLE, 100, 0, travelYaw, 0);
	
	thrustGainSpeedPitch = Math::curve (0, SETUP_THRUST_PROPELLER, 100, 0, SETUP_GAIN_PITCH, 0);
	gainMinRxSpeed = Math::curve (0, thrustGainSpeedPitch, 100, 2000, 0, 0);
	gainMaxRxSpeed = Math::curve (0, SETUP_GAIN_PITCH, 100, 2000, 0, 0);
	gainLockRxSpeed = Math::curve (0, SETUP_LOCK, 100, 1, 0, 0);
	
	thrustGainSpeedRoll = Math::curve (0, SETUP_THRUST_PROPELLER, 100, 0, SETUP_GAIN_ROLL, 0);
	gainMinRySpeed = Math::curve (0, thrustGainSpeedRoll, 100, 2000, 0, 0);
	gainMaxRySpeed = Math::curve (0, SETUP_GAIN_ROLL, 100, 2000, 0, 0);
	gainLockRySpeed = Math::curve (0, SETUP_LOCK, 100, 1, 0, 0);
	
	gainRzSpeed = Math::curve (0, SETUP_GAIN_YAW, 100, 2000, 0, 0);
	gainLockRzSpeed = Math::curve (0, SETUP_LOCK, 100, 1, 0, 0);
	
	motor1.us (SETUP_CUT_ESC);
	motor2.us (SETUP_CUT_ESC);
	motor3.us (SETUP_CUT_ESC);
	motor4.us (SETUP_CUT_ESC);
	
	PwmWrite::start (SETUP_FREQUENCY_ESC);
	
	Random::seed (15);
	
	for (n = 0; n < 16; n++)
	{
		if (n != 0)
		{
			SoundWrite::key (0, Random::integer (25, 75));
		}
		
		SoundWrite::key (Random::integer (32, 1536), Random::integer (25, 75));
	}
	
	SoundWrite::playKey();
	
	while (true)
	{
		channelThrottle.read();
		channelPitch.read();
		channelRoll.read();
		channelYaw.read();
		channelCut.read();
		
		if (channelCut.us > centerCut)
		{
			motor1.us (SETUP_CUT_ESC);
			motor2.us (SETUP_CUT_ESC);
			motor3.us (SETUP_CUT_ESC);
			motor4.us (SETUP_CUT_ESC);
		}
		else
		{
			gyroscope.readRotation();
			
			mixThrottle = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, SETUP_MIN_ESC, maxEscLimit, 0);
			
			mixMotor1 = mixThrottle;
			mixMotor2 = mixThrottle;
			mixMotor3 = mixThrottle;
			mixMotor4 = mixThrottle;
			
			mixMinClearancePitch = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, 0, travelPitchRollMaxLimit, 0);
			mixMaxClearancePitch = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, travelPitchRoll, travelPitchRollMinLimit, 0);
			mixPitchOffsetSpeed = Math::curve (SETUP_MIN_CHANNEL_PITCH, channelPitch.us, SETUP_MAX_CHANNEL_PITCH, -SETUP_SPEED_PITCH, SETUP_SPEED_PITCH, 0);
			mixThrustPitchGainSpeed = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, gainMaxRxSpeed, gainMinRxSpeed, 0);
			mixLockPitchGainSpeed.set (Math::wurve (SETUP_MIN_CHANNEL_PITCH, channelPitch.us, SETUP_MAX_CHANNEL_PITCH, gainLockRxSpeed, 1, gainLockRxSpeed, 0, 0));
			mixThrustPitchGainSpeed *= mixLockPitchGainSpeed.value;
			mixMinRxMotor = Math::wurve (-mixThrustPitchGainSpeed, gyroscope.rx + mixPitchOffsetSpeed, mixThrustPitchGainSpeed, -mixMaxClearancePitch, 0, mixMinClearancePitch, 0, 0);
			mixMaxRxMotor = Math::wurve (-mixThrustPitchGainSpeed, gyroscope.rx + mixPitchOffsetSpeed, mixThrustPitchGainSpeed, -mixMinClearancePitch, 0, mixMaxClearancePitch, 0, 0);
			
			mixMotor1 -= mixMinRxMotor;
			mixMotor2 -= mixMinRxMotor;
			mixMotor3 += mixMaxRxMotor;
			mixMotor4 += mixMaxRxMotor;
			
			mixMinClearanceRoll = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, 0, travelPitchRollMaxLimit, 0);
			mixMaxClearanceRoll = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, travelPitchRoll, travelPitchRollMinLimit, 0);
			mixRollOffsetSpeed = Math::curve (SETUP_MIN_CHANNEL_ROLL, channelRoll.us, SETUP_MAX_CHANNEL_ROLL, -SETUP_SPEED_ROLL, SETUP_SPEED_ROLL, 0);
			mixThrustRollGainSpeed = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, gainMaxRySpeed, gainMinRySpeed, 0);
			mixLockRollGainSpeed.set (Math::wurve (SETUP_MIN_CHANNEL_ROLL, channelRoll.us, SETUP_MAX_CHANNEL_ROLL, gainLockRySpeed, 1, gainLockRySpeed, 0, 0));
			mixThrustRollGainSpeed *= mixLockRollGainSpeed.value;
			mixMinRyMotor = Math::wurve (-mixThrustRollGainSpeed, gyroscope.ry - mixRollOffsetSpeed, mixThrustRollGainSpeed, -mixMaxClearanceRoll, 0, mixMinClearanceRoll, 0, 0);
			mixMaxRyMotor = Math::wurve (-mixThrustRollGainSpeed, gyroscope.ry - mixRollOffsetSpeed, mixThrustRollGainSpeed, -mixMinClearanceRoll, 0, mixMaxClearanceRoll, 0, 0);
			
			mixMotor1 -= mixMinRyMotor;
			mixMotor2 += mixMaxRyMotor;
			mixMotor3 -= mixMinRyMotor;
			mixMotor4 += mixMaxRyMotor;
			
			mixMinClearanceYaw = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, 0, travelYawMaxLimit, 0);
			mixMaxClearanceYaw = Math::curve (SETUP_MIN_CHANNEL_THROTTLE, channelThrottle.us, SETUP_MAX_CHANNEL_THROTTLE, travelYaw, travelYawMinLimit, 0);
			mixYawOffsetSpeed = Math::curve (SETUP_MIN_CHANNEL_YAW, channelYaw.us, SETUP_MAX_CHANNEL_YAW, -SETUP_SPEED_YAW, SETUP_SPEED_YAW, 0);
			mixLockYawGainSpeed.set (Math::wurve (SETUP_MIN_CHANNEL_YAW, channelYaw.us, SETUP_MAX_CHANNEL_YAW, gainLockRzSpeed, 1, gainLockRzSpeed, 0, 0));
			mixInertiaYawGainSpeed = gainRzSpeed * mixLockYawGainSpeed.value;
			mixMinRzMotor = Math::wurve (-mixInertiaYawGainSpeed, gyroscope.rz + mixYawOffsetSpeed, mixInertiaYawGainSpeed, -mixMaxClearanceYaw, 0, mixMinClearanceYaw, 0, 0);
			mixMaxRzMotor = Math::wurve (-mixInertiaYawGainSpeed, gyroscope.rz + mixYawOffsetSpeed, mixInertiaYawGainSpeed, -mixMinClearanceYaw, 0, mixMaxClearanceYaw, 0, 0);
			
			mixMotor1 -= mixMinRzMotor;
			mixMotor2 += mixMaxRzMotor;
			mixMotor3 += mixMaxRzMotor;
			mixMotor4 -= mixMinRzMotor;
			
			motor1.us (mixMotor1);
			motor2.us (mixMotor2);
			motor3.us (mixMotor3);
			motor4.us (mixMotor4);
		}
	}
	
	return 0;
}
