@echo off

set device=error

:while
	if not "%device%" == "error"
	(
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m%device% -U signature:r:signature%device%:i
		
		if exist signature%device%
		(
			del /f /q signature%device%
		)
		else
		(
			device=error
		)
	)
	
	if "%device%" == "error"
	(
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m48p -U signature:r:signature48p:i
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m88p -U signature:r:signature88p:i
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m168p -U signature:r:signature168p:i
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m328p -U signature:r:signature328p:i
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m164p -U signature:r:signature164p:i
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m324p -U signature:r:signature324p:i
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m644p -U signature:r:signature644p:i
		avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m1284p -U signature:r:signature1284p:i
		
		if exist signature48p
		(
			device=48p
		)
		else if exist signature88p
		(
			device=88p
		)
		else if exist signature168p
		(
			device=168p
		)
		else if exist signature328p
		(
			device=328p
		)
		else if exist signature164p
		(
			device=164p
		)
		else if exist signature324p
		(
			device=324p
		)
		else if exist signature644p
		(
			device=644p
		)
		else if exist signature1284p
		(
			device=1284p
		)
		else
		(
			device=error
		)
		
		if not "%device%" == "error"
		(
			del /f /q signature%device%
		)
	)
	
	if not "%device%" == "error"
	(
		cls
		
		echo avr-gcc main.cpp -> atmega%device%
		
		avr-gcc main.cpp -mmcu=atmega%device% -Wall -Os -ffunction-sections -fdata-sections -Wl,--gc-sections -std=c++11 -o main.elf
		
		if exist main.elf
		(
			avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m%device% -e
			
			if "%device%" == "48p"
			(
				avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m%device% -U lfuse:w:0xff:m -U hfuse:w:0xdf:m -U efuse:w:0x04:m
			)
			else if "%device%" == "88p"
			(
				avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m%device% -U lfuse:w:0xff:m -U hfuse:w:0xdf:m -U efuse:w:0x04:m
			)
			else if "%device%" == "168p"
			(
				avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m%device% -U lfuse:w:0xff:m -U hfuse:w:0xdf:m -U efuse:w:0x04:m
			)
			else if "%device%" == "328p"
			(
				avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m%device% -U lfuse:w:0xff:m -U hfuse:w:0xdf:m -U efuse:w:0x04:m
			)
			else
			(
				avrdude -q -P /dev/COM1 -c usbasp -B 8 -p m%device% -U lfuse:w:0xff:m -U hfuse:w:0xdf:m -U efuse:w:0xfc:m
			)
			
			objcopy main.elf -O ihex main.hex
			avrdude -P /dev/COM1 -c usbasp -p m%device% -U flash:w:main.hex:i
			avr-size main.elf -dC --mcu atmega%device%
			
			del /f /q main.elf
			del /f /q main.hex
		)
	)
	
	pause
	cls
goto while

exit 0
