Iteration::Iteration (const signed long MIN, const signed long START, const signed long MAX, const bool LOOP)
{
	_min = MIN;
	_start = START;
	value = START;
	_max = MAX;
	_loop = LOOP;
}

void Iteration::increment (const signed long INCREMENT)
{
	if (INCREMENT >= 0)
	{
		if (_loop == false)
		{
			if (value + INCREMENT < _max)
			{
				value += INCREMENT;
			}
			else
			{
				value = _max;
			}
		}
		else
		{
			if (value + INCREMENT < _max)
			{
				value += INCREMENT;
			}
			else if (value + INCREMENT == _max)
			{
				value = _max;
			}
			else
			{
				value = ((value + INCREMENT) - (_max - _min)) - 1l;
			}
		}
	}
	else
	{
		if (_loop == false)
		{
			if (value + INCREMENT > _min)
			{
				value += INCREMENT;
			}
			else
			{
				value = _min;
			}
		}
		else
		{
			if (value + INCREMENT > _min)
			{
				value += INCREMENT;
			}
			else if (value + INCREMENT == _min)
			{
				value = _min;
			}
			else
			{
				value = ((value + INCREMENT) + (_max - _min)) + 1l;
			}
		}
	}
}

void Iteration::min (const signed long MIN)
{
	_min = MIN;
}

void Iteration::set (const signed long VALUE)
{
	value = VALUE;
}

void Iteration::reset()
{
	value = _start;
}

void Iteration::max (const signed long MAX)
{
	_max = MAX;
}

void Iteration::loop (const bool LOOP)
{
	_loop = LOOP;
}
