volatile unsigned char __pwmReadCount = 0;
volatile unsigned char __pwmReadN = 0;
volatile bool __pwmReadCheck [32] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
volatile unsigned char *__pwmReadRegisterPin [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char __pwmReadBytePort [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char *__pwmReadRegisterPcmsk [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char __pwmReadBytePcie [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile bool __pwmReadRising [32] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
volatile bool __pwmReadFirstFront = false;
volatile unsigned long long __pwmReadTimePrevious = 0;
volatile unsigned long __pwmReadUs [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile bool __pwmReadValuePin = false;

_INTERRUPT_JUMP (_PCINT0)
{
	__pwmReadValuePin = *__pwmReadRegisterPin [__pwmReadN] & __pwmReadBytePort [__pwmReadN];
	
	if (((__pwmReadRising [__pwmReadN] == true && __pwmReadValuePin == true) || (__pwmReadRising [__pwmReadN] == false && __pwmReadValuePin == false)) && __pwmReadFirstFront == false)
	{
		__pwmReadTimePrevious = Core::us();
		__pwmReadFirstFront = true;
	}
	else if (((__pwmReadRising [__pwmReadN] == true && __pwmReadValuePin == false) || (__pwmReadRising [__pwmReadN] == false && __pwmReadValuePin == true)) && __pwmReadFirstFront == true)
	{
		Core::stopPinChangeInterrupt();
		*__pwmReadRegisterPcmsk [__pwmReadN] = 0b00000000;
		
		__pwmReadUs [__pwmReadN] = Core::us() - __pwmReadTimePrevious;
		__pwmReadFirstFront = false;
		__pwmReadCheck [__pwmReadN] = true;
		
		if (__pwmReadN < __pwmReadCount - 1)
		{
			__pwmReadN++;
		}
		else
		{
			__pwmReadN = 0;
		}
		
		*__pwmReadRegisterPcmsk [__pwmReadN] = __pwmReadBytePort [__pwmReadN];
		Core::startPinChangeInterrupt (__pwmReadBytePcie [__pwmReadN]);
	}
}

_INTERRUPT_JUMP (_PCINT1)
{
	__pwmReadValuePin = *__pwmReadRegisterPin [__pwmReadN] & __pwmReadBytePort [__pwmReadN];
	
	if (((__pwmReadRising [__pwmReadN] == true && __pwmReadValuePin == true) || (__pwmReadRising [__pwmReadN] == false && __pwmReadValuePin == false)) && __pwmReadFirstFront == false)
	{
		__pwmReadTimePrevious = Core::us();
		__pwmReadFirstFront = true;
	}
	else if (((__pwmReadRising [__pwmReadN] == true && __pwmReadValuePin == false) || (__pwmReadRising [__pwmReadN] == false && __pwmReadValuePin == true)) && __pwmReadFirstFront == true)
	{
		Core::stopPinChangeInterrupt();
		*__pwmReadRegisterPcmsk [__pwmReadN] = 0b00000000;
		
		__pwmReadUs [__pwmReadN] = Core::us() - __pwmReadTimePrevious;
		__pwmReadFirstFront = false;
		__pwmReadCheck [__pwmReadN] = true;
		
		if (__pwmReadN < __pwmReadCount - 1)
		{
			__pwmReadN++;
		}
		else
		{
			__pwmReadN = 0;
		}
		
		*__pwmReadRegisterPcmsk [__pwmReadN] = __pwmReadBytePort [__pwmReadN];
		Core::startPinChangeInterrupt (__pwmReadBytePcie [__pwmReadN]);
	}
}

_INTERRUPT_JUMP (_PCINT2)
{
	__pwmReadValuePin = *__pwmReadRegisterPin [__pwmReadN] & __pwmReadBytePort [__pwmReadN];
	
	if (((__pwmReadRising [__pwmReadN] == true && __pwmReadValuePin == true) || (__pwmReadRising [__pwmReadN] == false && __pwmReadValuePin == false)) && __pwmReadFirstFront == false)
	{
		__pwmReadTimePrevious = Core::us();
		__pwmReadFirstFront = true;
	}
	else if (((__pwmReadRising [__pwmReadN] == true && __pwmReadValuePin == false) || (__pwmReadRising [__pwmReadN] == false && __pwmReadValuePin == true)) && __pwmReadFirstFront == true)
	{
		Core::stopPinChangeInterrupt();
		*__pwmReadRegisterPcmsk [__pwmReadN] = 0b00000000;
		
		__pwmReadUs [__pwmReadN] = Core::us() - __pwmReadTimePrevious;
		__pwmReadFirstFront = false;
		__pwmReadCheck [__pwmReadN] = true;
		
		if (__pwmReadN < __pwmReadCount - 1)
		{
			__pwmReadN++;
		}
		else
		{
			__pwmReadN = 0;
		}
		
		*__pwmReadRegisterPcmsk [__pwmReadN] = __pwmReadBytePort [__pwmReadN];
		Core::startPinChangeInterrupt (__pwmReadBytePcie [__pwmReadN]);
	}
}

_INTERRUPT_JUMP (_PCINT3)
{
	__pwmReadValuePin = *__pwmReadRegisterPin [__pwmReadN] & __pwmReadBytePort [__pwmReadN];
	
	if (((__pwmReadRising [__pwmReadN] == true && __pwmReadValuePin == true) || (__pwmReadRising [__pwmReadN] == false && __pwmReadValuePin == false)) && __pwmReadFirstFront == false)
	{
		__pwmReadTimePrevious = Core::us();
		__pwmReadFirstFront = true;
	}
	else if (((__pwmReadRising [__pwmReadN] == true && __pwmReadValuePin == false) || (__pwmReadRising [__pwmReadN] == false && __pwmReadValuePin == true)) && __pwmReadFirstFront == true)
	{
		Core::stopPinChangeInterrupt();
		*__pwmReadRegisterPcmsk [__pwmReadN] = 0b00000000;
		
		__pwmReadUs [__pwmReadN] = Core::us() - __pwmReadTimePrevious;
		__pwmReadFirstFront = false;
		__pwmReadCheck [__pwmReadN] = true;
		
		if (__pwmReadN < __pwmReadCount - 1)
		{
			__pwmReadN++;
		}
		else
		{
			__pwmReadN = 0;
		}
		
		*__pwmReadRegisterPcmsk [__pwmReadN] = __pwmReadBytePort [__pwmReadN];
		Core::startPinChangeInterrupt (__pwmReadBytePcie [__pwmReadN]);
	}
}

PwmRead::PwmRead (const unsigned char PIN, const bool RISING)
{
	__pwmReadRegisterPin [__pwmReadCount] = Core::pinToRegisterPin (PIN);
	__pwmReadBytePort [__pwmReadCount] = Core::pinToBytePort (PIN);
	__pwmReadRegisterPcmsk [__pwmReadCount] = Core::pinToRegisterPcmsk (PIN);
	__pwmReadBytePcie [__pwmReadCount] = Core::pinToBytePcie (PIN);
	__pwmReadRising [__pwmReadCount] = RISING;
	
	_nChannel = __pwmReadCount;
	
	__pwmReadCount++;
}

void PwmRead::start (const unsigned int TIME_OUT)
{
	_timeOut = TIME_OUT;
	
	Core::startGlobalInterrupt();
	Core::startInterruptTimer0();
	
	*__pwmReadRegisterPcmsk [0] = __pwmReadBytePort [0];
	Core::startPinChangeInterrupt (__pwmReadBytePcie [0]);
}

void PwmRead::read()
{
	if (__pwmReadN == _nChannel && _timeOut != 0)
	{
		if (__pwmReadCheck [_nChannel] == false)
		{
			if (_firstRead == true && Core::ms() >= _timePrevious)
			{
				Core::stopPinChangeInterrupt();
				*__pwmReadRegisterPcmsk [__pwmReadN] = 0b00000000;
				
				if (__pwmReadN < __pwmReadCount - 1)
				{
					__pwmReadN++;
				}
				else
				{
					__pwmReadN = 0;
				}
				
				__pwmReadFirstFront = false;
				
				*__pwmReadRegisterPcmsk [__pwmReadN] = __pwmReadBytePort [__pwmReadN];
				Core::startPinChangeInterrupt (__pwmReadBytePcie [__pwmReadN]);
				
				_firstRead = false;
			}
			else if (_firstRead == false)
			{
				_timePrevious = Core::ms() + (unsigned long long)(_timeOut);
				_firstRead = true;
			}
		}
		else
		{
			__pwmReadCheck [_nChannel] = false;
			_firstRead = false;
		}
	}
	
	us = __pwmReadUs [_nChannel];
}
