Timer::Timer()
{
	Core::startGlobalInterrupt();
	Core::startInterruptTimer0();
}

void Timer::start (const unsigned long long TIME_START)
{
	_timeStart = (Core::ms() * 1000ull) - (TIME_START * 1000ull);
	_stop = false;
}

void Timer::state()
{
	const unsigned long long US = Core::us() - _timeStart;
	
	if (_stop == false)
	{
		s = US / 1000000;
		ms = US / 1000;
		us = US;
	}
}

void Timer::stop()
{
	_stop = true;
}

void Timer::pause (const unsigned long long DURATION)
{
	const unsigned long long TIME_PREVIOUS = Core::ms();
	
	Core::startGlobalInterrupt();
	Core::startInterruptTimer0();
	
	while (Core::ms() < TIME_PREVIOUS + DURATION)
	{
	}
}
