#include "../module/644p/AnalogRead.h"
#include "../module/644p/PwmWrite.h"
#include "../module/644p/SoundWrite.h"
#include "../module/644p/Timer.h"
#include "../module/644p/Delay.h"
#include "../module/644p/Math.h"
#include "../module/644p/Filter.h"
#include "../module/644p/Random.h"
#include "../module/644p/Mpu6050.h"
#include "../module/644p/Nrf24l01p.h"
#include "../module/644p/Memory.h"
#include "../module/644p/Tool.h"

int main()
{
	unsigned char n = 0;
	AnalogRead voltageBatteryModel = AnalogRead (31);
	unsigned long telemetryAuxiliary = 0;
	Nrf24l01p channelThrottleRollAuxiliaryCAuxiliaryD = Nrf24l01p (1);
	Nrf24l01p channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate = Nrf24l01p (2);
	Nrf24l01p channelTelemetry = Nrf24l01p (3);
	Nrf24l01p channelSettingBatteryTimer = Nrf24l01p (4);
	Nrf24l01p channelSettingTrim = Nrf24l01p (5);
	Nrf24l01p channelSettingStick = Nrf24l01p (6);
	Nrf24l01p channelSettingOptionWord1 = Nrf24l01p (7);
	Nrf24l01p channelSettingOption1 = Nrf24l01p (8);
	Nrf24l01p channelSettingOptionWord2 = Nrf24l01p (9);
	Nrf24l01p channelSettingOption2 = Nrf24l01p (10);
	Nrf24l01p channelSettingOptionWord3 = Nrf24l01p (11);
	Nrf24l01p channelSettingOption3 = Nrf24l01p (12);
	Nrf24l01p channelSettingOptionWord4 = Nrf24l01p (13);
	Nrf24l01p channelSettingOption4 = Nrf24l01p (14);
	Nrf24l01p channelSettingOptionWord5 = Nrf24l01p (15);
	Nrf24l01p channelSettingOption5 = Nrf24l01p (16);
	Nrf24l01p channelSettingOptionWord6 = Nrf24l01p (17);
	Nrf24l01p channelSettingOption6 = Nrf24l01p (18);
	Nrf24l01p channelSettingOptionWord7 = Nrf24l01p (19);
	Nrf24l01p channelSettingOption7 = Nrf24l01p (20);
	Nrf24l01p channelSettingOptionWord8 = Nrf24l01p (21);
	Nrf24l01p channelSettingOption8 = Nrf24l01p (22);
	Nrf24l01p channelSettingOptionWord9 = Nrf24l01p (23);
	Nrf24l01p channelSettingOption9 = Nrf24l01p (24);
	Nrf24l01p channelSettingOptionWord10 = Nrf24l01p (25);
	Nrf24l01p channelSettingOption10 = Nrf24l01p (26);
	Nrf24l01p channelSettingOptionWord11 = Nrf24l01p (27);
	Nrf24l01p channelSettingOption11 = Nrf24l01p (28);
	Nrf24l01p channelSettingOptionWord12 = Nrf24l01p (29);
	Nrf24l01p channelSettingOption12 = Nrf24l01p (30);
	Nrf24l01p channelSettingOptionWord13 = Nrf24l01p (31);
	Nrf24l01p channelSettingOption13 = Nrf24l01p (32);
	Nrf24l01p channelSettingOptionWord14 = Nrf24l01p (33);
	Nrf24l01p channelSettingOption14 = Nrf24l01p (34);
	Nrf24l01p channelSettingOptionWord15 = Nrf24l01p (35);
	Nrf24l01p channelSettingOption15 = Nrf24l01p (36);
	Nrf24l01p channelSettingOptionWord16 = Nrf24l01p (37);
	Nrf24l01p channelSettingOption16 = Nrf24l01p (38);
	Delay delaySoundStartCondition = Delay (1000, false);
	unsigned int throttle = 0;
	float centerMinThrottle = 0;
	float centerMaxThrottle = 0;
	bool invert = false;
	unsigned int pitch = 0;
	unsigned int roll = 0;
	unsigned int yaw = 0;
	bool cut = false;
	unsigned char auxiliaryA = 0;
	unsigned char auxiliaryB = 0;
	unsigned char auxiliaryC = 0;
	unsigned int auxiliaryD = 0;
	unsigned char failSafeData = 0;
	bool failSafe = false;
	unsigned char failSafePrevious = 0;
	Timer timeFailSafe = Timer();
	unsigned long long timeFailSafePrevious = 0;
	bool resetThrottleCut = false;
	bool update = 0;
	bool updated = 0;
	Timer timeSound = Timer();
	unsigned long long timeSoundPrevious = 0;
	unsigned char durationKeySound = 0;
	const unsigned char TIME_SPACE_SOUND = 10;
	bool soundRandom = false;
	Mpu6050 gyroscope = Mpu6050 (0x68);
	PwmWrite motor1 = PwmWrite (9);
	PwmWrite motor2 = PwmWrite (10);
	PwmWrite motor3 = PwmWrite (11);
	PwmWrite motor4 = PwmWrite (12);
	float maxEscLimitNormal = 0;
	float maxEscLimitInvert = 0;
	float mixThrottle = 0;
	float travelPitchRollNormal = 0;
	float travelPitchRollMinLimitNormal = 0;
	float travelPitchRollMaxLimitNormal = 0;
	float travelYawNormal = 0;
	float travelYawMinLimitNormal = 0;
	float travelYawMaxLimitNormal = 0;
	float travelPitchRollInvert = 0;
	float travelPitchRollMinLimitInvert = 0;
	float travelPitchRollMaxLimitInvert = 0;
	float travelYawInvert = 0;
	float travelYawMinLimitInvert = 0;
	float travelYawMaxLimitInvert = 0;
	float mixThrustPitchGainSpeed = 0;
	Filter mixLockPitchGainSpeed = Filter (20);
	float mixThrustRollGainSpeed = 0;
	Filter mixLockRollGainSpeed = Filter (20);
	float mixInertiaYawGainSpeed = 0;
	Filter mixLockYawGainSpeed = Filter (100);
	float mixMinClearancePitch = 0;
	float mixMaxClearancePitch = 0;
	float mixMinClearanceRoll = 0;
	float mixMaxClearanceRoll = 0;
	float mixMinClearanceYaw = 0;
	float mixMaxClearanceYaw = 0;
	float mixPitchOffsetSpeed = 0;
	float mixRollOffsetSpeed = 0;
	float mixYawOffsetSpeed = 0;
	float thrustGainSpeedPitch = 0;
	float thrustGainSpeedRoll = 0;
	float gainMinRxSpeed = 0;
	float gainMaxRxSpeed = 0;
	float gainLockRxSpeed = 0;
	float gainMinRySpeed = 0;
	float gainMaxRySpeed = 0;
	float gainLockRySpeed = 0;
	float gainRzSpeed = 0;
	float gainLockRzSpeed = 0;
	float mixMinRxMotor = 0;
	float mixMaxRxMotor = 0;
	float mixMinRyMotor = 0;
	float mixMaxRyMotor = 0;
	float mixMinRzMotor = 0;
	float mixMaxRzMotor = 0;
	float mixMotor1 = 0;
	float mixMotor2 = 0;
	float mixMotor3 = 0;
	float mixMotor4 = 0;
	float settingFrequencyEsc = 0;
	float settingCutEsc = 0;
	float settingMinEscNormal = 0;
	float settingMaxEscNormal = 0;
	float settingMinEscInvert = 0;
	float settingMaxEscInvert = 0;
	float settingSpeedPitch = 0;
	float settingSpeedRoll = 0;
	float settingSpeedYaw = 0;
	float settingGainPitch = 0;
	float settingGainRoll = 0;
	float settingGainYaw = 0;
	float settingTravelPitchRollVsYaw = 0;
	float settingThrustPropeller = 0;
	float settingLock = 0;
	float settingLimitThrottle = 0;
	unsigned long settingBatteryTimer = 0;
	unsigned long settingTrim = 0;
	unsigned long settingStick = 0;
	unsigned int settingOption [16] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
	const unsigned long SETUP_ID = 1524003746;
	const char *SETUP_SETTING_OPTION_WORD [16] = {"fres", "cues", "mien", "maen", "miei", "maei", "sppi", "spro", "spya", "gapi", "garo", "gaya", "trav", "prop", "lock", "limi"};
	const unsigned int SETUP_SETTING_OPTION_MIN [16] = {50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
	const unsigned int SETUP_SETTING_OPTION_MAX [16] = {1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 100, 100, 100, 100, 100, 100, 100};
	const bool SETUP_SETTING_OPTION_CENTER [16] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
	const bool SETUP_SETTING_OPTION_DECIMAL [16] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
	
	if (Memory::read (1, 8) == 255)
	{
		Memory::write (1, 0, 8);
		Memory::write (2, 0, 32);
		Memory::write (6, 0b01111111011111110111111101111111, 32);
		Memory::write (10, 0, 32);
		
		for (n = 0; n < 16; n++)
		{
			if (SETUP_SETTING_OPTION_CENTER [n] == false)
			{
				Memory::write (14 + (n * 2), SETUP_SETTING_OPTION_MIN [n], 16);
			}
			else
			{
				Memory::write (14 + (n * 2), Math::round (Math::center (SETUP_SETTING_OPTION_MIN [n], SETUP_SETTING_OPTION_MAX [n])), 16);
			}
		}
	}
	
	settingBatteryTimer = Memory::read (2, 32);
	settingTrim = Memory::read (6, 32);
	settingStick = Memory::read (10, 32);
	
	for (n = 0; n < 16; n++)
	{
		settingOption [n] = Memory::read (14 + (n * 2), 16);
	}
	
	SoundWrite::pin (25);
	
	Nrf24l01p::start (5, 32, SETUP_ID, false);
	
	while (channelThrottleRollAuxiliaryCAuxiliaryD.received == false || channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate.received == false)
	{
		delaySoundStartCondition.state();
		
		voltageBatteryModel.read();
		
		channelThrottleRollAuxiliaryCAuxiliaryD.receive();
		channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate.receive();
		
		channelTelemetry.transmit ((signed long)(updated) << 31 | (signed long)(telemetryAuxiliary) << 10 | (signed long)(voltageBatteryModel.value));
		
		channelSettingBatteryTimer.transmit (settingBatteryTimer);
		channelSettingTrim.transmit (settingTrim);
		channelSettingStick.transmit (settingStick);
		channelSettingOptionWord1.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [0][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [0][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [0][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [0][0])));
		channelSettingOption1.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [0]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [0]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [0]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [0]) << 10 | (signed long)(settingOption [0]));
		channelSettingOptionWord2.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [1][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [1][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [1][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [1][0])));
		channelSettingOption2.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [1]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [1]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [1]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [1]) << 10 | (signed long)(settingOption [1]));
		channelSettingOptionWord3.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [2][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [2][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [2][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [2][0])));
		channelSettingOption3.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [2]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [2]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [2]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [2]) << 10 | (signed long)(settingOption [2]));
		channelSettingOptionWord4.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [3][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [3][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [3][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [3][0])));
		channelSettingOption4.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [3]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [3]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [3]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [3]) << 10 | (signed long)(settingOption [3]));
		channelSettingOptionWord5.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [4][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [4][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [4][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [4][0])));
		channelSettingOption5.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [4]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [4]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [4]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [4]) << 10 | (signed long)(settingOption [4]));
		channelSettingOptionWord6.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [5][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [5][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [5][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [5][0])));
		channelSettingOption6.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [5]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [5]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [5]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [5]) << 10 | (signed long)(settingOption [5]));
		channelSettingOptionWord7.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [6][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [6][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [6][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [6][0])));
		channelSettingOption7.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [6]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [6]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [6]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [6]) << 10 | (signed long)(settingOption [6]));
		channelSettingOptionWord8.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [7][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [7][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [7][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [7][0])));
		channelSettingOption8.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [7]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [7]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [7]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [7]) << 10 | (signed long)(settingOption [7]));
		channelSettingOptionWord9.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [8][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [8][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [8][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [8][0])));
		channelSettingOption9.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [8]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [8]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [8]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [8]) << 10 | (signed long)(settingOption [8]));
		channelSettingOptionWord10.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [9][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [9][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [9][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [9][0])));
		channelSettingOption10.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [9]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [9]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [9]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [9]) << 10 | (signed long)(settingOption [9]));
		channelSettingOptionWord11.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [10][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [10][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [10][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [10][0])));
		channelSettingOption11.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [10]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [10]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [10]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [10]) << 10 | (signed long)(settingOption [10]));
		channelSettingOptionWord12.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [11][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [11][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [11][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [11][0])));
		channelSettingOption12.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [11]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [11]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [11]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [11]) << 10 | (signed long)(settingOption [11]));
		channelSettingOptionWord13.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [12][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [12][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [12][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [12][0])));
		channelSettingOption13.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [12]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [12]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [12]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [12]) << 10 | (signed long)(settingOption [12]));
		channelSettingOptionWord14.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [13][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [13][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [13][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [13][0])));
		channelSettingOption14.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [13]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [13]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [13]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [13]) << 10 | (signed long)(settingOption [13]));
		channelSettingOptionWord15.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [14][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [14][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [14][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [14][0])));
		channelSettingOption15.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [14]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [14]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [14]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [14]) << 10 | (signed long)(settingOption [14]));
		channelSettingOptionWord16.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [15][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [15][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [15][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [15][0])));
		channelSettingOption16.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [15]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [15]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [15]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [15]) << 10 | (signed long)(settingOption [15]));
		
		if (delaySoundStartCondition.update == true)
		{
			SoundWrite::key (128, 100);
			SoundWrite::key (0, 100);
			SoundWrite::key (128, 100);
			SoundWrite::playKey();
		}
	}
	
	centerMinThrottle = Math::curve (0, 45, 100, 0, 1023, 0);
	centerMaxThrottle = Math::curve (0, 55, 100, 0, 1023, 0);
	
	timeFailSafe.start (0);
	timeSound.start (0);
	
	delaySoundStartCondition.reset();
	
	channelThrottleRollAuxiliaryCAuxiliaryD.reset();
	
	Random::seed (32);
	
	while (throttle < centerMinThrottle || throttle > centerMaxThrottle || cut == false || channelThrottleRollAuxiliaryCAuxiliaryD.received == false)
	{
		timeFailSafe.state();
		timeSound.state();
		
		delaySoundStartCondition.state();
		
		voltageBatteryModel.read();
		
		if (failSafe == true)
		{
			if (resetThrottleCut == false)
			{
				channelThrottleRollAuxiliaryCAuxiliaryD.reset();
			}
			
			resetThrottleCut = true;
		}
		else
		{
			channelThrottleRollAuxiliaryCAuxiliaryD.receive();
			resetThrottleCut = false;
		}
		
		channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate.receive();
		
		channelTelemetry.transmit ((signed long)(updated) << 31 | (signed long)(telemetryAuxiliary) << 10 | (signed long)(voltageBatteryModel.value));
		
		throttle = channelThrottleRollAuxiliaryCAuxiliaryD.data & 0b00000000000000000000001111111111;
		cut = (channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate.data & 0b00000000000100000000000000000000) >> 20;
		
		failSafeData = (channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate.data & 0b01111110000000000000000000000000) >> 25;
		
		if (failSafeData != failSafePrevious)
		{
			failSafePrevious = failSafeData;
			timeFailSafePrevious = timeFailSafe.ms;
			
			failSafe = false;
		}
		else if (timeFailSafe.ms >= timeFailSafePrevious + 1000ull)
		{
			failSafe = true;
		}
		
		update = (channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate.data & 0b10000000000000000000000000000000) >> 31;
		
		if (update == true && failSafe == false)
		{
			if (updated == false)
			{
				channelSettingBatteryTimer.receive();
				channelSettingTrim.receive();
				channelSettingStick.receive();
				channelSettingOption1.receive();
				channelSettingOption2.receive();
				channelSettingOption3.receive();
				channelSettingOption4.receive();
				channelSettingOption5.receive();
				channelSettingOption6.receive();
				channelSettingOption7.receive();
				channelSettingOption8.receive();
				channelSettingOption9.receive();
				channelSettingOption10.receive();
				channelSettingOption11.receive();
				channelSettingOption12.receive();
				channelSettingOption13.receive();
				channelSettingOption14.receive();
				channelSettingOption15.receive();
				channelSettingOption16.receive();
				
				if (channelSettingBatteryTimer.received == true && channelSettingTrim.received == true && channelSettingStick.received == true && channelSettingOption1.received == true && channelSettingOption2.received == true && channelSettingOption3.received == true && channelSettingOption4.received == true && channelSettingOption5.received == true && channelSettingOption6.received == true && channelSettingOption7.received == true && channelSettingOption8.received == true && channelSettingOption9.received == true && channelSettingOption10.received == true && channelSettingOption11.received == true && channelSettingOption12.received == true && channelSettingOption13.received == true && channelSettingOption14.received == true && channelSettingOption15.received == true && channelSettingOption16.received == true)
				{
					settingBatteryTimer = channelSettingBatteryTimer.data;
					settingTrim = channelSettingTrim.data;
					settingStick = channelSettingStick.data;
					settingOption [0] = channelSettingOption1.data & 0b00000000000000000000001111111111;
					settingOption [1] = channelSettingOption2.data & 0b00000000000000000000001111111111;
					settingOption [2] = channelSettingOption3.data & 0b00000000000000000000001111111111;
					settingOption [3] = channelSettingOption4.data & 0b00000000000000000000001111111111;
					settingOption [4] = channelSettingOption5.data & 0b00000000000000000000001111111111;
					settingOption [5] = channelSettingOption6.data & 0b00000000000000000000001111111111;
					settingOption [6] = channelSettingOption7.data & 0b00000000000000000000001111111111;
					settingOption [7] = channelSettingOption8.data & 0b00000000000000000000001111111111;
					settingOption [8] = channelSettingOption9.data & 0b00000000000000000000001111111111;
					settingOption [9] = channelSettingOption10.data & 0b00000000000000000000001111111111;
					settingOption [10] = channelSettingOption11.data & 0b00000000000000000000001111111111;
					settingOption [11] = channelSettingOption12.data & 0b00000000000000000000001111111111;
					settingOption [12] = channelSettingOption13.data & 0b00000000000000000000001111111111;
					settingOption [13] = channelSettingOption14.data & 0b00000000000000000000001111111111;
					settingOption [14] = channelSettingOption15.data & 0b00000000000000000000001111111111;
					settingOption [15] = channelSettingOption16.data & 0b00000000000000000000001111111111;
					
					Memory::write (2, settingBatteryTimer, 32);
					Memory::write (6, settingTrim, 32);
					Memory::write (10, settingStick, 32);
					
					for (n = 0; n < 16; n++)
					{
						Memory::write (14 + (n * 2), settingOption [n], 16);
					}
					
					channelSettingBatteryTimer.reset();
					channelSettingTrim.reset();
					channelSettingStick.reset();
					channelSettingOption1.reset();
					channelSettingOption2.reset();
					channelSettingOption3.reset();
					channelSettingOption4.reset();
					channelSettingOption5.reset();
					channelSettingOption6.reset();
					channelSettingOption7.reset();
					channelSettingOption8.reset();
					channelSettingOption9.reset();
					channelSettingOption10.reset();
					channelSettingOption11.reset();
					channelSettingOption12.reset();
					channelSettingOption13.reset();
					channelSettingOption14.reset();
					channelSettingOption15.reset();
					channelSettingOption16.reset();
					
					updated = true;
					
					soundRandom = true;
				}
			}
		}
		else
		{
			channelSettingBatteryTimer.transmit (settingBatteryTimer);
			channelSettingTrim.transmit (settingTrim);
			channelSettingStick.transmit (settingStick);
			channelSettingOptionWord1.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [0][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [0][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [0][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [0][0])));
			channelSettingOption1.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [0]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [0]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [0]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [0]) << 10 | (signed long)(settingOption [0]));
			channelSettingOptionWord2.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [1][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [1][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [1][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [1][0])));
			channelSettingOption2.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [1]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [1]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [1]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [1]) << 10 | (signed long)(settingOption [1]));
			channelSettingOptionWord3.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [2][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [2][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [2][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [2][0])));
			channelSettingOption3.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [2]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [2]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [2]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [2]) << 10 | (signed long)(settingOption [2]));
			channelSettingOptionWord4.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [3][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [3][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [3][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [3][0])));
			channelSettingOption4.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [3]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [3]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [3]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [3]) << 10 | (signed long)(settingOption [3]));
			channelSettingOptionWord5.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [4][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [4][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [4][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [4][0])));
			channelSettingOption5.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [4]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [4]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [4]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [4]) << 10 | (signed long)(settingOption [4]));
			channelSettingOptionWord6.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [5][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [5][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [5][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [5][0])));
			channelSettingOption6.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [5]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [5]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [5]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [5]) << 10 | (signed long)(settingOption [5]));
			channelSettingOptionWord7.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [6][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [6][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [6][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [6][0])));
			channelSettingOption7.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [6]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [6]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [6]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [6]) << 10 | (signed long)(settingOption [6]));
			channelSettingOptionWord8.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [7][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [7][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [7][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [7][0])));
			channelSettingOption8.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [7]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [7]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [7]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [7]) << 10 | (signed long)(settingOption [7]));
			channelSettingOptionWord9.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [8][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [8][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [8][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [8][0])));
			channelSettingOption9.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [8]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [8]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [8]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [8]) << 10 | (signed long)(settingOption [8]));
			channelSettingOptionWord10.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [9][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [9][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [9][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [9][0])));
			channelSettingOption10.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [9]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [9]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [9]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [9]) << 10 | (signed long)(settingOption [9]));
			channelSettingOptionWord11.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [10][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [10][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [10][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [10][0])));
			channelSettingOption11.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [10]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [10]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [10]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [10]) << 10 | (signed long)(settingOption [10]));
			channelSettingOptionWord12.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [11][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [11][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [11][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [11][0])));
			channelSettingOption12.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [11]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [11]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [11]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [11]) << 10 | (signed long)(settingOption [11]));
			channelSettingOptionWord13.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [12][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [12][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [12][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [12][0])));
			channelSettingOption13.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [12]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [12]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [12]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [12]) << 10 | (signed long)(settingOption [12]));
			channelSettingOptionWord14.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [13][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [13][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [13][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [13][0])));
			channelSettingOption14.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [13]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [13]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [13]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [13]) << 10 | (signed long)(settingOption [13]));
			channelSettingOptionWord15.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [14][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [14][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [14][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [14][0])));
			channelSettingOption15.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [14]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [14]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [14]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [14]) << 10 | (signed long)(settingOption [14]));
			channelSettingOptionWord16.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [15][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [15][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [15][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [15][0])));
			channelSettingOption16.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [15]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [15]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [15]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [15]) << 10 | (signed long)(settingOption [15]));
			
			channelSettingBatteryTimer.reset();
			channelSettingTrim.reset();
			channelSettingStick.reset();
			channelSettingOption1.reset();
			channelSettingOption2.reset();
			channelSettingOption3.reset();
			channelSettingOption4.reset();
			channelSettingOption5.reset();
			channelSettingOption6.reset();
			channelSettingOption7.reset();
			channelSettingOption8.reset();
			channelSettingOption9.reset();
			channelSettingOption10.reset();
			channelSettingOption11.reset();
			channelSettingOption12.reset();
			channelSettingOption13.reset();
			channelSettingOption14.reset();
			channelSettingOption15.reset();
			channelSettingOption16.reset();
			
			updated = false;
		}
		
		if (soundRandom == true)
		{
			timeSoundPrevious = 0;
			
			for (n = 0; n < 8; n++)
			{
				if (n != 0)
				{
					durationKeySound = Random::integer (25, 75);
					
					SoundWrite::key (0, durationKeySound);
					
					timeSoundPrevious += durationKeySound;
				}
				
				durationKeySound = Random::integer (25, 75);
				
				SoundWrite::key (Random::integer (32, 1536), durationKeySound);
				
				timeSoundPrevious += durationKeySound;
			}
			
			SoundWrite::playKey();
			
			timeSoundPrevious += timeSound.ms + (unsigned long long)(TIME_SPACE_SOUND);
		}
		else if (delaySoundStartCondition.update == true && timeSound.ms > timeSoundPrevious)
		{
			if (failSafe == false && channelThrottleRollAuxiliaryCAuxiliaryD.received == true)
			{
				SoundWrite::key (128, 100);
				SoundWrite::key (0, 100);
				SoundWrite::key (128, 100);
				SoundWrite::key (0, 100);
				SoundWrite::key (128, 100);
				SoundWrite::playKey();
			}
			else
			{
				SoundWrite::key (128, 100);
				SoundWrite::key (0, 100);
				SoundWrite::key (128, 100);
				SoundWrite::playKey();
			}
		}
		
		soundRandom = false;
	}
	
	channelSettingBatteryTimer.reset();
	channelSettingTrim.reset();
	channelSettingStick.reset();
	channelSettingOption1.reset();
	channelSettingOption2.reset();
	channelSettingOption3.reset();
	channelSettingOption4.reset();
	channelSettingOption5.reset();
	channelSettingOption6.reset();
	channelSettingOption7.reset();
	channelSettingOption8.reset();
	channelSettingOption9.reset();
	channelSettingOption10.reset();
	channelSettingOption11.reset();
	channelSettingOption12.reset();
	channelSettingOption13.reset();
	channelSettingOption14.reset();
	channelSettingOption15.reset();
	channelSettingOption16.reset();
	
	settingFrequencyEsc = settingOption [0];
	settingCutEsc = settingOption [1];
	settingMinEscNormal = settingOption [2];
	settingMaxEscNormal = settingOption [3];
	settingMinEscInvert = settingOption [4];
	settingMaxEscInvert = settingOption [5];
	settingSpeedPitch = settingOption [6];
	settingSpeedRoll = settingOption [7];
	settingSpeedYaw = settingOption [8];
	settingGainPitch = settingOption [9];
	settingGainRoll = settingOption [10];
	settingGainYaw = settingOption [11];
	settingTravelPitchRollVsYaw = settingOption [12];
	settingThrustPropeller = settingOption [13];
	settingLock = settingOption [14];
	settingLimitThrottle = settingOption [15];
	
	maxEscLimitNormal = Math::curve (0, settingLimitThrottle, 100, settingMinEscNormal, settingMaxEscNormal, 0);
	maxEscLimitInvert = Math::curve (0, settingLimitThrottle, 100, settingMinEscInvert, settingMaxEscInvert, 0);
	
	travelPitchRollNormal = (settingMaxEscNormal - settingMinEscNormal) / (100.0 / (settingTravelPitchRollVsYaw * (100.0 / ((settingTravelPitchRollVsYaw * 2.0) + (100.0 - settingTravelPitchRollVsYaw)))));
	travelPitchRollMinLimitNormal = Math::curve (0, settingLimitThrottle, 100, travelPitchRollNormal, 0, 0);
	travelPitchRollMaxLimitNormal = Math::curve (0, settingLimitThrottle, 100, 0, travelPitchRollNormal, 0);
	
	travelYawNormal = (settingMaxEscNormal - settingMinEscNormal) / (100.0 / ((100.0 - settingTravelPitchRollVsYaw) * (100.0 / ((settingTravelPitchRollVsYaw * 2.0) + (100.0 - settingTravelPitchRollVsYaw)))));
	travelYawMinLimitNormal = Math::curve (0, settingLimitThrottle, 100, travelYawNormal, 0, 0);
	travelYawMaxLimitNormal = Math::curve (0, settingLimitThrottle, 100, 0, travelYawNormal, 0);
	
	travelPitchRollInvert = (settingMinEscInvert - settingMaxEscInvert) / (100.0 / (settingTravelPitchRollVsYaw * (100.0 / ((settingTravelPitchRollVsYaw * 2.0) + (100.0 - settingTravelPitchRollVsYaw)))));
	travelPitchRollMinLimitInvert = Math::curve (0, settingLimitThrottle, 100, travelPitchRollInvert, 0, 0);
	travelPitchRollMaxLimitInvert = Math::curve (0, settingLimitThrottle, 100, 0, travelPitchRollInvert, 0);
	
	travelYawInvert = (settingMinEscInvert - settingMaxEscInvert) / (100.0 / ((100.0 - settingTravelPitchRollVsYaw) * (100.0 / ((settingTravelPitchRollVsYaw * 2.0) + (100.0 - settingTravelPitchRollVsYaw)))));
	travelYawMinLimitInvert = Math::curve (0, settingLimitThrottle, 100, travelYawInvert, 0, 0);
	travelYawMaxLimitInvert = Math::curve (0, settingLimitThrottle, 100, 0, travelYawInvert, 0);
	
	thrustGainSpeedPitch = Math::curve (0, settingThrustPropeller, 100, 0, settingGainPitch, 0);
	gainMinRxSpeed = Math::curve (0, thrustGainSpeedPitch, 100, 2000, 0, 0);
	gainMaxRxSpeed = Math::curve (0, settingGainPitch, 100, 2000, 0, 0);
	gainLockRxSpeed = Math::curve (0, settingLock, 100, 1, 0, 0);
	
	thrustGainSpeedRoll = Math::curve (0, settingThrustPropeller, 100, 0, settingGainRoll, 0);
	gainMinRySpeed = Math::curve (0, thrustGainSpeedRoll, 100, 2000, 0, 0);
	gainMaxRySpeed = Math::curve (0, settingGainRoll, 100, 2000, 0, 0);
	gainLockRySpeed = Math::curve (0, settingLock, 100, 1, 0, 0);
	
	gainRzSpeed = Math::curve (0, settingGainYaw, 100, 2000, 0, 0);
	gainLockRzSpeed = Math::curve (0, settingLock, 100, 1, 0, 0);
	
	motor1.us (settingCutEsc);
	motor2.us (settingCutEsc);
	motor3.us (settingCutEsc);
	motor4.us (settingCutEsc);
	
	PwmWrite::start (settingFrequencyEsc);
	
	delaySoundStartCondition.reset();
	
	for (n = 0; n < 16; n++)
	{
		if (n != 0)
		{
			SoundWrite::key (0, Random::integer (25, 75));
		}
		
		SoundWrite::key (Random::integer (32, 1536), Random::integer (25, 75));
	}
	
	SoundWrite::playKey();
	
	while (true)
	{
		timeFailSafe.state();
		timeSound.state();
		
		voltageBatteryModel.read();
		
		channelThrottleRollAuxiliaryCAuxiliaryD.receive();
		channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate.receive();
		
		channelTelemetry.transmit ((signed long)(updated) << 31 | (signed long)(telemetryAuxiliary) << 10 | (signed long)(voltageBatteryModel.value));
		
		throttle = channelThrottleRollAuxiliaryCAuxiliaryD.data & 0b00000000000000000000001111111111;
		pitch = channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate.data & 0b00000000000000000000001111111111;
		roll = (channelThrottleRollAuxiliaryCAuxiliaryD.data & 0b00000000000011111111110000000000) >> 10;
		yaw = (channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate.data & 0b00000000000011111111110000000000) >> 10;
		cut = (channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate.data & 0b00000000000100000000000000000000) >> 20;
		auxiliaryA = (channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate.data & 0b00000000011000000000000000000000) >> 21;
		auxiliaryB = (channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate.data & 0b00000001100000000000000000000000) >> 23;
		auxiliaryC = (channelThrottleRollAuxiliaryCAuxiliaryD.data & 0b00000000001100000000000000000000) >> 20;
		auxiliaryD = (channelThrottleRollAuxiliaryCAuxiliaryD.data & 0b11111111110000000000000000000000) >> 22;
		
		failSafeData = (channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate.data & 0b01111110000000000000000000000000) >> 25;
		
		if (failSafeData != failSafePrevious)
		{
			failSafePrevious = failSafeData;
			timeFailSafePrevious = timeFailSafe.ms;
			
			failSafe = false;
		}
		else if (timeFailSafe.ms >= timeFailSafePrevious + 1000ull)
		{
			failSafe = true;
		}
		
		update = (channelPitchYawCutAuxiliaryAAuxiliaryBFailSafeUpdate.data & 0b10000000000000000000000000000000) >> 31;
		
		if (failSafe == true)
		{
			motor1.us (settingCutEsc);
			motor2.us (settingCutEsc);
			motor3.us (settingCutEsc);
			motor4.us (settingCutEsc);
			
			channelSettingBatteryTimer.transmit (settingBatteryTimer);
			channelSettingTrim.transmit (settingTrim);
			channelSettingStick.transmit (settingStick);
			channelSettingOptionWord1.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [0][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [0][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [0][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [0][0])));
			channelSettingOption1.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [0]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [0]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [0]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [0]) << 10 | (signed long)(settingOption [0]));
			channelSettingOptionWord2.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [1][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [1][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [1][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [1][0])));
			channelSettingOption2.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [1]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [1]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [1]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [1]) << 10 | (signed long)(settingOption [1]));
			channelSettingOptionWord3.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [2][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [2][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [2][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [2][0])));
			channelSettingOption3.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [2]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [2]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [2]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [2]) << 10 | (signed long)(settingOption [2]));
			channelSettingOptionWord4.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [3][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [3][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [3][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [3][0])));
			channelSettingOption4.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [3]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [3]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [3]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [3]) << 10 | (signed long)(settingOption [3]));
			channelSettingOptionWord5.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [4][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [4][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [4][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [4][0])));
			channelSettingOption5.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [4]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [4]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [4]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [4]) << 10 | (signed long)(settingOption [4]));
			channelSettingOptionWord6.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [5][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [5][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [5][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [5][0])));
			channelSettingOption6.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [5]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [5]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [5]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [5]) << 10 | (signed long)(settingOption [5]));
			channelSettingOptionWord7.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [6][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [6][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [6][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [6][0])));
			channelSettingOption7.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [6]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [6]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [6]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [6]) << 10 | (signed long)(settingOption [6]));
			channelSettingOptionWord8.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [7][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [7][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [7][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [7][0])));
			channelSettingOption8.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [7]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [7]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [7]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [7]) << 10 | (signed long)(settingOption [7]));
			channelSettingOptionWord9.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [8][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [8][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [8][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [8][0])));
			channelSettingOption9.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [8]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [8]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [8]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [8]) << 10 | (signed long)(settingOption [8]));
			channelSettingOptionWord10.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [9][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [9][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [9][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [9][0])));
			channelSettingOption10.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [9]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [9]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [9]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [9]) << 10 | (signed long)(settingOption [9]));
			channelSettingOptionWord11.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [10][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [10][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [10][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [10][0])));
			channelSettingOption11.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [10]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [10]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [10]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [10]) << 10 | (signed long)(settingOption [10]));
			channelSettingOptionWord12.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [11][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [11][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [11][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [11][0])));
			channelSettingOption12.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [11]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [11]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [11]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [11]) << 10 | (signed long)(settingOption [11]));
			channelSettingOptionWord13.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [12][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [12][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [12][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [12][0])));
			channelSettingOption13.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [12]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [12]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [12]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [12]) << 10 | (signed long)(settingOption [12]));
			channelSettingOptionWord14.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [13][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [13][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [13][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [13][0])));
			channelSettingOption14.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [13]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [13]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [13]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [13]) << 10 | (signed long)(settingOption [13]));
			channelSettingOptionWord15.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [14][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [14][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [14][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [14][0])));
			channelSettingOption15.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [14]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [14]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [14]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [14]) << 10 | (signed long)(settingOption [14]));
			channelSettingOptionWord16.transmit ((signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [15][3])) << 24 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [15][2])) << 16 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [15][1])) << 8 | (signed long)(Tool::characterToByte (&SETUP_SETTING_OPTION_WORD [15][0])));
			channelSettingOption16.transmit ((signed long)(SETUP_SETTING_OPTION_DECIMAL [15]) << 31 | (signed long)(SETUP_SETTING_OPTION_CENTER [15]) << 30 | (signed long)(SETUP_SETTING_OPTION_MAX [15]) << 20 | (signed long)(SETUP_SETTING_OPTION_MIN [15]) << 10 | (signed long)(settingOption [15]));
			
			channelSettingBatteryTimer.reset();
			channelSettingTrim.reset();
			channelSettingStick.reset();
			channelSettingOption1.reset();
			channelSettingOption2.reset();
			channelSettingOption3.reset();
			channelSettingOption4.reset();
			channelSettingOption5.reset();
			channelSettingOption6.reset();
			channelSettingOption7.reset();
			channelSettingOption8.reset();
			channelSettingOption9.reset();
			channelSettingOption10.reset();
			channelSettingOption11.reset();
			channelSettingOption12.reset();
			channelSettingOption13.reset();
			channelSettingOption14.reset();
			channelSettingOption15.reset();
			channelSettingOption16.reset();
			
			delaySoundStartCondition.state();
			
			if (delaySoundStartCondition.update == true && timeSound.ms > timeSoundPrevious)
			{
				SoundWrite::key (128, 100);
				SoundWrite::key (0, 100);
				SoundWrite::key (128, 100);
				SoundWrite::playKey();
			}
		}
		else
		{
			if (cut == true)
			{
				motor1.us (settingCutEsc);
				motor2.us (settingCutEsc);
				motor3.us (settingCutEsc);
				motor4.us (settingCutEsc);
			}
			else
			{
				gyroscope.readRotation();
				
				if (throttle <= centerMinThrottle && invert == false)
				{
					invert = true;
				}
				else if (throttle >= centerMaxThrottle && invert == true)
				{
					invert = false;
				}
				
				if (invert == true)
				{
					mixThrottle = Math::curve (centerMinThrottle, throttle, 0, settingMinEscInvert, maxEscLimitInvert, 0);
					
					mixMotor1 = mixThrottle;
					mixMotor2 = mixThrottle;
					mixMotor3 = mixThrottle;
					mixMotor4 = mixThrottle;
					
					mixMinClearancePitch = Math::curve (centerMinThrottle, throttle, 0, 0, travelPitchRollMaxLimitInvert, 0);
					mixMaxClearancePitch = Math::curve (centerMinThrottle, throttle, 0, travelPitchRollInvert, travelPitchRollMinLimitInvert, 0);
					mixPitchOffsetSpeed = Math::curve (0, pitch, 1023, -settingSpeedPitch, settingSpeedPitch, 0);
					mixThrustPitchGainSpeed = Math::curve (centerMinThrottle, throttle, 0, gainMaxRxSpeed, gainMinRxSpeed, 0);
					mixLockPitchGainSpeed.set (Math::wurve (0, pitch, 1023, gainLockRxSpeed, 1, gainLockRxSpeed, 0, 0));
					mixThrustPitchGainSpeed *= mixLockPitchGainSpeed.value;
					mixMinRxMotor = Math::wurve (-mixThrustPitchGainSpeed, gyroscope.rx - mixPitchOffsetSpeed, mixThrustPitchGainSpeed, -mixMaxClearancePitch, 0, mixMinClearancePitch, 0, 0);
					mixMaxRxMotor = Math::wurve (-mixThrustPitchGainSpeed, gyroscope.rx - mixPitchOffsetSpeed, mixThrustPitchGainSpeed, -mixMinClearancePitch, 0, mixMaxClearancePitch, 0, 0);
					
					mixMotor1 += mixMinRxMotor;
					mixMotor2 += mixMinRxMotor;
					mixMotor3 -= mixMaxRxMotor;
					mixMotor4 -= mixMaxRxMotor;
					
					mixMinClearanceRoll = Math::curve (centerMinThrottle, throttle, 0, 0, travelPitchRollMaxLimitInvert, 0);
					mixMaxClearanceRoll = Math::curve (centerMinThrottle, throttle, 0, travelPitchRollInvert, travelPitchRollMinLimitInvert, 0);
					mixRollOffsetSpeed = Math::curve (0, roll, 1023, -settingSpeedRoll, settingSpeedRoll, 0);
					mixThrustRollGainSpeed = Math::curve (centerMinThrottle, throttle, 0, gainMaxRySpeed, gainMinRySpeed, 0);
					mixLockRollGainSpeed.set (Math::wurve (0, roll, 1023, gainLockRySpeed, 1, gainLockRySpeed, 0, 0));
					mixThrustRollGainSpeed *= mixLockRollGainSpeed.value;
					mixMinRyMotor = Math::wurve (-mixThrustRollGainSpeed, gyroscope.ry + mixRollOffsetSpeed, mixThrustRollGainSpeed, -mixMaxClearanceRoll, 0, mixMinClearanceRoll, 0, 0);
					mixMaxRyMotor = Math::wurve (-mixThrustRollGainSpeed, gyroscope.ry + mixRollOffsetSpeed, mixThrustRollGainSpeed, -mixMinClearanceRoll, 0, mixMaxClearanceRoll, 0, 0);
					
					mixMotor1 += mixMinRyMotor;
					mixMotor2 -= mixMaxRyMotor;
					mixMotor3 += mixMinRyMotor;
					mixMotor4 -= mixMaxRyMotor;
					
					mixMinClearanceYaw = Math::curve (centerMinThrottle, throttle, 0, 0, travelYawMaxLimitInvert, 0);
					mixMaxClearanceYaw = Math::curve (centerMinThrottle, throttle, 0, travelYawInvert, travelYawMinLimitInvert, 0);
					mixYawOffsetSpeed = Math::curve (0, yaw, 1023, -settingSpeedYaw, settingSpeedYaw, 0);
					mixLockYawGainSpeed.set (Math::wurve (0, yaw, 1023, gainLockRzSpeed, 1, gainLockRzSpeed, 0, 0));
					mixInertiaYawGainSpeed = gainRzSpeed * mixLockYawGainSpeed.value;
					mixMinRzMotor = Math::wurve (-mixInertiaYawGainSpeed, gyroscope.rz - mixYawOffsetSpeed, mixInertiaYawGainSpeed, -mixMaxClearanceYaw, 0, mixMinClearanceYaw, 0, 0);
					mixMaxRzMotor = Math::wurve (-mixInertiaYawGainSpeed, gyroscope.rz - mixYawOffsetSpeed, mixInertiaYawGainSpeed, -mixMinClearanceYaw, 0, mixMaxClearanceYaw, 0, 0);
					
					mixMotor1 += mixMinRzMotor;
					mixMotor2 -= mixMaxRzMotor;
					mixMotor3 -= mixMaxRzMotor;
					mixMotor4 += mixMinRzMotor;
				}
				else
				{
					mixThrottle = Math::curve (centerMaxThrottle, throttle, 1023, settingMinEscNormal, maxEscLimitNormal, 0);
					
					mixMotor1 = mixThrottle;
					mixMotor2 = mixThrottle;
					mixMotor3 = mixThrottle;
					mixMotor4 = mixThrottle;
					
					mixMinClearancePitch = Math::curve (centerMaxThrottle, throttle, 1023, 0, travelPitchRollMaxLimitNormal, 0);
					mixMaxClearancePitch = Math::curve (centerMaxThrottle, throttle, 1023, travelPitchRollNormal, travelPitchRollMinLimitNormal, 0);
					mixPitchOffsetSpeed = Math::curve (0, pitch, 1023, -settingSpeedPitch, settingSpeedPitch, 0);
					mixThrustPitchGainSpeed = Math::curve (centerMaxThrottle, throttle, 1023, gainMaxRxSpeed, gainMinRxSpeed, 0);
					mixLockPitchGainSpeed.set (Math::wurve (0, pitch, 1023, gainLockRxSpeed, 1, gainLockRxSpeed, 0, 0));
					mixThrustPitchGainSpeed *= mixLockPitchGainSpeed.value;
					mixMinRxMotor = Math::wurve (-mixThrustPitchGainSpeed, gyroscope.rx + mixPitchOffsetSpeed, mixThrustPitchGainSpeed, -mixMaxClearancePitch, 0, mixMinClearancePitch, 0, 0);
					mixMaxRxMotor = Math::wurve (-mixThrustPitchGainSpeed, gyroscope.rx + mixPitchOffsetSpeed, mixThrustPitchGainSpeed, -mixMinClearancePitch, 0, mixMaxClearancePitch, 0, 0);
					
					mixMotor1 -= mixMinRxMotor;
					mixMotor2 -= mixMinRxMotor;
					mixMotor3 += mixMaxRxMotor;
					mixMotor4 += mixMaxRxMotor;
					
					mixMinClearanceRoll = Math::curve (centerMaxThrottle, throttle, 1023, 0, travelPitchRollMaxLimitNormal, 0);
					mixMaxClearanceRoll = Math::curve (centerMaxThrottle, throttle, 1023, travelPitchRollNormal, travelPitchRollMinLimitNormal, 0);
					mixRollOffsetSpeed = Math::curve (0, roll, 1023, -settingSpeedRoll, settingSpeedRoll, 0);
					mixThrustRollGainSpeed = Math::curve (centerMaxThrottle, throttle, 1023, gainMaxRySpeed, gainMinRySpeed, 0);
					mixLockRollGainSpeed.set (Math::wurve (0, roll, 1023, gainLockRySpeed, 1, gainLockRySpeed, 0, 0));
					mixThrustRollGainSpeed *= mixLockRollGainSpeed.value;
					mixMinRyMotor = Math::wurve (-mixThrustRollGainSpeed, gyroscope.ry - mixRollOffsetSpeed, mixThrustRollGainSpeed, -mixMaxClearanceRoll, 0, mixMinClearanceRoll, 0, 0);
					mixMaxRyMotor = Math::wurve (-mixThrustRollGainSpeed, gyroscope.ry - mixRollOffsetSpeed, mixThrustRollGainSpeed, -mixMinClearanceRoll, 0, mixMaxClearanceRoll, 0, 0);
					
					mixMotor1 -= mixMinRyMotor;
					mixMotor2 += mixMaxRyMotor;
					mixMotor3 -= mixMinRyMotor;
					mixMotor4 += mixMaxRyMotor;
					
					mixMinClearanceYaw = Math::curve (centerMaxThrottle, throttle, 1023, 0, travelYawMaxLimitNormal, 0);
					mixMaxClearanceYaw = Math::curve (centerMaxThrottle, throttle, 1023, travelYawNormal, travelYawMinLimitNormal, 0);
					mixYawOffsetSpeed = Math::curve (0, yaw, 1023, -settingSpeedYaw, settingSpeedYaw, 0);
					mixLockYawGainSpeed.set (Math::wurve (0, yaw, 1023, gainLockRzSpeed, 1, gainLockRzSpeed, 0, 0));
					mixInertiaYawGainSpeed = gainRzSpeed * mixLockYawGainSpeed.value;
					mixMinRzMotor = Math::wurve (-mixInertiaYawGainSpeed, gyroscope.rz + mixYawOffsetSpeed, mixInertiaYawGainSpeed, -mixMaxClearanceYaw, 0, mixMinClearanceYaw, 0, 0);
					mixMaxRzMotor = Math::wurve (-mixInertiaYawGainSpeed, gyroscope.rz + mixYawOffsetSpeed, mixInertiaYawGainSpeed, -mixMinClearanceYaw, 0, mixMaxClearanceYaw, 0, 0);
					
					mixMotor1 -= mixMinRzMotor;
					mixMotor2 += mixMaxRzMotor;
					mixMotor3 += mixMaxRzMotor;
					mixMotor4 -= mixMinRzMotor;
				}
				
				motor1.us (mixMotor1);
				motor2.us (mixMotor2);
				motor3.us (mixMotor3);
				motor4.us (mixMotor4);
			}
		}
		
		if (update == true && failSafe == false)
		{
			if (updated == false)
			{
				channelSettingBatteryTimer.receive();
				channelSettingTrim.receive();
				channelSettingStick.receive();
				channelSettingOption1.receive();
				channelSettingOption2.receive();
				channelSettingOption3.receive();
				channelSettingOption4.receive();
				channelSettingOption5.receive();
				channelSettingOption6.receive();
				channelSettingOption7.receive();
				channelSettingOption8.receive();
				channelSettingOption9.receive();
				channelSettingOption10.receive();
				channelSettingOption11.receive();
				channelSettingOption12.receive();
				channelSettingOption13.receive();
				channelSettingOption14.receive();
				channelSettingOption15.receive();
				channelSettingOption16.receive();
				
				if (channelSettingBatteryTimer.received == true && channelSettingTrim.received == true && channelSettingStick.received == true && channelSettingOption1.received == true && channelSettingOption2.received == true && channelSettingOption3.received == true && channelSettingOption4.received == true && channelSettingOption5.received == true && channelSettingOption6.received == true && channelSettingOption7.received == true && channelSettingOption8.received == true && channelSettingOption9.received == true && channelSettingOption10.received == true && channelSettingOption11.received == true && channelSettingOption12.received == true && channelSettingOption13.received == true && channelSettingOption14.received == true && channelSettingOption15.received == true && channelSettingOption16.received == true)
				{
					settingBatteryTimer = channelSettingBatteryTimer.data;
					settingTrim = channelSettingTrim.data;
					settingStick = channelSettingStick.data;
					settingOption [0] = channelSettingOption1.data & 0b00000000000000000000001111111111;
					settingOption [1] = channelSettingOption2.data & 0b00000000000000000000001111111111;
					settingOption [2] = channelSettingOption3.data & 0b00000000000000000000001111111111;
					settingOption [3] = channelSettingOption4.data & 0b00000000000000000000001111111111;
					settingOption [4] = channelSettingOption5.data & 0b00000000000000000000001111111111;
					settingOption [5] = channelSettingOption6.data & 0b00000000000000000000001111111111;
					settingOption [6] = channelSettingOption7.data & 0b00000000000000000000001111111111;
					settingOption [7] = channelSettingOption8.data & 0b00000000000000000000001111111111;
					settingOption [8] = channelSettingOption9.data & 0b00000000000000000000001111111111;
					settingOption [9] = channelSettingOption10.data & 0b00000000000000000000001111111111;
					settingOption [10] = channelSettingOption11.data & 0b00000000000000000000001111111111;
					settingOption [11] = channelSettingOption12.data & 0b00000000000000000000001111111111;
					settingOption [12] = channelSettingOption13.data & 0b00000000000000000000001111111111;
					settingOption [13] = channelSettingOption14.data & 0b00000000000000000000001111111111;
					settingOption [14] = channelSettingOption15.data & 0b00000000000000000000001111111111;
					settingOption [15] = channelSettingOption16.data & 0b00000000000000000000001111111111;
					
					Memory::write (2, settingBatteryTimer, 32);
					Memory::write (6, settingTrim, 32);
					Memory::write (10, settingStick, 32);
					
					for (n = 0; n < 16; n++)
					{
						Memory::write (14 + (n * 2), settingOption [n], 16);
					}
					
					channelSettingBatteryTimer.reset();
					channelSettingTrim.reset();
					channelSettingStick.reset();
					channelSettingOption1.reset();
					channelSettingOption2.reset();
					channelSettingOption3.reset();
					channelSettingOption4.reset();
					channelSettingOption5.reset();
					channelSettingOption6.reset();
					channelSettingOption7.reset();
					channelSettingOption8.reset();
					channelSettingOption9.reset();
					channelSettingOption10.reset();
					channelSettingOption11.reset();
					channelSettingOption12.reset();
					channelSettingOption13.reset();
					channelSettingOption14.reset();
					channelSettingOption15.reset();
					channelSettingOption16.reset();
					
					settingFrequencyEsc = settingOption [0];
					settingCutEsc = settingOption [1];
					settingMinEscNormal = settingOption [2];
					settingMaxEscNormal = settingOption [3];
					settingMinEscInvert = settingOption [4];
					settingMaxEscInvert = settingOption [5];
					settingSpeedPitch = settingOption [6];
					settingSpeedRoll = settingOption [7];
					settingSpeedYaw = settingOption [8];
					settingGainPitch = settingOption [9];
					settingGainRoll = settingOption [10];
					settingGainYaw = settingOption [11];
					settingTravelPitchRollVsYaw = settingOption [12];
					settingThrustPropeller = settingOption [13];
					settingLock = settingOption [14];
					settingLimitThrottle = settingOption [15];
					
					maxEscLimitNormal = Math::curve (0, settingLimitThrottle, 100, settingMinEscNormal, settingMaxEscNormal, 0);
					maxEscLimitInvert = Math::curve (0, settingLimitThrottle, 100, settingMinEscInvert, settingMaxEscInvert, 0);
					
					travelPitchRollNormal = (settingMaxEscNormal - settingMinEscNormal) / (100.0 / (settingTravelPitchRollVsYaw * (100.0 / ((settingTravelPitchRollVsYaw * 2.0) + (100.0 - settingTravelPitchRollVsYaw)))));
					travelPitchRollMinLimitNormal = Math::curve (0, settingLimitThrottle, 100, travelPitchRollNormal, 0, 0);
					travelPitchRollMaxLimitNormal = Math::curve (0, settingLimitThrottle, 100, 0, travelPitchRollNormal, 0);
					
					travelYawNormal = (settingMaxEscNormal - settingMinEscNormal) / (100.0 / ((100.0 - settingTravelPitchRollVsYaw) * (100.0 / ((settingTravelPitchRollVsYaw * 2.0) + (100.0 - settingTravelPitchRollVsYaw)))));
					travelYawMinLimitNormal = Math::curve (0, settingLimitThrottle, 100, travelYawNormal, 0, 0);
					travelYawMaxLimitNormal = Math::curve (0, settingLimitThrottle, 100, 0, travelYawNormal, 0);
					
					travelPitchRollInvert = (settingMinEscInvert - settingMaxEscInvert) / (100.0 / (settingTravelPitchRollVsYaw * (100.0 / ((settingTravelPitchRollVsYaw * 2.0) + (100.0 - settingTravelPitchRollVsYaw)))));
					travelPitchRollMinLimitInvert = Math::curve (0, settingLimitThrottle, 100, travelPitchRollInvert, 0, 0);
					travelPitchRollMaxLimitInvert = Math::curve (0, settingLimitThrottle, 100, 0, travelPitchRollInvert, 0);
					
					travelYawInvert = (settingMinEscInvert - settingMaxEscInvert) / (100.0 / ((100.0 - settingTravelPitchRollVsYaw) * (100.0 / ((settingTravelPitchRollVsYaw * 2.0) + (100.0 - settingTravelPitchRollVsYaw)))));
					travelYawMinLimitInvert = Math::curve (0, settingLimitThrottle, 100, travelYawInvert, 0, 0);
					travelYawMaxLimitInvert = Math::curve (0, settingLimitThrottle, 100, 0, travelYawInvert, 0);
					
					thrustGainSpeedPitch = Math::curve (0, settingThrustPropeller, 100, 0, settingGainPitch, 0);
					gainMinRxSpeed = Math::curve (0, thrustGainSpeedPitch, 100, 2000, 0, 0);
					gainMaxRxSpeed = Math::curve (0, settingGainPitch, 100, 2000, 0, 0);
					gainLockRxSpeed = Math::curve (0, settingLock, 100, 1, 0, 0);
					
					thrustGainSpeedRoll = Math::curve (0, settingThrustPropeller, 100, 0, settingGainRoll, 0);
					gainMinRySpeed = Math::curve (0, thrustGainSpeedRoll, 100, 2000, 0, 0);
					gainMaxRySpeed = Math::curve (0, settingGainRoll, 100, 2000, 0, 0);
					gainLockRySpeed = Math::curve (0, settingLock, 100, 1, 0, 0);
					
					gainRzSpeed = Math::curve (0, settingGainYaw, 100, 2000, 0, 0);
					gainLockRzSpeed = Math::curve (0, settingLock, 100, 1, 0, 0);
					
					motor1.us (settingCutEsc);
					motor2.us (settingCutEsc);
					motor3.us (settingCutEsc);
					motor4.us (settingCutEsc);
					
					PwmWrite::start (settingFrequencyEsc);
					
					updated = true;
					
					timeSoundPrevious = 0;
					
					for (n = 0; n < 8; n++)
					{
						if (n != 0)
						{
							durationKeySound = Random::integer (25, 75);
							
							SoundWrite::key (0, durationKeySound);
							
							timeSoundPrevious += durationKeySound;
						}
						
						durationKeySound = Random::integer (25, 75);
						
						SoundWrite::key (Random::integer (32, 1536), durationKeySound);
						
						timeSoundPrevious += durationKeySound;
					}
					
					SoundWrite::playKey();
					
					timeSoundPrevious += timeSound.ms + (unsigned long long)(TIME_SPACE_SOUND);
				}
			}
		}
		else
		{
			updated = false;
		}
	}
	
	return 0;
}
