Max7219::Max7219 (const unsigned char PIN_SS, const unsigned char DEVICE)
{
	unsigned char address = 1;
	
	_pinSs = PIN_SS;
	_registerPin = Core::pinToRegisterPin (PIN_SS);
	_bytePort = Core::pinToBytePort (PIN_SS);
	_device = DEVICE;
	
	*Core::pinToRegisterDdr (PIN_SS) |= _bytePort;
	*Core::pinToRegisterPort (PIN_SS) |= _bytePort;
	
	Core::startSpi (PIN_SS);
	
	*_registerPin = _bytePort;
	Core::writeSpiCascaded (PIN_SS, DEVICE, 0x00, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpiCascaded (PIN_SS, DEVICE, 0x0b, 0b00000111, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpiCascaded (PIN_SS, DEVICE, 0x09, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	for (address = 1; address <= 8; address++)
	{
		*_registerPin = _bytePort;
		Core::writeSpiCascaded (PIN_SS, DEVICE, address, 0b00000000, 8);
		*_registerPin = _bytePort;
	}
	
	*_registerPin = _bytePort;
	Core::writeSpiCascaded (PIN_SS, DEVICE, 0x0a, 0b00001111, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpiCascaded (PIN_SS, DEVICE, 0x0f, 0b00000000, 8);
	*_registerPin = _bytePort;
	
	*_registerPin = _bytePort;
	Core::writeSpiCascaded (PIN_SS, DEVICE, 0x0c, 0b00000001, 8);
	*_registerPin = _bytePort;
}

void Max7219::brightness (const unsigned char BRIGHTNESS)
{
	*_registerPin = _bytePort;
	Core::writeSpiCascaded (_pinSs, _device, 0x0a, BRIGHTNESS - 1, 8);
	*_registerPin = _bytePort;
}

void Max7219::digit (const unsigned char DIGIT, const bool COMMA, const unsigned char POSITION)
{
	*_registerPin = _bytePort;
	Core::writeSpiCascaded (_pinSs, _device, POSITION, Core::digitToByte (DIGIT, COMMA), 8);
	*_registerPin = _bytePort;
}

void Max7219::integer (const signed long INTEGER, const unsigned char POSITION_MIN, const unsigned char POSITION_MAX, const bool SIDE)
{
	const unsigned long FILL_NINE [8] = {9, 99, 999, 9999, 99999, 999999, 9999999, 99999999};
	unsigned long integerPositive = 0;
	unsigned long nSizeInteger = 10;
	unsigned char sizeMeterInteger = 1;
	unsigned char sizeInteger = 1;
	unsigned long offsetDigitExtraction = 1;
	unsigned char positionFirstDigit = 1;
	unsigned char positionMinus = 0;
	unsigned char address = 1;
	unsigned char data = 0;
	
	if (INTEGER >= 0)
	{
		integerPositive = INTEGER;
		
		for (nSizeInteger = 10; integerPositive >= nSizeInteger && sizeMeterInteger <= POSITION_MAX - (POSITION_MIN - 1); nSizeInteger *= 10)
		{
			sizeMeterInteger++;
		}
		
		if (sizeMeterInteger > POSITION_MAX - (POSITION_MIN - 1))
		{
			integerPositive = FILL_NINE [(POSITION_MAX - (POSITION_MIN - 1)) - 1];
			sizeInteger = POSITION_MAX - (POSITION_MIN - 1);
		}
		else
		{
			sizeInteger = sizeMeterInteger;
		}
	}
	else
	{
		integerPositive = -INTEGER;
		
		for (nSizeInteger = 10; integerPositive >= nSizeInteger && sizeMeterInteger <= POSITION_MAX - POSITION_MIN; nSizeInteger *= 10)
		{
			sizeMeterInteger++;
		}
		
		if (sizeMeterInteger > POSITION_MAX - POSITION_MIN)
		{
			integerPositive = FILL_NINE [(POSITION_MAX - POSITION_MIN) - 1];
			sizeInteger = POSITION_MAX - POSITION_MIN;
		}
		else
		{
			sizeInteger = sizeMeterInteger;
		}
	}
	
	for (nSizeInteger = 10; integerPositive >= nSizeInteger; nSizeInteger *= 10)
	{
		offsetDigitExtraction *= 10;
	}
	
	if (SIDE == true)
	{
		if (INTEGER >= 0)
		{
			positionFirstDigit = 8 - (sizeInteger - 1);
		}
		else
		{
			positionFirstDigit = 8 - sizeInteger;
		}
	}
	
	if (INTEGER < 0)
	{
		positionMinus = positionFirstDigit;
		positionFirstDigit++;
	}
	
	if (SIDE == false)
	{
		positionFirstDigit += POSITION_MIN - 1;
		positionMinus += POSITION_MIN - 1;
	}
	else
	{
		positionFirstDigit -= 8 - POSITION_MAX;
		positionMinus -= 8 - POSITION_MAX;
	}
	
	for (address = POSITION_MIN; address <= POSITION_MAX; address++)
	{
		if (address >= positionFirstDigit && address <= positionFirstDigit + (sizeInteger - 1))
		{
			data = Core::digitToByte ((integerPositive / offsetDigitExtraction) % 10, false);
			offsetDigitExtraction /= 10;
		}
		else if (address == positionMinus)
		{
			data = 0b00000001;
		}
		else
		{
			data = 0b00000000;
		}
		
		*_registerPin = _bytePort;
		Core::writeSpiCascaded (_pinSs, _device, address, data, 8);
		*_registerPin = _bytePort;
	}
}

void Max7219::decimal (const float DECIMAL, const unsigned char POSITION_MIN, const unsigned char POSITION_MAX, const unsigned char DIGIT_AFTER_COMMA, const bool SIDE)
{
	signed long integer = 0;
	const unsigned long FILL_NINE [8] = {9, 99, 999, 9999, 99999, 999999, 9999999, 99999999};
	unsigned long integerPositive = 0;
	unsigned long nSizeInteger = 10;
	unsigned char sizeMeterInteger = 1;
	unsigned char sizeInteger = 1;
	unsigned long offsetDigitExtraction = 1;
	unsigned char positionFirstDigit = 1;
	unsigned char positionComma = 0;
	unsigned char positionMinus = 0;
	unsigned char address = 1;
	unsigned char data = 0;
	
	if (DIGIT_AFTER_COMMA == 0)
	{
		integer = DECIMAL;
	}
	else
	{
		integer = DECIMAL * Core::pow (10, DIGIT_AFTER_COMMA);
	}
	
	if (integer >= 0)
	{
		integerPositive = integer;
		
		for (nSizeInteger = 10; integerPositive >= nSizeInteger && sizeMeterInteger <= POSITION_MAX - (POSITION_MIN - 1); nSizeInteger *= 10)
		{
			sizeMeterInteger++;
		}
		
		if (sizeMeterInteger > POSITION_MAX - (POSITION_MIN - 1))
		{
			integerPositive = FILL_NINE [(POSITION_MAX - (POSITION_MIN - 1)) - 1];
			sizeInteger = POSITION_MAX - (POSITION_MIN - 1);
		}
		else
		{
			sizeInteger = sizeMeterInteger;
		}
	}
	else
	{
		integerPositive = -integer;
		
		for (nSizeInteger = 10; integerPositive >= nSizeInteger && sizeMeterInteger <= POSITION_MAX - POSITION_MIN; nSizeInteger *= 10)
		{
			sizeMeterInteger++;
		}
		
		if (sizeMeterInteger > POSITION_MAX - POSITION_MIN)
		{
			integerPositive = FILL_NINE [(POSITION_MAX - POSITION_MIN) - 1];
			sizeInteger = POSITION_MAX - POSITION_MIN;
		}
		else
		{
			sizeInteger = sizeMeterInteger;
		}
	}
	
	for (nSizeInteger = 10; integerPositive >= nSizeInteger; nSizeInteger *= 10)
	{
		offsetDigitExtraction *= 10;
	}
	
	if (SIDE == true)
	{
		if (integer >= 0)
		{
			if (DIGIT_AFTER_COMMA == 0 || DIGIT_AFTER_COMMA <= sizeInteger - 1)
			{
				positionFirstDigit = 8 - (sizeInteger - 1);
			}
			else
			{
				positionFirstDigit = 8 - DIGIT_AFTER_COMMA;
			}
		}
		else
		{
			if (DIGIT_AFTER_COMMA == 0 || DIGIT_AFTER_COMMA <= sizeInteger - 1)
			{
				positionFirstDigit = 8 - sizeInteger;
			}
			else
			{
				positionFirstDigit = (8 - DIGIT_AFTER_COMMA) - 1;
			}
		}
	}
	
	if (DIGIT_AFTER_COMMA != 0)
	{
		if (DIGIT_AFTER_COMMA > sizeInteger - 1)
		{
			positionFirstDigit += DIGIT_AFTER_COMMA - (sizeInteger - 1);
		}
		
		positionComma = ((positionFirstDigit + sizeInteger) - DIGIT_AFTER_COMMA) - 1;
	}
	
	if (integer < 0)
	{
		if (DIGIT_AFTER_COMMA == 0 || sizeInteger > DIGIT_AFTER_COMMA)
		{
			positionMinus = positionFirstDigit;
		}
		else
		{
			positionMinus = positionComma;
		}
		
		positionFirstDigit++;
		
		if (DIGIT_AFTER_COMMA != 0)
		{
			positionComma++;
		}
	}
	
	if (SIDE == false)
	{
		positionFirstDigit += POSITION_MIN - 1;
		
		if (DIGIT_AFTER_COMMA != 0)
		{
			positionComma += POSITION_MIN - 1;
		}
		
		positionMinus += POSITION_MIN - 1;
	}
	else
	{
		positionFirstDigit -= 8 - POSITION_MAX;
		
		if (DIGIT_AFTER_COMMA != 0)
		{
			positionComma -= 8 - POSITION_MAX;
		}
		
		positionMinus -= 8 - POSITION_MAX;
	}
	
	for (address = POSITION_MIN; address <= POSITION_MAX; address++)
	{
		if (address >= positionFirstDigit && address <= positionFirstDigit + (sizeInteger - 1))
		{
			if (address == positionComma)
			{
				data = Core::digitToByte ((integerPositive / offsetDigitExtraction) % 10, true);
			}
			else
			{
				data = Core::digitToByte ((integerPositive / offsetDigitExtraction) % 10, false);
			}
			
			offsetDigitExtraction /= 10;
		}
		else if (positionComma != 0 && address < positionFirstDigit && address >= positionComma)
		{
			if (address == positionComma)
			{
				data = Core::digitToByte (0, true);
			}
			else
			{
				data = Core::digitToByte (0, false);
			}
		}
		else if (address == positionMinus)
		{
			data = 0b00000001;
		}
		else
		{
			data = 0b00000000;
		}
		
		*_registerPin = _bytePort;
		Core::writeSpiCascaded (_pinSs, _device, address, data, 8);
		*_registerPin = _bytePort;
	}
}

void Max7219::character (const char *CHARACTER, const unsigned char POSITION)
{
	unsigned char byte = 0;
	
	if (CHARACTER [0] != 0b00101110 && CHARACTER [1] == 0b00101110)
	{
		byte = Core::characterToByte (CHARACTER [0]) | 0b10000000;
	}
	else
	{
		byte = Core::characterToByte (CHARACTER [0]);
	}
	
	*_registerPin = _bytePort;
	Core::writeSpiCascaded (_pinSs, _device, POSITION, byte, 8);
	*_registerPin = _bytePort;
}

void Max7219::word (const char *WORD)
{
	unsigned char n = 0;
	unsigned char nCharacter = 0;
	bool end = false;
	unsigned char byte = 0;
	
	for (n = 0; n < 8 && end == false; n++)
	{
		if (WORD [nCharacter] == 0b00101111)
		{
			end = true;
		}
		else
		{
			if (WORD [nCharacter] != 0b00101110 && WORD [nCharacter + 1] == 0b00101110)
			{
				byte = Core::characterToByte (WORD [nCharacter]) | 0b10000000;
				nCharacter++;
			}
			else
			{
				byte = Core::characterToByte (WORD [nCharacter]);
			}
			
			*_registerPin = _bytePort;
			Core::writeSpiCascaded (_pinSs, _device, n + 1, byte, 8);
			*_registerPin = _bytePort;
			
			nCharacter++;
		}
	}
}

void Max7219::byte (const unsigned char BYTE)
{
	unsigned char n = 0;
	
	for (n = 0; n < 8; n++)
	{
		if ((BYTE >> n & 0b00000001) == true)
		{
			*_registerPin = _bytePort;
			Core::writeSpiCascaded (_pinSs, _device, 8 - n, Core::digitToByte (1, false), 8);
			*_registerPin = _bytePort;
		}
		else
		{
			*_registerPin = _bytePort;
			Core::writeSpiCascaded (_pinSs, _device, 8 - n, Core::digitToByte (0, false), 8);
			*_registerPin = _bytePort;
		}
	}
}

void Max7219::draw (const unsigned char DRAW, const unsigned char POSITION)
{
	*_registerPin = _bytePort;
	Core::writeSpiCascaded (_pinSs, _device, POSITION, DRAW, 8);
	*_registerPin = _bytePort;
}

void Max7219::drawDevice (const unsigned char DRAW1, const unsigned char DRAW2, const unsigned char DRAW3, const unsigned char DRAW4, const unsigned char DRAW5, const unsigned char DRAW6, const unsigned char DRAW7, const unsigned char DRAW8)
{
	unsigned char n = 0;
	const unsigned char DRAW [8] = {DRAW1, DRAW2, DRAW3, DRAW4, DRAW5, DRAW6, DRAW7, DRAW8};
	
	for (n = 0; n < 8; n++)
	{
		*_registerPin = _bytePort;
		Core::writeSpiCascaded (_pinSs, _device, n + 1, DRAW [n], 8);
		*_registerPin = _bytePort;
	}
}

void Max7219::dot (const unsigned char X, const unsigned char Y)
{
	*_registerPin = _bytePort;
	Core::writeSpiCascaded (_pinSs, _device, Y, 0b10000000 >> (X - 1), 8);
	*_registerPin = _bytePort;
}

void Max7219::clearLine (const unsigned char LINE)
{
	*_registerPin = _bytePort;
	Core::writeSpiCascaded (_pinSs, _device, LINE, 0b00000000, 8);
	*_registerPin = _bytePort;
}

void Max7219::clearDevice()
{
	unsigned char address = 1;
	
	for (address = 1; address <= 8; address++)
	{
		*_registerPin = _bytePort;
		Core::writeSpiCascaded (_pinSs, _device, address, 0b00000000, 8);
		*_registerPin = _bytePort;
	}
}
