/* 
 * File:   AD7793.h
 * Author: anthony
 *
 * Created on May 7, 2018, 7:53 PM
 */

#ifndef AD7793_H
#define	AD7793_H

#ifdef	__cplusplus
extern "C" {
#endif

#include <stdint.h>

#define BUF_SIZE 3 //adc 24 bits
#define SDI TRISAbits.TRISA1
#define SDO TRISAbits.TRISA0
#define SCK TRISAbits.TRISA2
#define GAIN_ADC_AIN1 0b010 //gain = 4
#define GAIN_ADC_AIN2 0b010
#define V_REF 1.17f


typedef enum AD7793_CHANNEL {
    AIN1, 
    AIN2
} AD7793_CHANNEL;

struct AppData;

void AD7793_init(struct AppData* const appData);
void AD7793_config(); // setup adc registers
void AD7793_sendData(const uint8_t* data, const uint8_t len); //send data but soft expect to read nothing
void AD7793_readData(uint8_t* dataOut, const uint8_t lenToRead);
void AD7793_readADC(AD7793_CHANNEL channel);
void AD7793_reset();


#ifdef	__cplusplus
}
#endif

#endif	/* AD7793_H */

