

#define Version "2020_06231"
 #define Directory "C:\\_MikroC\\_MesProjets_MikroC\\_18F252_fo_Tests"
 #define Project "Test_divers_18F252.mcppi"
 #define Source  "Test_divers_18F252"
 #define Eeprom " not used"
 #define Config "P18F252_Q10MHz.cfgsch"


 #define PROCESSOR "18F252"
 #define OSCILLATEUR "QUARTZ_10MHz"
 #define POWER_SUPPLY  " 5V"
 #define FOSC "10.0"  // MHz
 #define BAUD 19200  // UART1
// #define With_Nokia_Lcd   // modele 96x64 pixel !


/* =========== HARDWARE ====================
PIC 18F252  microchip   28 pins RAM  1536 bytes   Progr 32Kb
27 pf  Q=10Mhz 27pF
Interface 2T pour liaison UART TTL <-> RS232 38400 bauds
PortB
B0  21  ---R + Led rouge---+Vcc
B1  22  ---R + LedBlanche---+Vcc
B2  23  BP Start.
B3  24  BP_Mem
B4  25
B5  26
B6  27
B7  28

PORTA
A0   2
A1   3
A2   4
A3   5  R + led blanche
A4   6  R + Led rouge
A5   7

PORTC                          SPI1      LCD
C0   11  ->  output ->R=2.7K -> 5.CS  - Chip Select Enable
C1   12  ->  output ->R=2.7K -> 4.D/C - Data Command input
C2   13  -> output -> R=2.7K -> 8.RES - reset
C3   14  -> SCLK ---->R=2.7K--> 2.SCK - Serial ClocK
C4   15  <- SDI Not used---SDO slave
C5   16  -> SDO ----> R=2.7K-> 3.SDI- Serial Data Input-
C6   17  TX  RS232   ---> ecran
C7   18  RX  RS232   <--- clavier


fils connecteur 10 pins : marron 0, rouge 1, orange 3 ..etc ..Blanc et noir non connects
LCD Nokia 3310 8 pins :
1.vdd au +5V via 1 diode blanche au +5V ou via regulateur 3.6V
2.SCK - Serial ClocK
3.SDI - Serial Data Input
4.D/C - Data Command input
5.CS  - Chip Select Enable
6.GND - ground
7.VOUT - VLCD capa  1F => 8.56V gnr !
8.RES - reset
*/

#include "built_in.h"     // for  Hi  Lo ..etc

  //ac:pinout

#define CLS 12
#define TAB 9
#define CR 13
#define LF 10
#define Bell 7
#define ON 0        // logique inverse avec led tiree au +5V
#define OFF 1

/*

const code char mesg0[]=" Directory :"Directory"\r\n";
const code char mesg1[]=" MikroC pro 7.60 \n\r";
const code char mesg2[] =" Projet :"Project"\r\n";
const code char mesg3[]=" Solar Control System \r\n";
const char char mesg4[]=" Config bit : "Config"\r\n";
const char char mesg5[]=" ";
const char char mesg6[]=" Source : "Source"_"Version".c\r\n";
const char char mesg7[]=" ..\r\n";
const char char mesg8[]=" ..\r\n";
const char char mesg9[]=" ..\r\n";
const code char * Messages[]={mesg0,mesg1,mesg2,mesg3,mesg4,mesg5,mesg6,mesg7,mesg8,mesg9};
*/

sbit Led_Rouge   at LATB.B0;
sbit Led_Blanche at LATB.B1 ;
sbit Led_Rouge_Dir   at TRISB.B0;
sbit Led_Blanche_Dir at TRISB.B1;

unsigned int i,j,k,l;


void Init_Hardware()
{
  TRISC=0xFF;
  TRISA=0xFF;
  ADCON0 = 0xC1; //0b11000001 ;
  ADCON1 = 0xC4; //0b11000100 ;
  Led_Rouge_Dir=0;
  Led_Rouge=OFF;
  Led_Blanche_Dir=0;
  Led_Blanche=OFF;

 }


void main()
{
 Init_Hardware() ;
 do
 {
 Led_Blanche=OFF ;
 //Led_Rouge=OFF ;
  Delay_ms(500);
 Led_Blanche=ON ;
 // Led_Rouge=ON;
   Delay_ms(500);
   _asm btg LATB,0     // led rouge
 }
  while(1);
}

/*
0 1 mikroCPIC1618.exe -MSF -DBG -pP18F252 -RA -C -DL -O11111114 -fo10 -N"C:\_MikroC\_MesProjets_MikroC\_18F252_for_Tests\Test_divers_18F252.mcppi" -SP"C:\_MikroC\mikroC PRO for PIC\Defs\" -SP"C:\_MikroC\mikroC PRO for PIC\uses\P18\" -SP"C:\_MikroC\_MesProjets_MikroC\_18F252_for_Tests\" -SP"C:\_MikroC\_MesProjets_MikroC\_2tsts\PIC18F252_for_Tests\" -SP"C:\_MikroC\_MesProjets_MikroC\common\" -IP"C:\_MikroC\mikroC PRO for PIC\uses\P18\" "Test_divers_18F252.c" "__Lib_Math.mcl" "__Lib_MathDouble.mcl" "__Lib_System.mcl" "__Lib_Delays.mcl" "__Lib_CType.mcl" "__Lib_CString.mcl" "__Lib_CStdlib.mcl" "__Lib_Conversions.mcl" "__Lib_ADC_A_C.mcl" "__Lib_SPI_c345.mcl" "__Lib_UART_c67.mcl"
0 1139 Available RAM: 1515 [bytes], Available ROM: 32768 [bytes]
0 122 Compilation Started P18F252.c
1022 123 Compiled Successfully P18F252.c
0 122 Compilation Started __Lib_Delays.c
172 123 Compiled Successfully __Lib_Delays.c
0 122 Compilation Started Test_divers_18F252.c
127 123 Compiled Successfully Test_divers_18F252.c
0 127 All files Compiled in 78 ms
0 1144 Used RAM (bytes): 0 (1%)  Free RAM (bytes): 1515 (99%) Used RAM (bytes): 0 (1%)  Free RAM (bytes): 1515 (99%)
0 1144 Used ROM (bytes): 138 (1%)  Free ROM (bytes): 32630 (99%) Used ROM (bytes): 138 (1%)  Free ROM (bytes): 32630 (99%)
0 125 Project Linked Successfully Test_divers_18F252.mcppi
0 128 Linked in 16 ms
0 129 Project 'Test_divers_18F252.mcppi' completed: 297 ms
0 103 Finished successfully: 23 juin 2020, 19:06:56 Test_divers_18F252.mcppi

*/