/*****************************************************************/
/* Nom du fichier	: Main.c						 			 */
/* Date de cration : 16 avril 2008								 */
/*****************************************************************/

#include "Gateway.h"

/**********************************************************************/
/*							Configuration du C						  */
/**********************************************************************/
_FBS(BSS_NO_FLASH & BWRP_WRPROTECT_OFF);								// Pas de segment de boot et pas de protection en criture
_FGS(GSS_OFF & GCP_OFF & GWRP_OFF);										// Pas de protection du code 
_FOSCSEL(FNOSC_PRIPLL & IESO_OFF);										// Oscillateur principal avec PLL et 1 vitesse de l'oscillateur au dmarrage
_FOSC(FCKSM_CSDCMD & IOL1WAY_OFF & OSCIOFNC_ON & POSCMD_XT);			// Pas de clock switching ni de clock monitor,Oscillateur en mode XT 
_FWDT(FWDTEN_OFF & WINDIS_OFF);											// WatchDog inactif
_FPOR(FPWRT_PWR1 & ALTI2C_ON);											// POR = 0ms, IC avec mappage original

int				i							= 0;
int 			Freq						= 8;
char 			MIPS						= 25;
int				ReceptionSPI				= 0;
byte			Counter						= 0;
byte			Countdown					= 16;
char			Tab[16]						= "0123456789ABCDEF";
byte			MessageSlave				= 0;


void __attribute__((__interrupt__, no_auto_psv)) _SPI1Interrupt(void)
{
//	_SPIROV = 0;
//	SPI1BUF = 0xCD;
//	while(!_SPIRBF);
//	MessageSlave = SPI1BUF;
//	while(_SPITBF);
	_SPI1IF	= 0;
}




char InitPLL(int quartz, char Fcy)
{
	char N1=2, M=2, N2=1;					//	N1=>PLLPRE, 	M=>PLLDIV, 		N2=>PLLPOST

// Scurits //

	if((Fcy<7) || (Fcy>40))					// page 78 de la datasheet est dit que Fcy doit tre comprise entre 6.25 et 40 MIPS. 
		return 1; 							// Si on est pas dans cet intervalle, on retourne 1.
		
	if((quartz<2) || (quartz>264))			// A la sortie de PLLPRE on doit tre entre 0.8 et 8MHz. Sachant que dans PLLPRE 
		return 2;							// on peut diviser la frquence du quartz par un nombre comprit entre 2 et 33, on a 
											// donc la frquence du quartz devant tre comprise entre 2 et 264MHz (0.8*2=1.6 soit 
											// presque 2MHz et 8*33=264MHz) 

	while((quartz/N1)>8)N1++; 				// A la sortie de PLLPRE, nous devons avoir une frquence comprise entre 0.8 et 8MHz.
											// Donc quartz/N1 doit tre infrieur  8.

	while(((Fcy<<1)<<N2)<100)N2++;			// Permet de dterminer N2
	if(N2==3) N2++;

// Paramtrage des oscillateurs //

		M = ((Fcy<<1)<<N2)/(quartz/N1);		// Dtermine M;
		
		_PLLPRE = N1-2;						// Affectation de PLLPRE avec la valeur N1 dtermin prcdemment
		_PLLPOST = N2-1;					// Affectation de PLLPOST avec la valeur N2 dtermin prcdemment
		_PLLDIV = M-2;						// Affectation de PLLDIV avec la valeur M dtermin prcdemment

	return 0;								// Indique que tous c'est correctement droul
}




void InitPort(void)
{
	IOpin6	= 2; 	//_SCK1R
	IOpin7	= 7; 
	IOpin26	= 15;	//_SDI1R
	IOpin15	= 6;	//_SS1R
	PORTB 	= 0;
	TRISB	= 0x8044; 
	AD1PCFGL= 0x03FF;
//	_ADON = 1;
//	_NSTDIS	= 0;
}	




void InitSPI(void)
{
	SPI1BUF				= 0;

//	IFS0bits.SPI1IF 	= 0; 
//	IEC0bits.SPI1IE 	= 0;
//	IPC2bits.SPI1IP 	= 7;


	SPI1STAT			= 0x0000;

	SPI1CON1bits.DISSCK = 1;
	SPI1CON1bits.DISSDO	= 0;
	SPI1CON1bits.MODE16	= 0;
	SPI1CON1bits.SMP	= 0;
	SPI1CON1bits.CKE	= 1;
	SPI1CON1bits.SSEN	= 1;
	SPI1CON1bits.CKP	= 0;
	SPI1CON1bits.MSTEN	= 0;
	SPI1CON1bits.SPRE 	= 5;
	SPI1CON1bits.PPRE 	= 2;

	SPI1CON2bits.FRMEN	= 0;

	_SPIROV				= 0;
	SPI1STATbits.SPIEN	= 1;

//	IEC0bits.SPI1IE 	= 1;
}


void InitUC(void)
{
	InitPLL(Freq, MIPS);
	InitPort();
	InitSPI();
//	_SPIEN 	= 1;
//	_SPI1IE = 1;
}



int main(void)
{
	InitUC();
	while(1)
	{
		MessageSlave = SPI1BUF;
		while(_SPITBF);
		SPI1BUF = 0xAB;
		while(!_SPIRBF);
//		while(!_SPITBF);
//		_SPIROV = 0;
//		SPI1BUF = 0x12;
//		MessageSlave = SPI1BUF;
//		while(!_SPIRBF);
		Idle();
	}
	return 1;
}
