/*****************************************************************/
/* Nom du fichier	: TypeDef.h						 		 */
/* Date de cration : 3 mars 2008								 */
/*****************************************************************/

#ifndef TYPEDEFS_H
#define TYPEDEFS_H

typedef unsigned char   byte;           // 8-bit
typedef unsigned int    word;           // 16-bit
typedef unsigned long   dword;          // 32-bit

typedef union _BYTE
{
    byte _byte;
    struct
    {
        unsigned b0:1;
        unsigned b1:1;
        unsigned b2:1;
        unsigned b3:1;
        unsigned b4:1;
        unsigned b5:1;
        unsigned b6:1;
        unsigned b7:1;
    };
} BYTE;

typedef union _WORD
{
    word _word;
    struct
    {
        byte byte0;
        byte byte1;
    };
    struct
    {
        BYTE Byte0;
        BYTE Byte1;
    };
    struct
    {
        BYTE LowB;
        BYTE HighB;
    };
    struct
    {
        byte v[2];
    };
} WORD;
#define LSB(a)      ((a).v[0])
#define MSB(a)      ((a).v[1])

typedef union _DWORD
{
    dword _dword;
    struct
    {
        byte byte0;
        byte byte1;
        byte byte2;
        byte byte3;
    };
    struct
    {
        word word0;
        word word1;
    };
    struct
    {
        BYTE Byte0;
        BYTE Byte1;
        BYTE Byte2;
        BYTE Byte3;
    };
    struct
    {
        WORD Word0;
        WORD Word1;
    };
    struct
    {
        byte v[4];
    };
} DWORD;

#define LOWER_LSB(a)    ((a).v[0])
#define LOWER_MSB(a)    ((a).v[1])
#define UPPER_LSB(a)    ((a).v[2])
#define UPPER_MSB(a)    ((a).v[3])

typedef enum _BOOL { FALSE = 0, TRUE } BOOL;

#define OK      TRUE
#define FAIL    FALSE

typedef enum 
{
    sdcValid=0,                 	// Everything is golden
    sdcCardInitCommFailure,     	// Communication has never been established with card
    sdcCardNotInitFailure,      	// Card did not go into an initialization phase
    sdcCardInitTimeout,         	// Card initialization has timedout
    sdcCardTypeInvalid,         	// Card type was not able to be defined
    sdcCardBadCmd,              	// Card did not reconized the command
    sdcCardTimeout,             	// Card timedout during a read, write or erase sequence   
    sdcCardCRCError,            	// A CRC error has occurred during a read, data should be invalidated
    sdcCardDataRejected,        	// Card and data sent's CRC did not match
    sdcEraseTimedOut            	// Erase took longer than it should have 
}SDC_Error;

#endif //TYPEDEFS_H
