/*****************************************************************/
/* Nom du fichier	: Main.c						 			 */
/* Date de cration : 16 avril 2008								 */
/*****************************************************************/

#include "Gateway.h"

/**********************************************************************/
/*							Configuration du C						  */
/**********************************************************************/
_FBS(BSS_NO_FLASH & BWRP_WRPROTECT_OFF);								// Pas de segment de boot et pas de protection en criture
_FGS(GSS_OFF & GCP_OFF & GWRP_OFF);										// Pas de protection du code 
_FOSCSEL(FNOSC_PRIPLL & IESO_OFF);										// Oscillateur principal avec PLL et 1 vitesse de l'oscillateur au dmarrage
_FOSC(FCKSM_CSDCMD & IOL1WAY_OFF & OSCIOFNC_ON & POSCMD_XT);			// Pas de clock switching ni de clock monitor,Oscillateur en mode XT 
_FWDT(FWDTEN_OFF & WINDIS_OFF);											// WatchDog inactif
_FPOR(FPWRT_PWR1 & ALTI2C_ON);											// POR = 0ms, IC avec mappage original

#define 		FCY      		25000000
#define 		BAUDRATE 		115200                
#define 		BRGVAL   		((FCY/BAUDRATE)/16)-1 
#define			CS				_LATB9


dword			i							= 0;
int				a							= 0;
int				b							= 0;
int 			Freq						= 6;
char 			MIPS						= 25;
byte			ReponseSPI					= 0;
char			Tab[16]						= "0123456789ABCDEF";
byte			VarTemp						= 0;
byte			Message						= 0;

char InitPLL(int quartz, char Fcy)
{
	char N1=2, M=2, N2=1;					//	N1=>PLLPRE, 	M=>PLLDIV, 		N2=>PLLPOST

// Scurits //

	if((Fcy<7) || (Fcy>40))					// page 78 de la datasheet est dit que Fcy doit tre comprise entre 6.25 et 40 MIPS. 
		return 1; 							// Si on est pas dans cet intervalle, on retourne 1.
		
	if((quartz<2) || (quartz>264))			// A la sortie de PLLPRE on doit tre entre 0.8 et 8MHz. Sachant que dans PLLPRE 
		return 2;							// on peut diviser la frquence du quartz par un nombre comprit entre 2 et 33, on a 
											// donc la frquence du quartz devant tre comprise entre 2 et 264MHz (0.8*2=1.6 soit 
											// presque 2MHz et 8*33=264MHz) 

	while((quartz/N1)>8)N1++; 				// A la sortie de PLLPRE, nous devons avoir une frquence comprise entre 0.8 et 8MHz.
											// Donc quartz/N1 doit tre infrieur  8.

	while(((Fcy<<1)<<N2)<100)N2++;			// Permet de dterminer N2
	if(N2==3) N2++;

// Paramtrage des oscillateurs //

		M = ((Fcy<<1)<<N2)/(quartz/N1);		// Dtermine M;
		
		_PLLPRE = N1-2;						// Affectation de PLLPRE avec la valeur N1 dtermin prcdemment
		_PLLPOST = N2-1;					// Affectation de PLLPOST avec la valeur N2 dtermin prcdemment
		_PLLDIV = M-2;						// Affectation de PLLDIV avec la valeur M dtermin prcdemment

	return 0;								// Indique que tous c'est correctement droul
}




void InitPort(void)
{
	IOpin8  = 8;							// Patte 8 du PIC --> SCK1OUT	(SPI1 Clock Output)
	IOpin10	= 7;							// Patte10 du PIC --> SDO1	 	(SPI1 Data Output)
	IOpin11	= 8;							// Patte11 du PIC --> SDI1		(SPI1 Data Input)
	IOpin12 = 9;							// Patte12 du PIC --> SS1OUT 	(SPI1 Slave Select Output)
	IOpin15	= 3;							// Patte15 du PIC --> U1TX		(UART1 Transmission)
	_NSTDIS	= 0;
	PORTB 	= 0;
	TRISB	= 0x0100;
	AD1PCFGL= 0x003F;
}	



void Config_UART(void)
{
	U1MODEbits.UARTEN 	= 0;		// UARTx pin dconnecte . Toutes les pins UARTx sont commandes par les port latches. Conso mini 
	U1MODEbits.USIDL 	= 0;    	// Continue les oprations du module mme en mode idle
	U1MODEbits.IREN 	= 0;    	// Encodeur et dcodeur de trame infrarouge (IrDA) dconnect
	U1MODEbits.UEN 		= 0;    	// UARTx Enable bits 
	U1MODEbits.WAKE 	= 0;    	// Wake-up on Start bit Detect During Sleep Mode Enable bit 
	U1MODEbits.LPBACK 	= 0;    	// Loopback Mode dconnect
	U1MODEbits.ABAUD 	= 0;    	// Auto-Baud dconnect 
	U1MODEbits.BRGH 	= 0;    	// prescaler de 16
	U1MODEbits.PDSEL 	= 0;    	// Trames 8 bits, pas de bit de parit
	U1MODEbits.STSEL 	= 0;    	// Stop Bit Selection bit 
	U1BRG 				= BRGVAL;	// Baud rate dfinit  115200 bauds/s soit 1800 octets/s. ATTENTION : error = 0,45%. Voir datasheet p.144
	
	/* Configure DRA transfert (par de reception, on veut juste envoyer) */
	U1STAbits.UTXEN 	= 0;    	// Transmit Enable bit 
	U1STAbits.UTXISEL0 	= 1;   		// Interruption lorsqu'un caractre est transfr et que par consquent le buffer est vide
	U1STAbits.UTXISEL1	= 0;
	U1STAbits.ADDEN 	= 0;    	// Address Character Detect bit (bit 8 of received data = 1) 
	
	/* Dclenche transmission RS232 */
	U1MODEbits.UARTEN 	= 1;		// UARTx dispo. Toutes les pins de l'UART sont dfinies par UEN<1:0>
	U1STAbits.UTXEN		= 1;		// Transmission TX dispo. Pin UxTX controll par l'UART
	
	IEC0bits.SPI1EIE 	= 0;		// Requete d'interruption d'erreur dsactive
}

void InitSPI(void)
{
	SPI1STAT			= 0x0000;

	_SPIROV				= 0;
	SPI1CON1bits.DISSCK = 0;
	SPI1CON1bits.DISSDO	= 0;
	SPI1CON1bits.MODE16	= 0;
	SPI1CON1bits.SMP	= 0;
	SPI1CON1bits.CKE	= 1;
	SPI1CON1bits.SSEN	= 0;
	SPI1CON1bits.CKP	= 0;
	SPI1CON1bits.MSTEN	= 1;
	SPI1CON1bits.SPRE 	= 5;
	SPI1CON1bits.PPRE 	= 2;

	SPI1CON2bits.FRMEN	= 0;
//	SPI1CON2bits.SPIFSD	= 0;
//	SPI1CON2bits.FRMPOL	= 1;
//	SPI1CON2bits.FRMDLY	= 0;

	SPI1BUF				= 0;
	SPI1STATbits.SPIEN	= 1;
}


void InitUC(void)
{
	InitPLL(Freq, MIPS);
	InitPort();
	Config_UART();
	InitSPI();
}



int main(void)
{
	InitUC();
	while(1)
	{
		_SPIROV = 0;
		CS = 0;
		SPI1BUF = 0xAB;
		while(!_SPIRBF);
		Message = SPI1BUF;
		while(_SPITBF);
		SPI1BUF = 0x00;
		while(!_SPIRBF);
		Message = SPI1BUF;
		while(_SPITBF);
		SPI1BUF = 0x00;
		while(!_SPIRBF);
		Message = SPI1BUF;
		while(_SPITBF);
		SPI1BUF = 0x00;
		while(!_SPIRBF);
		Message = SPI1BUF;
		while(_SPITBF);
		CS = 1;
		while (_UTXBF == 1);
		U1TXREG = Tab[(Message >> 4) & 0x0f];
		while (_UTXBF == 1);
		U1TXREG = Tab[Message & 0x0f];
		while (_UTXBF == 1);
		U1TXREG = 0x0D;
		while (_UTXBF == 1);
		U1TXREG = 0x0A;

//		_SPIROV = 0;
//		CS 		= 0;
//		Message = SPI1BUF;
//		SPI1BUF = 0xAD;
//		while(_SPITBF);
//		while(!_SPIRBF);
//		while (_UTXBF == 1);
//		U1TXREG = Tab[(Message >> 1) & 0x0f];
//		while (_UTXBF == 1);
//		U1TXREG = Tab[Message & 0x0f];
//		while (_UTXBF == 1);
//		U1TXREG = 0x0D;
//		while (_UTXBF == 1);
//		U1TXREG = 0x0A;
//		CS = 1;
	}
	return 1;
}
