; *********************************************************
; * tv_sync*
; * for ATtiny45 on external clock              *
; * Version 1.0 by JRV                                    *
; *********************************************************
;
.INCLUDE "tn45def.inc"
.

;====================================================================================================================
;           Hardware connections
;====================================================================================================================
;                                              ___   ___
;                  (PCINT5/RESET/ADC0/dW) PB5 |1  |_|  8| VCC
;   16MHz  (PCINT3/XTAL1/CLKI/#OC1B/ADC3) PB3 |2   A   7| PB2 (SCK/USCK/SCL/ADC1/T0/INT0/PCINT2)        SYNC_IN
;   XTAL    (PCINT4/XTAL2/CLKO/OC1B/ADC2) PB4 |3   T   6| PB1 (MISO/DO/AIN1/OC0B/OC1A/PCINT1)           SYNC_OUT
;                                         GND |4   M   5| PB0 (MOSI/DI/SDA/AIN0/OC0A/#OC1A/AREF/PCINT0) SYNC_SW
;                                             |_________|
;                            
;
;====================================================================================================================
;            Register definitions
;====================================================================================================================
;
;define processing clock frequency
#define _FREQ_ACT  16;in MHz
#define _FREQ_REG  8;in MHz
;define usefull constants
.EQU _NB_LINE                 = 625;
.EQU _RESET                   = 5; port B
.EQU _SYNC_IN                 = 2; port B
.EQU _SYNC_OUT                = 1; port B
.EQU _SYNC_SW                 = 0;
.EQU _VAL_SYNC                = 128; delay compensation
;port configuration
.EQU _DDRB                    = 1<<_SYNC_OUT|1<<_SYNC_SW;
.EQU _PORTB                   = 1<<_RESET|1<<_SYNC_OUT; pull up 

;Timer0 configuration
.EQU _MODE0                   = 7; fast PWM 
.EQU _CLK0                    = 0<<CS02|1<< CS01|0<< CS00; divide by 8 clock is 2MHz
.EQU _TCCR0A                  = 0<<COM0A1|0<<COM0A0|0<<COM0B1|0<<COM0B0|(_MODE0 & 0x3); 
.EQU _TCCR0B0                 = 0<<FOC0A|0<<FOC0B|(_MODE0 & 4)<< 1; clock off
.EQU _TCCR0B1                 = 0<<FOC0A|0<<FOC0B|(_MODE0 & 4)<< 1|_CLK0; clock on
.EQU _OCR0A                   = 20; 10µS
.EQU _OCR0B                   = 0;

;Timer1 configuration  
.EQU _MODE1                   = 0<< CTC1|1<< PWM1A; pwm & ctc
.EQU _CLK1                    = 0<< CS13|0<< CS12|1<< CS11|0<< CS10 ;divide by 2
.EQU _TCCR10                  = 1<<COM1A1|1<<COM1A0|_MODE1|_CLK1; active
.EQU _TCCR11                  = 0<<COM1A1|0<<COM1A0|_MODE1|_CLK1; inactive
.EQU _GTCCR0                  = 0<< TSM|1<< PWM1B|0<< COM1B1|0<< COM1B0|0<< FOC1B|0<< FOC1A|0<< PSR1|0<< PSR0;
.EQU _GTCCR1                  = 1<< TSM|1<< PWM1B|0<< COM1B1|0<< COM1B0|0<< FOC1B|0<< FOC1A|0<< PSR1|1<< PSR0;
.EQU _OCR1A0                  = 218;  equalizing pulse wide
.EQU _OCR1A1                  = 19;   equalizing pulse narrow
.EQU _OCR1A2                  = 38;   sync pulse
.EQU _OCR1B                   = _VAL_SYNC;  interrupt for timing generator
.EQU _OCR1C                   = 255;  => 31250 Hz

;common values
.EQU _TIMSK                   = 0<< OCIE1A|1<< OCIE1B|1<< OCIE0A|0<< OCIE0B|0<< TOIE1|0<< TOIE0; 
.EQU _TIFR                    = 0<< OCF1A |1<< OCF1B |1<< OCF0A |0<< OCF0B |0<< TOV1 |0<< TOV0;

;interrupt
.EQU _GIMSK                   = 1<<INT0;
.EQU _GIFR                    = 1<<INTF0;
.EQU _MCUCR                   = 1<<ISC01|0<<ISC00; catching of external composite sync

;====================================================================================================================
;                                          Register definitions
;====================================================================================================================
;

.DEF rmp0          = R16 ;  Multi-purpose register 
.DEF rmp1          = R17 ;  Multi-purpose register 
.DEF rmp2          = R18 ;  Multi-purpose register 
.DEF rmp3          = R19 ;  Multi-purpose register 
.DEF rmp4          = R20 ;  Multi-purpose register 
.DEF rmp5          = R21;   Multi-purpose register 
.DEF rmp6          = R22 ;  Multi-purpose register 
.DEF rmp7          = R23 ;  Multi-purpose register 
.DEF rDelL         = R24 ;  delay counter LSB
.DEF rDelH         = R25 ;  delay counter MSB

.DEF rcp0          = R0  ;  computation registers
.DEF rcp1          = R1  ;  computation registers
.DEF rcp2          = R2  ;  computation registers
.DEF rcp3          = R3  ;  computation registers
.DEF rcp4          = R4  ;  computation registers
.DEF rcp5          = R5  ;  computation registers
.DEF rcp6          = R6  ;  computation registers
.DEF rcp7          = R7  ;  computation registers
.DEF rcp8          = R8  ;  computation registers
.DEF rcp9          = R9  ;  computation registers
.DEF rcp10         = R10 ;  computation registers
.DEF rcp11         = R11 ;  computation registers
.DEF rcp12         = R12 ;  computation registers
.DEF rcp13         = R13 ;  computation registers
.DEF rcp14         = R14 ;  computation registers
.DEF rcp15         = R15 ;  computation registers

;====================================================================================================================
;                                           Macro  definitions
;====================================================================================================================


.MACRO xpush01
    push rmp0; 
    push rmp1; 
    in rmp0,SREG ; 
    push rmp0; 
.ENDMACRO

.MACRO xpop01
    pop rmp0; 
    out SREG,rmp0;  
    pop rmp1; 
    pop rmp0; 
.ENDMACRO

.MACRO xpush012
    push rmp0; 
    push rmp1; 
    push rmp2; 
    in rmp0,SREG ; 
    push rmp0; 
.ENDMACRO

.MACRO xpop012
    pop rmp0; 
    out SREG,rmp0;  
    pop rmp2; 
    pop rmp1; 
    pop rmp0; 
.ENDMACRO



.MACRO xdelay ;max is 65536µs*FREQ_REG/FREQ_ACT
    ldi rDelH,HIGH((@0*_FREQ_ACT)/_FREQ_REG);
    ldi rDelL,LOW((@0*_FREQ_ACT)/_FREQ_REG);
    rcall DelayZ;
.ENDMACRO



;====================================================================================================================
;                                                  SRAM definitions
;====================================================================================================================
.DSEG
.ORG Sram_Start
sField : .BYTE 1; field number
sFrame : .BYTE 1; frame sync
sFlag1 : .BYTE 1; sync flag for field extraction
sFlag2 : .BYTE 1; sync flag for timing generator synchronization
sState : .BYTE 1; timing machine state 
sMono  : .BYTE 1; 40µS monostable flag
sDetect: .BYTE 1;

;
.ESEG
.ORG $0000



;====================================================================================================================
;                               Reset and Interrupt Vectors starting here
;====================================================================================================================
;
.CSEG
.ORG $0000
;
; Reset/Interrupt vectors
;
  rjmp RESET ; Reset
  rjmp INT_0;reti ; INT_0;
  reti ; PCINT;
  reti ; TIMER1_COMPA; Timer/Counter1 Compare Match A
  reti ; TIMER1_OVF
  reti ; TIMER0_OVF;
  reti ; EE_RDY EEPROM; Ready
  reti ; ANA_COMP; Analog Comparator
  reti ; ADC_INT; ADC Conversion Complete
  rjmp TIMER1_COMPB;reti ; TIMER1_COMPB; Timer/Counter1 Compare Match B
  rjmp TIMER0_COMPA;reti ; TIMER0_COMPA;Timer/Counter0 Compare Match A
  reti ; TIMER0_COMPB; Timer/Counter0 Compare Match B
  reti ; WDT; Watchdog Time-out
  reti ; USI_START; USI START
  reti ; USI_OVF;
  
;
;====================================================================================================================
;                                     Interrupt Service Routines
;====================================================================================================================
  
  INT_0:;external sync proccessing
    xpush01;
    ldi rmp0,12;
    out TCNT1,rmp0;
    lds rmp0,sMono; output of 40µS monostable
    lds rmp1,sFlag1; 
    sbrs rmp1,_SYNC_IN; skip next instruction if falling edge of vsync
  rjmp set_mono;
    sbi PORTB,_SYNC_SW; switch on incomming video
    and rmp1,rmp0;
    sts sField,rmp1; set field according to monostable output
    sts sFlag2,rmp1; flag for timing generator resync ,1 if rising edge of field 
    clr rmp1;
    sts sFlag1,rmp1; erase resync flag
  set_mono:  
    sbrs rmp0,0; skip if monostable still active, this removes equalizing pulses
    com rmp0;
    sts sMono,rmp0;
    ldi rmp0,_GTCCR1; activate 10µS monostable
    out GTCCR,rmp0;
    clr rmp0;
    out TCNT0,rmp0; clear counter
    ldi rmp0,1<< OCF0A;
    out TIFR,rmp0;
    ldi rmp0,_TCCR0B1;
    out TCCR0B ,rmp0; start counting
    ldi rmp0,_GTCCR0;
    out GTCCR,rmp0;
    ldi rmp0,0x7;
    sts sDetect,rmp0; to detect loss of vidéo
    xpop01;
  reti;
   
  
  TIMER0_COMPA:; monostable 10µs to detect Vsync
    xpush01;
    ldi rmp0,_TCCR0B0;
    out TCCR0B,rmp0; stop counting
    in rmp0,PINB;
    andi rmp0,1<<_SYNC_IN; check state of _SYNC_IN when monostable elapse if 0 then Vsync occurs
  brne set_frame; not frame sync
    lds rmp1,sFrame;
    tst rmp1;
  breq set_frame; already in frame sync
    eor rmp1,rmp0; detect falling edge
    sts sFlag1,rmp1; set flag for resync on next sync pulse
  set_frame:  
    sts sFrame,rmp0;memorize state of Vsync
    xpop01;
  reti;
  
  TIMER1_COMPB: 
    xpush012;                                     
    sei; reactivate interrupt to maintain stable timing 
    lds rmp0,sFlag2; test resync flag
    tst rmp0;
  breq no_sync;
    ldi rmp0,_TCCR10; reactivate OC1A output                         
    out TCCR1,rmp0;                               
    ldi rmp1,_OCR1A0;
    out OCR1A,rmp1; update pulse size             
    ;ldi rmp1,_VAL_SYNC;
    ;out TCNT1,rmp1; update timer counter                 
    ldi rmp0,0;
    sts sFlag2,rmp0; erase flag
    ldi XL,2;  update half line counter                                   
    clr XH;                                       
  rjmp no_change;
  no_sync:
    lds rmp0,sState;  get state of timing generator                             
    ldi ZL,LOW(2*tab_line);  base address of timing parameters table                     
    ldi ZH,HIGH(2*tab_line);                      
    mov rmp1,rmp0;                                
    lsl rmp1;                                     
    lsl rmp1; 2 words by entry                    
    clr rmp2;                                     
    add ZL,rmp1;                                  
    adc ZH,rmp2;                                  
    lpm rmp1,Z+;  read current boundary                                
    lpm rmp2,Z+;                                  
    cp XL,rmp1;                                   
    cpc XH,rmp2;                                  
  brlo no_change; boundary not reached                                    
    lpm rmp1,Z+;  read next pulse size                                
    out OCR1A,rmp1; update pulse size             
    inc rmp0; update state                                    
    andi rmp0,7; limit to 7                                 
  brne no_change;                                 
    clr XL; end of picture reinit counter         
    clr XH;                                       
  no_change:
    sts sState,rmp0;                              
    cpi rmp0,2;                                   
  breq switch; first field active video period ,supress one pulse out of two                                   
    cpi rmp0,6;                                   
  breq switch; second field active video period , supress one pulse out of two                                     
    cpi rmp0,3;                                   
  breq switch1;                                   
  rjmp update_line;                               
  switch:
    sbrc XL,0;                                    
    ldi rmp0,_TCCR11; off                         
    sbrs XL,0;                                    
  switch1:  
    ldi rmp0,_TCCR10; on                          
    out TCCR1,rmp0;                               
  update_line:                                    
    adiw XH:XL,1;  update line count
    ;cli; mask interrupt to avoid contention on access
    lds rmp0,sDetect;
    lsr rmp0; shift right value <=> count down 
    sts sDetect,rmp0;
    sbrs rmp0,0;
    cbi PORTB,_SYNC_SW; switch on internal sync
    xpop012;                                      
  reti;
;===================================================================================================================
;                                   Delays execution for 1 microseconds @ 8MHz
;===================================================================================================================
  DelayZ:
    nop;1
    nop;1
    nop;1
    nop;1
    sbiw rDelL,1 ; 2
    brne DelayZ ; 1/2
  ret;
  
  
;===================================================================================================================
; Main Program Start
;===================================================================================================================

RESET:
    ; init ports
    ldi rmp0,_PORTB;
    out PORTB,rmp0;
    ldi rmp0,_DDRB;
    out DDRB,rmp0;
    ; set stack pointer
    ldi ZH,HIGH(RAMEND);
    out SPH,ZH;
    ldi ZL,LOW(RAMEND);
    out SPL,ZL;

    ; init whole memory to zero
    ldi YH,HIGH(SRAM_START); Y point ram location
    ldi YL,LOW(SRAM_START);
    ldi rmp0,0;
  init_ram:
    st Y+,rmp0
    cp YL,ZL;
    cpc YH,ZH;
  brne init_ram;
    ldi XL,1; init line counter
    clr XH;
 
    ;init Timer0
    ldi rmp0,_TCCR0A; 
    out TCCR0A,rmp0;
    ldi rmp0,_TCCR0B0;
    out TCCR0B,rmp0;
    ldi rmp0,_OCR0A;
    out OCR0A,rmp0;
    ldi rmp0,_OCR0B;
    out OCR0B,rmp0;
    
    ;init Timer1
    ldi rmp0,_TCCR10; active
    out TCCR1,rmp0;
    ldi rmp0,_OCR1A0; equalizing pulse wide
    out OCR1A,rmp0;
    ldi rmp0,_OCR1B;
    out OCR1B,rmp0;
    ldi rmp0,_OCR1C;
    out OCR1C,rmp0;
    
  ;common
    ldi rmp0,_GTCCR0;
    out GTCCR,rmp0;
  
   ;init interrupts
    ldi rmp0,_TIFR;
    out TIFR,rmp0;
    ldi rmp0,_TIMSK;
    out TIMSK,rmp0;
    ldi rmp0,_MCUCR;
    out MCUCR,rmp0;
    ldi rmp0,_GIMSK;
    out GIMSK,rmp0;
    ldi rmp0,_GIFR;
    out GIFR,rmp0;
    
  ; enable interrupt 
    sei;
  ; Here is the infinite loop
  loop_main:
    lds rmp0,sMono;
    sbrs rmp0,0;
  rjmp loop_main;
    xdelay 40
    clr rmp0;
    sts sMono,rmp0;
  rjmp loop_main;
  ; tab_line is the timing parameters table, two values by state: first one is line count limit for current state,second is next state pulse width
  ;.DW 5,_OCR1A1,10,_OCR1A2,_NB_LINE-5,_OCR1A1 ,_NB_LINE,_OCR1A0,_NB_LINE+5,_OCR1A1,_NB_LINE+10,_OCR1A2,_NB_LINE*2-5,_OCR1A1 ,_NB_LINE*2,_OCR1A0;
  tab_line:
  ;state 0 = first field Vsync
  .DW 5,_OCR1A1;
  ;state 1 = first field post equalization
  .DW 10,_OCR1A2;
  ;state 2 = first field active video  
  .DW _NB_LINE-5,_OCR1A1;
  ;state 3 = second field pre equalization
  .DW _NB_LINE,_OCR1A0;
  ;state 4 = second field Vsync
  .DW _NB_LINE+5,_OCR1A1;
  ;state 5 = second field post equalization
  .DW _NB_LINE+10,_OCR1A2;
  ;state 6 = second field active video
  .DW _NB_LINE*2-5,_OCR1A1;
  ;state 7 = second field pre equalization
  .DW _NB_LINE*2,_OCR1A0;
; End of source code
