;***********************************************************************************************

    Errorlevel-302                        ; Supprime le message "Ensure that bank bits are correct" 

    LIST      p=16F84            
    #include <p16F84.inc>        

    radix dec                             ; par defaut en mode dcimal

;***********************************************************************************************

    __CONFIG   _CP_OFF & _WDT_OFF & _PWRTE_ON & _HS_OSC

;*************************************** assignations ***************************************** 

#DEFINE   segment             PORTB       ; PORTB les 8 segments des afficheurs

#DEFINE   anode1              PORTA,0     ; c'est le premier qui se trouve  gauche
#DEFINE   anode2              PORTA,1     ; c'est le premier qui se trouve  droite

;********************************* "dclaration des variables" *********************************

    CBLOCK 0x0C                           ; dbut de la ram en banque 1 soit 68 octets

      loop1         :1                    ; variable temporaire
      loop2         :1                    ; variable temporaire
      loop3         :1                    ; variable temporaire
      loop4         :1                    ; variable temporaire
      loop5         :1                    ; variable temporaire

      afficheur1    :1                    ; c'est le premier qui se trouve  gauche
      afficheur2    :1                    ; c'est le premier qui se trouve  droite

    ENDC

;********************************** "dclaration des macros" ***********************************



;******************************* "adresse de depart aprs reset" *******************************
    ORG H'00'
      goto debut

    ORG H'04'                              ; interruption haute priorit

      retfie 
;******************************** "configuration des registre" ********************************* 
debut

      BANKSEL OPTION_REG                  ; passer en bank 1 

      movlw B'10000000'                   ; b7 = 1 rsistances hors service 
      movwf OPTION_REG                    ; 

;*********************************** configuration de INTCON ***********************************   
  
      bcf INTCON,GIE                      ; on interdit toutes les interruptions         
      
;******************** "configuration du PORTA & PORTB pour le mode horloge" ******************** 
dmarrage

      BANKSEL TRISB                       ; passer en bank 1  

      movlw B'00000000'                   ; en sortie 
      movwf TRISB                         ; 6(RB0), 7(RB1), 8(RB2), 9(RB3), 10(RB4), 11(RB5), 12(RB6), 13(RB7)   

      movlw B'00000100'                   ; 
      movwf TRISA                         ; 17(RA0),18(RA1),1(RA2),2(RA3),3(RA4)                        

      BANKSEL PORTA                       ; passer en bank 0 
 
      clrf PORTA
      clrf PORTB  

;*********************************************************************************************

      call _500ms    

;********************************************************************************************** 

     clrf afficheur1
     clrf afficheur2     

boucle
     call affiche   
   
     btfsc PORTA,2
     goto boucle
     btfss PORTA,2
     goto $-D'1'
 
     call _10ms                           ; anti rebond

     incf afficheur2,F

     movf afficheur2,W
     xorlw D'10'
     btfss STATUS,Z     
     goto boucle
 
     clrf afficheur2
     incf afficheur1,F

     movf afficheur1,W
     xorlw D'10'
     btfss STATUS,Z
     goto boucle
   
     clrf afficheur1

     goto boucle


;********************************* "gestion de l'affichage" *********************************** 
affiche                                                       

      movlw D'3'                          ; page 4, tableaux de 256 octets.
      movwf PCLATH                        

;-----------------------------------------------------------------------------------------------

      movf afficheur1,W  
      call deco_bcd                      
      movwf segment                                 
       
  
      bcf anode1                          ; allumage anode1
      bsf anode2                          ; teindre anode2

      call _10ms
      call _10ms
      call _10ms
      call _10ms
      call _10ms

;-----------------------------------------------------------------------------------------------

      movf afficheur2,W  
      call deco_bcd                      
      movwf segment                                      

      bsf anode1                          ; teindre anode1  
      bcf anode2                          ; allumage anode2

      call _10ms
      call _10ms
      call _10ms
      call _10ms
      call _10ms

;-----------------------------------------------------------------------------------------------

      ; bcf anode1                          ; teindre anode1  
      ; bcf anode2                          ; teindre anode2  

      ; call _10ms
      ; call _10ms

      return

;***************** "pause de 500 millisecondes pour 16F avec horloge de 4 Mhz" ******************
_500ms
      movlw D'85'
      movwf loop1

      movlw D'138'
      movwf loop2

      movlw D'3'
      movwf loop3

      decfsz loop1,F
      goto $-D'1'
      decfsz loop2,F
      goto $-D'3'
      decfsz loop3,F
      goto $-D'5'

      return

;***************** "pause de 100 millisecondes pour 16F avec horloge de 4 Mhz" ******************
_100ms
      movlw D'221'
      movwf loop1

      movlw D'130'
      movwf loop2

      decfsz loop1,F
      goto $-D'1'
      decfsz loop2,F
      goto $-D'3'

      return

;***************** "pause de 10 millisecondes pour 16F avec horloge de 4 Mhz" ******************
_10ms
      movlw D'251'
      movwf loop1

      movlw D'13'
      movwf loop2

      decfsz loop1,F
      goto $-D'1'
      decfsz loop2,F
      goto $-D'3'

      return

;********************************************************************************************** 
_270s                               
      movlw D'90'                          ; 
      movwf loop1                          ; 
                                             
      decfsz loop1,F                       ; 
      goto $-D'1'                          ; 

      return    
                 

;***********************************************************************************************
    ORG H'300'

deco_bcd
        addwf PCL,1                       ;   

        retlw   B'00111111'               ; 0 = 0   
        retlw   B'00000110'               ; 1 = 1   
        retlw   B'01011011'               ; 2 = 2   
        retlw   B'01001111'               ; 3 = 3 
        retlw   B'01100110'               ; 4 = 4   
        retlw   B'01101101'               ; 5 = 5   
        retlw   B'01111101'               ; 6 = 6   
        retlw   B'00100111'               ; 7 = 7   
        retlw   B'01111111'               ; 8 = 8   
        retlw   B'01101111'               ; 9 = 9   
                          
    End