import sys
import os
import math
import numpy as np
import matplotlib.pyplot as plt
import matplotlib
import glob
from scipy.optimize import curve_fit
import pandas as pd
from sklearn.linear_model import LinearRegression
from sklearn.metrics import r2_score					#pour calculer le coeff R2

#def lister_fichiers_par_extension(repertoire, extension):
#    for racine, repertoires, fichiers in os.walk(repertoire):
#        for fichier in fichiers:
#            if fichier.endswith(extension):
#                print(os.path.join(racine, fichier))
 
# lister_fichiers_par_extension('/chemin/vers/votre/répertoire', '.txt')

# Lister tous les fichiers .txt du répertoire courant
fichiers_txt = glob.glob("*.txt")
print(fichiers_txt)

nom_fichier = input ( "fichier à analyser : [.txt] " ) 

#nom_fichier = '2N2222'
extension =  '.txt'
nom=nom_fichier + extension

# Ouvrir le fichier en lecture seule
with open(nom, "r") as file:
    line = file.readline()              # lire la premiere ligne (nom des axes x et y affichés)
file.close()

line2 = line.strip()                    # supprimer cr + lf
line3 = line2.split('\t')               # séparateur = chr(9) (tabulation)
xy = tuple(line3)                       # coordonnées sous forme de tableau x y
xx=xy[0]
yy=xy[1]
axex = xx
axey = yy
print (xx)
print (yy)

# Ouvrir le fichier en lecture seule, mini et maxi de x et y
yMaxTemp = 0
yMinTemp = 1e6
xMaxTemp = 0
xMinTemp = 1e6

with open(nom, "r") as file:
    line = file.readline()                  # sauter la premiere ligne
    line = file.readline()                  # lire toute la suite
    while line :
        line2 = line.strip()                # supprimer espaces et cr + lf en fin de ligne
        line3 = line2.split('\t')           # séparateur = chr(9) (tabulation) dans le fichier .asc
        xy = tuple(line3)                   # coordonnées sous forme de tableau x [sép] y
        x=float(xy[0])                      # 1er data
        y=float(xy[1])                      # 2eme data
        #print (y)
        if y > yMaxTemp:
            yMaxTemp = y
        if y < yMinTemp:
            yMinTemp = y

        if x > xMaxTemp:
            xMaxTemp = x
        if x < xMinTemp:
            xMinTemp = x
            
        line = file.readline()              # lire jusqu'au bout du fichier
file.close()

print("------------- x et y maxi dans le fichier = -----------------------")
print ("y maxi = ",yMaxTemp)
print ("y mini = ",yMinTemp)

print ("x maxi = ",xMaxTemp)
print ("x mini = ",xMinTemp)

print("------------------------------------")
# le fichier contient les colonnes V2 et Ic(Q1) par exemple
data = pd.read_csv(nom, sep = '\t')      # chr(9) dans le texte généré par LtSpice
data.shape
data.dtypes
data.info()
data.describe()
print("------------------------------------")

def funcLin(y, a, b, c):
    x = a + b * np.log(y) + c * y
    return x

def funcNonLin(y, a, b, c, n):
    x = a + b * np.log(y) + c * y**n
    return x
    
def calcul(y, a, b, c):
    produit = a + b * np.log(y) + c * y
    return produit
    
def calcul2(y, a, b, c, n):
    produit2 = a + b * np.log(y) + c * y**n
    return produit2

# Define the Gaussian function
def Gauss(x, A, B):
    y = A * np.exp(-1 * B * x**2)
    return y

def cos_func(x, D, E):
    y = D * np.cos(E * x)
    return y
    
# erreur dans l'equation par rapport aux données, pertinence de la fonction utilisée ici
#parameters, covariance = curve_fit(Gauss, x, y)
#fit_A = parameters[0]
#fit_B = parameters[1]
#print(fit_A)
#print(fit_B)

#SE = np.sqrt(np.diag(covariance))
#SE_A1 = SE[0]
#SE_B1 = SE[1]

# état des constantes A et B
#print(F'The value of A is {fit_A:.5f} with standard error of {SE_A1:.5f}.')
#print(F'The value of B is {fit_B:.5f} with standard error of {SE_B1:.5f}.')

#fit_y = Gauss(x, fit_A, fit_B)
#plt.plot(x, y, 'o', label='data')
#plt.plot(x, fit_y, '-', label='fit')
#plt.legend()
# bon, bein vu la gueule de la courbe, ce n'est pas une gaussienne...
print("------------------------------------")


#z = np.log(x*1000)     # si Ic est écrit en mA dans les datas lus
#print(z)
#---------------------------------------------------------------------------------------------------
# preparer le fichier de sauvegarde
aecriretxt = nom_fichier + "_out.txt"
fich = open(aecriretxt, "w")


#fig = plt.figure(figsize=(13, 9), tight_layout=True)				# x = 13 pouces y = 9 pouces
fig, ax1 = plt.subplots(facecolor='lightblue', figsize=(13, 9), tight_layout=True)
ax1.set_facecolor("orange")



plt.suptitle(nom_fichier + " fonction de Vbe")
plt.title("$x = a + b*Ln(y) + c*y^{n}$")

#color couleur de la courbe ‘b’, ‘g’, ‘r’, ‘c’, ‘m’, ‘y’, ‘k’, ‘w’


#--------------------------------------------------
#                                           affichage des datas lus
# permet de placer les données du fichier .txt dont les séparateurs sont des tabulations dans une variable de type dataframe

#Extraction des colonnes du tableau
x = data[xx] 				# Extraction de la colonne dont le nom dans le tableau est Vbe
y = data[yy] 			    # Extraction de la colonne dont le nom dans le tableau est Ic
plt.semilogy(x, y, 'k.', label='datas x y')

#                                           affichage dess courbes de fonctions
try:
    initial_params = [1, 1, 1]
# Ajuster la fonction aux données
    popt, pcov = curve_fit(funcLin, y, x, p0=initial_params)
# Afficher les paramètres ajustés
    print("Paramètres ajustés: ", popt, pcov)
# affichage y log et x lineaire
#    plt.errorbar(x, y, xerr=incertitude, yerr=incertitude, label="Mesures", linestyle="None")
    plt.semilogy(funcLin(y, *popt), y, 'b--', label='y = a=%.9f, b=%.9f, c=%.9f' % tuple(popt))
    print("a: %s , b: %s , c: %s" % tuple(popt))
    SE = np.sqrt(np.diag(pcov))
    SE_A2 = SE[0]
    SE_B2 = SE[1]
    SE_C2 = SE[2]
    fit_A = popt[0]
    fit_B = popt[1]
    fit_C = popt[2]
# état des constantes a, b et c
    print(F'The value of A is {fit_A:.5f} with standard error of {SE_A2:.5f}.')
    print(F'The value of B is {fit_B:.5f} with standard error of {SE_B2:.5f}.')
    print(F'The value of C is {fit_C:.5f} with standard error of {SE_C2:.5f}.')
    
# verif pour une seule valeur de y et sauvegarde pour controle
    a,b,c = tuple(popt)
    yy = 10e-3       #yMaxTemp / 20
    produit = calcul(yy, a, b, c)    
    fich.write("quand y={:.12f}, x={:.12f} V \n" .format(yy, produit))
    fich.write("a = {:.12f} : b = {:.12f} : c = {:.12f}\n" .format(a,b,c))
    fich.write("x = a + b * Log(y) + c * y \n\n")
    plt.semilogy(produit, yy, 'bo')
#    plt.semilogy(0.8, 15e-3, 'b+')                     # OK
    print("------------------------------------")
#--------------------------------------------------



    initial_params2 = [1, 1, 1, 1]
# Ajuster la fonction aux données
    popt2, pcov2 = curve_fit(funcNonLin, y, x, p0=initial_params2)
# Afficher les paramètres ajustés
    print("Paramètres ajustés: ", popt2, pcov2)
    plt.semilogy(funcNonLin(y, *popt2), y, 'r--', label='y = a=%.9f, b=%.9f, c=%.9f, n=%.9f' % tuple(popt2))
    print("a: %s , b: %s , c: %s , n: %s" % tuple(popt2))
#Standart Error
    SE = np.sqrt(np.diag(pcov2))
    SE_A3 = SE[0]
    SE_B3 = SE[1]
    SE_C3 = SE[2]
    SE_N3 = SE[3]
    fit_A = popt2[0]
    fit_B = popt2[1]
    fit_C = popt2[2]
    fit_N = popt2[3]
# état des constantes a, b, c, n
    print(F'The value of A is {fit_A:.5f} with standard error of {SE_A3:.5f}.')
    print(F'The value of B is {fit_B:.5f} with standard error of {SE_B3:.5f}.')
    print(F'The value of C is {fit_C:.5f} with standard error of {SE_C3:.5f}.')
    print(F'The value of n is {fit_N:.5f} with standard error of {SE_N3:.5f}.')
# verif pour une seule valeur de y et sauvegarde pour controle
    a,b,c,n = tuple(popt2)
    yyy = 1e-3 # yMaxTemp / 10
    produit2 = calcul2(yyy, a, b, c, n)    
    fich.write("quand y={:.12f}, x={:.12f} V. \n" .format(yyy, produit2))
    fich.write("a = {:.12f} : b = {:.12f} : c = {:.12f} : n = {:.12f}\n" .format(a,b,c,n))
    fich.write("x = a + b * Log(y) + c * y^n \n\n")
    plt.semilogy(produit2, yyy, 'bo')
except Exception as e:
    print ("-------------------------------  Erreur : ", e)           # yyy ne correspond pas à une valeur attendue

#---------------------------------------------------------------------------------------------------
print("------------- polynome -----------------------")
degre = 10
P = np.poly1d(np.polyfit(x, y, degre))			# regression polynomiale degré n
print(P)

u = np.linspace(xMinTemp, xMaxTemp, 100)             # x, y, Nombre points calculés et affichés dans la plage x = 0.5 à 1 Volt
plt.plot(u, P(u), 'g--', label='Polynome degré %s' %(degre))
print("u : ",u)
print("P(u) : ", P(u))

#P est une liste des valeurs a, b et c du polynome ax**2 + bx + c = 0
monmodele = np.poly1d(P)
R2 = r2_score(y, monmodele(x))

# sur le graphe
plt.text(xMinTemp, yMaxTemp * 0.8,'Regression polynomiale degré %s' %(degre))
#plt.text(0.505, 0.05, r'$P= %.2F * x^{10} + %.2F * x^9 + %.2F * x^8 + %.2F * x^7 + %.2F * x^6 + %.2F * x^5 + %.2F * x^4 + %.2F * x^3 + %.2F * x^2 + %.2F * x + %.2F$' %tuple(P))
plt.text(xMinTemp, yMaxTemp * 0.6, r"$R^{2}=%.9f$" %(R2))

# dans le fichier de sauvegarde
fich.write('y = f(Vbe)\n')

#dummy = tuple(P)
#dummy[0].replace("+ -", "-")

fich.write('y = %.9F * x^10 + %.9F * x^9 + %.9F * x^8 + %.9F * x^7 + %.9f * x^6 + %.9f * x^5 + %.9f * x^4 + %.9f * x^3 + %.9f * x^2 + %.9f * x + %.9f\n' %tuple(P))
fich.write("\nR2 = {:.9f}\n".format(R2))

# dans la console dos
print("R2 : {:.9f}".format(R2))

fich.close()
#---------------------------------------------------------------------------------------------------

matplotlib.rcParams['legend.fontsize'] = 14
plt.rcParams['font.weight'] = 'bold'        # 'normal'
plt.rcParams['font.style'] = 'italic'
plt.rcParams['font.size'] = 8
plt.rcParams['font.family'] = 'sans-serif'


plt.locator_params(axis='x', nbins=10)              # 10 divisions sur l'axe des X
plt.xlabel(axex)
plt.ylabel(axey)
plt.legend()
# axes autoajustés
# ax.xticks(range(0.5, 1.0))
plt.axis([xMinTemp, xMaxTemp, yMinTemp*0.8, yMaxTemp/0.8])  # x1, x2   ,y1, y2

plt.minorticks_on()

plt.xticks(fontsize=12, color='blue', rotation=45)
plt.grid(True, which='minor', linewidth=0.3, color='red', alpha=0.5, linestyle='--')
plt.grid(True, color='black', alpha=0.7)

ax2 = ax1.twinx()
# Plot the second dataset on the right y-axis
ax2.plot(x, y, color='red', label='Exp(x)')
ax2.set_ylabel(axey, color='red')
ax2.tick_params('y', colors='red')

plt.show()

# sauvegarde du graphe au format .JPG
sauve = nom_fichier + ".jpg"
fig.savefig(sauve, dpi=100)
fig.savefig(nom_fichier + ".pdf")
 
#os.system("pause")