;*****************************************************************************
;   Ce fichier est la base de dpart pour une programmation avec             *
;   le PIC 16F628A. Il contient  les informations de  base pour              *
;   dmarrer.                                                                *  
;   ecrit grace  Bigonoff par gilles.chevalerias@Ifrance.com                *
;*****************************************************************************
;                                                                            *
;    NOM: led_clign16f628A.asm                                               *
;    Date:                                                                   *
;    Version:  1                                                             *
;    Circuit:                                                                *
;    Auteur:                                                                 *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    Fichier requis: P16F628A.inc                                            *
;                                                                            *
;                                                                            *
;                                                                            *
;*****************************************************************************
;                                                                            *
;    Notes:                                                                  *
;    faire clignoter une led toutes les 500mS sur RA0                        *
;                                                                            *
;                                                                            *
;                                                                            *
;*****************************************************************************

	ERRORLEVEL -302		      ; suppression du message bank select 
	LIST      p=16F628A           ; Dfinition de processeur
	#include <p16F628A.inc>       ; fichier include

	__CONFIG   _CP_OFF & _DATA_CP_OFF & _LVP_OFF & _BODEN_OFF & _BOREN_OFF & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT 

; '__CONFIG' prcise les paramtres encods dans le processeur au moment de
; la programmation du processeur. Les dfinitions sont dans le fichier include.
; Choisir une valeur par groupe.
; Voici les valeurs et leurs dfinitions :

; Protection du programme
; -----------------------
;_CP_ON		protection totale
;_CP_OFF	Pas de protection


; Protection de l'EEprom
; ----------------------

;_DATA_CP_ON		Mmoire EEprom protge
;_DATA_CP_OFF		Mmoire EEprom dprotge

; Programmation sur circuit
; -------------------------

;_LVP_ON		RB3 permet la programmation srie de la PIC
;
;_LVP_OFF		RB3 en utilisation normale

; Reset du pic si Vdd <Vbor(4V) pendant Tbor (100s)
; --------------------------------------------------
;_BOREN_ON		Boren est activ
;
;_BOREN_OFF		Boren est dsactiv

; Reset du PIC si tension <4V
; ----------------------------
; _BODEN_ON		Reset tension en service
;			Valide PWRTE_ON automatiquement
; _BODEN_OFF		Reset tension hors service

;Utilisation de la pin MCLR
; -------------------------
;_MCLRE_ON		RA5/MCLR est utilise pour le reset
;
;_MCLRE_OFF		RA5/MCLR est utilise comme une entree/sortie

; Retard  la mise sous tension
; -----------------------------

;_PWRTE_OFF		Dmarrage rapide
;_PWRTE_ON		Dmarrage temporis

; Watchdog
; --------

;_WDT_ON		Watchdog en service
;_WDT_OFF		Watchdog hors service

; Oscillateur
; -----------
;_ER_OSC_CLKOUT 	clckout sur RA6 resistance externe surRA7 *             
;_ER_OSC_NOCLKOUT	I/O sur RA6 resistance externe sur RA7 *
;			(1K*10MHz-20K*5.3MHz-100k*1.6MHz-220k*800KHz-1M*200KHz)   
;_INTRC_OSC_CLKOUT	oscillateur interne clkout sur RA6 I/O sur RA7 (4MHz**)    
;_INTRC_OSC_NOCLKOUT	oscillateur interne I/O sur RA6 et RA7 (4MHz**)        
;_EXTCLK_OSC		signal clock fournit au pic sur RA7, I/O sur RA6                
;_LP_OSC 		Oscillateur basse vitesse (?<F<200Khz)        
;_XT_OSC                Oscilateur moyenne vitesse (0,1MHz<F<4Mhz)     
;_HS_OSC 		Oscillateur haute vitesse (1Mhz<F<20Mhz)

; note
;* avec le bit PCON,OSCF =1, frequence osc interne=4MHz,valeur par defaut au dmarrage 
;** si le bit PCON,OSCF =0, frequence osc interne=48KHz
;*****************************************************************************
;                               ASSIGNATIONS SYSTEME                         *
;*****************************************************************************

; REGISTRE OPTION_REG (configuration)
; -----------------------------------
OPTIONVAL	EQU	B'00000000'
			; RBPU      b7 : 1= Rsistance rappel +5V hors service
			; INTEDG    b6 : 1= Interrupt sur front montant de RB0
			;                0= Interrupt sur front descendant de RB0
			; TOCS      b5 : 1= source clock = transition sur RA4
			;                0= horloge interne
			; TOSE      b4 : 1= Slection front descendant RA4(si B5=1)
			;                0= Slection front montant RA4
			; PSA       b3 : 1= Assignation prdiviseur sur Watchdog
			;                0= Assignation prdiviseur sur Tmr0
			; PS2/PS0   b2/b0 valeur du prdiviseur
                        ;           000 =  1/1 (watchdog) ou 1/2 (tmr0)
			;           001 =  1/2               1/4
			;           010 =  1/4		     1/8
			;           011 =  1/8		     1/16
			;           100 =  1/16		     1/32
			;           101 =  1/32		     1/64
			;           110 =  1/64		     1/128
			;           111 =  1/128	     1/256


; REGISTRE INTCON (contrle interruptions standard)
; -------------------------------------------------
INTCONVAL	EQU	B'00000000'
			; GIE       b7 : masque autorisation gnrale interrupt
                        ;                ne pas mettre ce bit  1 ici
                        ;                sera mis en temps utile
			; PEIE      b6 : masque autorisation gnrale priphriques
			; T0IE      b5 : masque interruption tmr0
			; INTE      b4 : masque interuption RB0/Int
			; RBIE      b3 : masque interruption RB4/RB7
			; T0IF      b2 : flag tmr0
			; INTF      b1 : flag RB0/Int
			; RBIF      b0 : flag interruption RB4/RB7

; REGISTRE PIE1 (contrle interruptions priphriques)
; ----------------------------------------------------
PIE1VAL		EQU	B'00000000'
			; EEIE      b7 : masque interrupt criture EEPROM
			; CMIE      b6 : masque interrupt comparateur
			; RCIE      b5 : masque interrupt rception USART
			; TXIE      b4 : masque interrupt transmission USART
			; RESERVED  b3 : rserv, laisser  0
			; CCP1IE    b2 : masque interrupt CCP1
			; TMR2IE    b1 : masque interrupt TMR2 = PR2
			; TMR1IE    b0 : masque interrupt dbordement tmr1


; REGISTRE CMCON (COMPARATEURS)
; ------------------------------------
CMCONVAL	EQU	B'00000111' 
			; C2OUT	    b7 :sortie comparateur2
			; C1OUT     b6 :sortie comparateur1
			; C2INV     b5 :inverseur comparateur2
			; C1INV     b4 :inverseur comparateur1
			; CIS       b3 :selection entree des comparateurs
			; CM2-CM0   b2-0 :mode des comparateurs
			;configurer le mode 111 pour utiliser RA0 RA1 RA2 RA3 en I/O

; REGISTRE VRCON (voltage reference module)
; ------------------------------------
VRCONVAL	EQU	B'00000000'
			; VREN      b7 :Validation du module
			; VROE      b6 :Sortie sur RA2
			; VRR       b5 :Choix de la plage 
			; RESERVED  b4 : rserv, laisser  0
			; VR3-VR0   b3-0 :Choix de la valeur dans la plage 
					; si VRR=1 VREF=(VR[3:0]/24)*Vdd
					; si VRR=0 VREF=Vdd/4(VR[3:0]/32)*Vdd

; DIRECTION DES PORTS I/O
; -----------------------

DIRPORTA	EQU	B'11111110'	; Direction PORTA (1=entre)
DIRPORTB	EQU	B'11111111'	; Direction PORTB


;*****************************************************************************
;                           ASSIGNATIONS PROGRAMME                           *
;*****************************************************************************

; exemple
; -------
;MASQUE		EQU	H'00FF'


;*****************************************************************************
;                                  DEFINE                                    *
;*****************************************************************************


#DEFINE LED1	PORTA,0			; LED de sortie 0 dur PORTA

;*****************************************************************************
;                             MACRO                                          *
;*****************************************************************************

			; Changement de banques
			; ----------------------

BANK0	macro				; passer en banque0
		bcf	STATUS,RP0
		bcf	STATUS,RP1
	endm

BANK1	macro				; passer en banque1
		bsf	STATUS,RP0
		bcf	STATUS,RP1
	endm

BANK2	macro				; passer en banque2
		bcf	STATUS,RP0
		bsf	STATUS,RP1
	endm

BANK3	macro				; passer en banque3
		bsf	STATUS,RP0
		bsf	STATUS,RP1
	endm


	



;*****************************************************************************
;                      VARIABLES ZONE COMMUNE                                *
;*****************************************************************************

; Zone de 16 bytes
; ----------------

	CBLOCK 0x70			; Dbut de la zone (0x70  0x7F)
	w_temp : 1			; Sauvegarde registre W
	status_temp : 1			; sauvegarde registre STATUS
	PDel0 : 1			; 2 variables pour la tempo
	PDel1 : 1
	ENDC

;*****************************************************************************
;                        VARIABLES BANQUE 0                                  *
;*****************************************************************************

; Zone de 80 bytes
; ----------------

	CBLOCK	0x20			; Dbut de la zone (0x20  0x6F)

;Exemples
;--------
	;test :1				; Zone de 1 byte
	;table : 10			; zone de 10 bytes

        ENDC				; Fin de la zone                        

;var1 	EQU H'006E'			; adresse impose


;*****************************************************************************
;                        VARIABLES BANQUE 1                                  *
;*****************************************************************************

; Zone de 80 bytes
; ----------------

	CBLOCK	0xA0			; Dbut de la zone (0xA0  0xEF)

	ENDC				; Fin de la zone                        

;*****************************************************************************
;                        VARIABLES BANQUE 2                                  *
;*****************************************************************************

; Zone de 48 bytes
; ----------------

	CBLOCK	0x120			; Dbut de la zone (0x120  0x14F)

	ENDC				; Fin de la zone                        

       

;*****************************************************************************
;                      DEMARRAGE SUR RESET                                   *
;*****************************************************************************

	org 0x000 			; Adresse de dpart aprs reset
  	goto    init			; Initialiser

; ////////////////////////////////////////////////////////////////////////////

;                         I N T E R R U P T I O N S

; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                     ROUTINE INTERRUPTION                                   *
;*****************************************************************************
;-----------------------------------------------------------------------------
; Si on n'utilise pas l'adressage indirect dans les interrupts, on se passera
; de sauvegarder FSR
;-----------------------------------------------------------------------------
			;sauvegarder registres	
			;---------------------
	org 0x004			; adresse d'interruption
	movwf   w_temp  		; sauver registre W
	swapf	STATUS,w		; swap status avec rsultat dans w
	movwf	status_temp		; sauver status swapp
	BANK0				; passer en banque0

			;restaurer registres
			;-------------------
restorereg
	swapf	status_temp,w		; swap ancien status, rsultat dans w
	movwf   STATUS			; restaurer status
	swapf   w_temp,f		; Inversion L et H de l'ancien W
                       			; sans modifier Z
	swapf   w_temp,w  		; Rinversion de L et H dans W
					; W restaur sans modifier status
	retfie  			; return from interrupt


; ////////////////////////////////////////////////////////////////////////////

;                           P R O G R A M M E

; ////////////////////////////////////////////////////////////////////////////

;*****************************************************************************
;                          INITIALISATIONS                                   *
;*****************************************************************************
init

			; initialisation PORTS (banque 0 et 1)
			; ------------------------------------
	BANK0				; slectionner banque0
	clrf	PORTA			; Sorties PORTA  0
	clrf	PORTB			; sorties PORTB  0
	BANK1				; passer en banque1
	movlw	DIRPORTA		; Direction PORTA
	movwf	TRISA			; criture dans registre direction
	movlw	DIRPORTB		; Direction PORTB
	movwf	TRISB			; criture dans registre direction

			; Registre d'options (banque 1)
			; -----------------------------
	movlw	OPTIONVAL		; charger masque
	movwf	OPTION_REG		; initialiser registre option

			; registres interruptions (banque 1)
			; ----------------------------------
	movlw	INTCONVAL		; charger valeur registre interruption
	movwf	INTCON			; initialiser interruptions
	movlw	PIE1VAL			; Initialiser registre 
	movwf	PIE1			; interruptions priphriques 1
	movlw	VRCONVAL		; charger valeur registre interruption
	movwf	VRCON			; initialiser interruptions
	BANK0				; slectionner banque 0
	movlw	CMCONVAL		; charger valeur registre interruption
	movwf	CMCON			; initialiser interruptions

			; Effacer RAM banque 0
			; ---------------------
	BANK0				; slectionner banque 0
	movlw	0x20			; initialisation pointeur
	movwf	FSR		 	; d'adressage indirect
init1
	clrf	INDF			; effacer ram
	incf	FSR,f			; pointer sur suivant
	btfss	FSR,7			; tester si fin zone atteinte (>7F)
	goto	init1			; non, boucler

			; autoriser interruptions (banque 0)
			; ----------------------------------
	clrf	PIR1			; effacer flags 1
	bsf	INTCON,GIE		; valider interruptions
	goto	start			; programme principal


;*****************************************************************************
;                      PROGRAMME PRINCIPAL                                   *
;*****************************************************************************

start

	clrwdt				; effacer watch dog
	bsf	LED1			; allumer la led
	call	PDelay			; attendre 500mS
	bcf	LED1			; etteindre la led
	call	PDelay			; attendre 500mS
	goto 	start			; boucler

;*****************************************************************************
;                      SOUS ROUTINE TEMPO                                    *
;*****************************************************************************

;-------------------------------------------------------------
; Code generated by PDEL  ver 1.0  on 29/08/2008 at 00:14:33
; Description: Waits 500000 cycles 500mS
;-------------------------------------------------------------
PDelay  movlw     .239      ; 1 set number of repetitions (B)
        movwf     PDel0     ; 1 |
PLoop1  movlw     .232      ; 1 set number of repetitions (A)
        movwf     PDel1     ; 1 |
PLoop2  clrwdt              ; 1 clear watchdog
PDelL1  goto PDelL2         ; 2 cycles delay
PDelL2  goto PDelL3         ; 2 cycles delay
PDelL3  clrwdt              ; 1 cycle delay
        decfsz    PDel1, 1  ; 1 + (1) is the time over? (A)
        goto      PLoop2    ; 2 no, loop
        decfsz    PDel0,  1 ; 1 + (1) is the time over? (B)
        goto      PLoop1    ; 2 no, loop
PDelL4  goto PDelL5         ; 2 cycles delay
PDelL5  goto PDelL6         ; 2 cycles delay
PDelL6  goto PDelL7         ; 2 cycles delay
PDelL7  clrwdt              ; 1 cycle delay
        return              ; 2+2 Done
;-------------------------------------------------------------

	END 				; directive fin de programme

