Attribute VB_Name = "Module_ini"
Private Const MAX_PATH = 260
Private Const FILE_ATTRIBUTE_DIRECTORY = &H10
Private Const INVALID_HANDLE_VALUE = -1

Private Type FILETIME
    dwLowDateTime As Long
    dwHighDateTime As Long
End Type

Private Type WIN32_FIND_DATA
    dwFileAttributes As Long
    ftCreationTime As FILETIME
    ftLastAccessTime As FILETIME
    ftLastWriteTime As FILETIME
    nFileSizeHigh As Long
    nFileSizeLow As Long
    dwReserved0 As Long
    dwReserved1 As Long
    cFileName As String * MAX_PATH
    cAlternate As String * 14
End Type

Private Declare Function FindFirstFile _
    Lib "kernel32" _
    Alias "FindFirstFileA" _
    ( _
    ByVal lpFileName As String, _
    lpFindFileData As WIN32_FIND_DATA _
    ) _
As Long
Private Declare Function FindClose _
    Lib "kernel32" _
    ( _
    ByVal hFindFile As Long _
    ) _
    As Long











'declarations for working with Ini files
Private Declare Function GetPrivateProfileSection Lib "kernel32" Alias _
"GetPrivateProfileSectionA" (ByVal lpAppName As String, ByVal lpReturnedString As String, _
ByVal nSize As Long, ByVal lpFileName As String) As Long

Private Declare Function GetPrivateProfileString Lib "kernel32" Alias _
"GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, _
ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, _
ByVal lpFileName As String) As Long

Private Declare Function WritePrivateProfileSection Lib "kernel32" Alias _
"WritePrivateProfileSectionA" (ByVal lpAppName As String, ByVal lpString As String, _
ByVal lpFileName As String) As Long

Private Declare Function WritePrivateProfileString Lib "kernel32" Alias _
"WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, _
ByVal lpString As Any, ByVal lpFileName As String) As Long

'// INI CONTROLLING PROCEDURES
'reads an Ini string
Public Function ReadIni(Filename As String, section As String, Key As String) As String
Dim RetVal As String * 255, v As Long
v = GetPrivateProfileString(section, Key, "", RetVal, 255, Filename)
If v Then
    ReadIni = Left(RetVal, v)
Else
    ReadIni = ""
End If
End Function

'reads an Ini section
Public Function ReadIniSection(Filename As String, section As String) As String
Dim RetVal As String * 255, v As Long
v = GetPrivateProfileSection(section, RetVal, 255, Filename)
ReadIniSection = Left(RetVal, v - 1)
End Function

'writes an Ini string
Public Sub WriteIni(Filename As String, section As String, Key As String, Value As String)
WritePrivateProfileString section, Key, Value, Filename
End Sub

'writes an Ini section
Public Sub WriteIniSection(Filename As String, section As String, Value As String)
WritePrivateProfileSection section, Value, Filename
End Sub


Public Sub GetIni()

Dim File As String, OFLen As Double, str As String
Dim str2 As String

    File = "C:\Servo.ini"
If FileExists("C:\Servo.ini") = True Then
    OFLen = FileLen(File)
Else
    'write a few example sections:
    WriteIniSection File, "recent", ""
'    WriteIniSection File, "recent2", "file 2"
    'write a few ini strings
    WriteIni File, "recent", "recent1", ""
    WriteIni File, "recent", "recent2", ""
    WriteIni File, "recent", "recent3", ""
    WriteIni File, "recent", "recent4", ""

    'test message - inform we've written the data
'    MsgBox Format((FileLen(File) - OFLen) / 1024, "0.00") & " KB data written to " & Chr(34) & File & Chr(34)
End If

'read the ini file
Form1.Combo2.Clear

str = ""
'str = ReadIni(File, "recent", "recent1")

str = MyReadIni(File, "recent", "recent1")
i = Form1.SetStrRecent(0, str)
Form1.Combo2.AddItem str
str = MyReadIni(File, "recent", "recent2")
i = Form1.SetStrRecent(1, str)
Form1.Combo2.AddItem str
str = MyReadIni(File, "recent", "recent3")
i = Form1.SetStrRecent(2, str)
Form1.Combo2.AddItem str
str = MyReadIni(File, "recent", "recent4")
i = Form1.SetStrRecent(3, str)
Form1.Combo2.AddItem str
Form1.Combo2.ListIndex = 0

str = ReadIni(File, "COM", "com")
Form1.SetCom (str)
If str = "COM1" Then Comset = 1: Form1.Option1(0).Value = True
If str = "COM2" Then Comset = 2: Form1.Option1(1).Value = True
If str = "COM3" Then Comset = 3: Form1.Option1(2).Value = True
If str = "COM4" Then Comset = 4: Form1.Option1(3).Value = True


End Sub

Function FileExists(ByVal sFileName As String) As Boolean
    Dim hFind As Long, udtFindData As WIN32_FIND_DATA
      
    'Recherche du fichier spcifi
    hFind = FindFirstFile(sFileName, udtFindData)
      
    'On teste la russite de la recherche
    If hFind <> INVALID_HANDLE_VALUE Then
        'Le fichier n'existe que s'il n'est pas un dossier
        FileExists = (udtFindData.dwFileAttributes And FILE_ATTRIBUTE_DIRECTORY) = 0
          
        'Fermeture du handle pour librer la mmoire
        FindClose hFind
    End If
End Function
Function MyReadIni(ByVal sFileName As String, section As String, ini As String) As String
Dim str As String
Dim p As Integer

Open sFileName For Input As #1

myLoop1:
If EOF(1) = True Then
    Close #1
    Exit Function
 End If
 
 Line Input #1, str
 p = InStr(str, section)
 If p <> 0 Then
myLoop:
    If EOF(1) = True Then
        Close #1
        Exit Function
    End If
         Line Input #1, str
         p = InStr(str, ini)
         If p <> 0 Then
            p = InStr(str, "=")
            MyReadIni = Mid$(str, p + 1, Len(str) - p)
            Close #1
            Exit Function
         End If
      GoTo myLoop
      End If
GoTo myLoop1
Close #1
End Function
